<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!--begin::Page Custom Styles(used by this page) -->
<link href="<?php echo base_url('resources');?>/assets/css/pages/todo/todo.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

       <?php topToolBarTask();?>

        <!-- begin:: Content -->
        <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

            <!--Begin::Tasks-->
            <div class="kt-grid kt-grid--desktop kt-grid--ver-desktop  kt-todo" id="kt_todo">

                <!--Begin::Aside Mobile Toggle-->
                <button class="kt-todo__aside-close" id="kt_todo_aside_close">
                    <i class="la la-close"></i>
                </button>

                <!--End:: Aside Mobile Toggle-->

                <!--Begin:: Tasks Aside-->
                <div class="kt-grid__item   kt-portlet kt-todo__aside" id="kt_todo_aside">
                    <div class="kt-todo__nav">
                        <ul class="kt-nav">
                            <li class="kt-nav__item">
                                <a href="<?php echo base_url('task');?>" class="kt-nav__link" data-action="list" data-type="inbox">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24" />
                                            <path d="M2.56066017,10.6819805 L4.68198052,8.56066017 C5.26776695,7.97487373 6.21751442,7.97487373 6.80330086,8.56066017 L8.9246212,10.6819805 C9.51040764,11.267767 9.51040764,12.2175144 8.9246212,12.8033009 L6.80330086,14.9246212 C6.21751442,15.5104076 5.26776695,15.5104076 4.68198052,14.9246212 L2.56066017,12.8033009 C1.97487373,12.2175144 1.97487373,11.267767 2.56066017,10.6819805 Z M14.5606602,10.6819805 L16.6819805,8.56066017 C17.267767,7.97487373 18.2175144,7.97487373 18.8033009,8.56066017 L20.9246212,10.6819805 C21.5104076,11.267767 21.5104076,12.2175144 20.9246212,12.8033009 L18.8033009,14.9246212 C18.2175144,15.5104076 17.267767,15.5104076 16.6819805,14.9246212 L14.5606602,12.8033009 C13.9748737,12.2175144 13.9748737,11.267767 14.5606602,10.6819805 Z" fill="#000000" opacity="0.3" />
                                            <path d="M8.56066017,16.6819805 L10.6819805,14.5606602 C11.267767,13.9748737 12.2175144,13.9748737 12.8033009,14.5606602 L14.9246212,16.6819805 C15.5104076,17.267767 15.5104076,18.2175144 14.9246212,18.8033009 L12.8033009,20.9246212 C12.2175144,21.5104076 11.267767,21.5104076 10.6819805,20.9246212 L8.56066017,18.8033009 C7.97487373,18.2175144 7.97487373,17.267767 8.56066017,16.6819805 Z M8.56066017,4.68198052 L10.6819805,2.56066017 C11.267767,1.97487373 12.2175144,1.97487373 12.8033009,2.56066017 L14.9246212,4.68198052 C15.5104076,5.26776695 15.5104076,6.21751442 14.9246212,6.80330086 L12.8033009,8.9246212 C12.2175144,9.51040764 11.267767,9.51040764 10.6819805,8.9246212 L8.56066017,6.80330086 C7.97487373,6.21751442 7.97487373,5.26776695 8.56066017,4.68198052 Z" fill="#000000" />
                                        </g>
                                    </svg> <span class="kt-nav__link-text">System Task</span>
                                    </span>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="javascript:loadTaskPending();" class="kt-nav__link" data-action="list" data-type="draft">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24" />
                                            <rect fill="#000000" x="4" y="4" width="7" height="7" rx="1.5" />
                                            <path d="M5.5,13 L9.5,13 C10.3284271,13 11,13.6715729 11,14.5 L11,18.5 C11,19.3284271 10.3284271,20 9.5,20 L5.5,20 C4.67157288,20 4,19.3284271 4,18.5 L4,14.5 C4,13.6715729 4.67157288,13 5.5,13 Z M14.5,4 L18.5,4 C19.3284271,4 20,4.67157288 20,5.5 L20,9.5 C20,10.3284271 19.3284271,11 18.5,11 L14.5,11 C13.6715729,11 13,10.3284271 13,9.5 L13,5.5 C13,4.67157288 13.6715729,4 14.5,4 Z M14.5,13 L18.5,13 C19.3284271,13 20,13.6715729 20,14.5 L20,18.5 C20,19.3284271 19.3284271,20 18.5,20 L14.5,20 C13.6715729,20 13,19.3284271 13,18.5 L13,14.5 C13,13.6715729 13.6715729,13 14.5,13 Z" fill="#000000" opacity="0.3" />
                                        </g>
                                    </svg> <span class="kt-nav__link-text">Pending Task</span>
                                    <span class="kt-nav__link-badge">
                                        <span class="kt-badge kt-badge--unified-danger kt-badge--md kt-badge--rounded kt-badge--boldest"><?php echo $tasksmecount;?></span>
                                    </span>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="javascript:loadTaskOngoing();" class="kt-nav__link" data-action="list" data-type="draft">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24" />
                                            <path d="M5,3 L6,3 C6.55228475,3 7,3.44771525 7,4 L7,20 C7,20.5522847 6.55228475,21 6,21 L5,21 C4.44771525,21 4,20.5522847 4,20 L4,4 C4,3.44771525 4.44771525,3 5,3 Z M10,3 L11,3 C11.5522847,3 12,3.44771525 12,4 L12,20 C12,20.5522847 11.5522847,21 11,21 L10,21 C9.44771525,21 9,20.5522847 9,20 L9,4 C9,3.44771525 9.44771525,3 10,3 Z" fill="#000000" />
                                            <rect fill="#000000" opacity="0.3" transform="translate(17.825568, 11.945519) rotate(-19.000000) translate(-17.825568, -11.945519) " x="16.3255682" y="2.94551858" width="3" height="18" rx="1" />
                                        </g>
                                    </svg> <span class="kt-nav__link-text">OnGoing Task</span>
                                    <span class="kt-nav__link-badge">
                                        <span class="kt-badge kt-badge--unified-info kt-badge--md kt-badge--rounded kt-badge--boldest"><?php echo $ongoingmecount;?></span>
                                    </span>
                                </a>
                            </li>
                            <li class="kt-nav__item  kt-nav__item--active">
                                <a href="javascript:loadTaskCompleted();" class="kt-nav__link" data-placement="right">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24" />
                                            <path d="M8,3 L8,3.5 C8,4.32842712 8.67157288,5 9.5,5 L14.5,5 C15.3284271,5 16,4.32842712 16,3.5 L16,3 L18,3 C19.1045695,3 20,3.8954305 20,5 L20,21 C20,22.1045695 19.1045695,23 18,23 L6,23 C4.8954305,23 4,22.1045695 4,21 L4,5 C4,3.8954305 4.8954305,3 6,3 L8,3 Z" fill="#000000" opacity="0.3" />
                                            <path d="M10.875,15.75 C10.6354167,15.75 10.3958333,15.6541667 10.2041667,15.4625 L8.2875,13.5458333 C7.90416667,13.1625 7.90416667,12.5875 8.2875,12.2041667 C8.67083333,11.8208333 9.29375,11.8208333 9.62916667,12.2041667 L10.875,13.45 L14.0375,10.2875 C14.4208333,9.90416667 14.9958333,9.90416667 15.3791667,10.2875 C15.7625,10.6708333 15.7625,11.2458333 15.3791667,11.6291667 L11.5458333,15.4625 C11.3541667,15.6541667 11.1145833,15.75 10.875,15.75 Z" fill="#000000" />
                                            <path d="M11,2 C11,1.44771525 11.4477153,1 12,1 C12.5522847,1 13,1.44771525 13,2 L14.5,2 C14.7761424,2 15,2.22385763 15,2.5 L15,3.5 C15,3.77614237 14.7761424,4 14.5,4 L9.5,4 C9.22385763,4 9,3.77614237 9,3.5 L9,2.5 C9,2.22385763 9.22385763,2 9.5,2 L11,2 Z" fill="#000000" />
                                        </g>
                                    </svg> <span class="kt-nav__link-text">Completed Tasks</span>
                                    <span class="kt-nav__link-badge">
                                        <span class="kt-badge kt-badge--unified-success kt-badge--md kt-badge--rounded kt-badge--boldest"><?php echo $completemecount;?></span>
                                    </span>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="javascript:loadPrivateTask();" class="kt-nav__link" data-action="list" data-type="draft">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24" />
                                            <path d="M5,3 L6,3 C6.55228475,3 7,3.44771525 7,4 L7,20 C7,20.5522847 6.55228475,21 6,21 L5,21 C4.44771525,21 4,20.5522847 4,20 L4,4 C4,3.44771525 4.44771525,3 5,3 Z M10,3 L11,3 C11.5522847,3 12,3.44771525 12,4 L12,20 C12,20.5522847 11.5522847,21 11,21 L10,21 C9.44771525,21 9,20.5522847 9,20 L9,4 C9,3.44771525 9.44771525,3 10,3 Z" fill="#000000" />
                                            <rect fill="#000000" opacity="0.3" transform="translate(17.825568, 11.945519) rotate(-19.000000) translate(-17.825568, -11.945519) " x="16.3255682" y="2.94551858" width="3" height="18" rx="1" />
                                        </g>
                                    </svg> <span class="kt-nav__link-text">Private Task</span>
                                    <span class="kt-nav__link-badge">
                                        <span class="kt-badge kt-badge--unified-warning kt-badge--md kt-badge--rounded kt-badge--boldest"><?php echo $privatecount;?></span>
                                    </span>
                                </a>
                            </li>
                            <li class="kt-nav__item  kt-nav__item--active">
                                <a href="#myTask" data-toggle="modal" data-backdrop="false" class="kt-nav__link" data-placement="right">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect x="0" y="0" width="24" height="24" />
                                            <path d="M8,3 L8,3.5 C8,4.32842712 8.67157288,5 9.5,5 L14.5,5 C15.3284271,5 16,4.32842712 16,3.5 L16,3 L18,3 C19.1045695,3 20,3.8954305 20,5 L20,21 C20,22.1045695 19.1045695,23 18,23 L6,23 C4.8954305,23 4,22.1045695 4,21 L4,5 C4,3.8954305 4.8954305,3 6,3 L8,3 Z" fill="#000000" opacity="0.3" />
                                            <path d="M10.875,15.75 C10.6354167,15.75 10.3958333,15.6541667 10.2041667,15.4625 L8.2875,13.5458333 C7.90416667,13.1625 7.90416667,12.5875 8.2875,12.2041667 C8.67083333,11.8208333 9.29375,11.8208333 9.62916667,12.2041667 L10.875,13.45 L14.0375,10.2875 C14.4208333,9.90416667 14.9958333,9.90416667 15.3791667,10.2875 C15.7625,10.6708333 15.7625,11.2458333 15.3791667,11.6291667 L11.5458333,15.4625 C11.3541667,15.6541667 11.1145833,15.75 10.875,15.75 Z" fill="#000000" />
                                            <path d="M11,2 C11,1.44771525 11.4477153,1 12,1 C12.5522847,1 13,1.44771525 13,2 L14.5,2 C14.7761424,2 15,2.22385763 15,2.5 L15,3.5 C15,3.77614237 14.7761424,4 14.5,4 L9.5,4 C9.22385763,4 9,3.77614237 9,3.5 L9,2.5 C9,2.22385763 9.22385763,2 9.5,2 L11,2 Z" fill="#000000" />
                                        </g>
                                    </svg> <span class="kt-nav__link-text">My Tasks</span>
                                    <span class="kt-nav__link-badge">
                                        <span class="kt-badge kt-badge--unified-success kt-badge--md kt-badge--rounded kt-badge--boldest"><?php echo $tasksmecount;?></span>
                                    </span>
                                </a>
                            </li>

                            <li class="kt-nav__item kt-margin-t-20 kt-margin-b-20">
                                <span class="kt-nav__link-title">Ongoing Projects</span>
                            </li>

                            <?php if(!empty($oprojects)):
                            foreach($oprojects as $hero):?>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link" data-action="list" data-type="marked">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-nav__link-icon">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24" />
                                            <path d="M12.2928955,6.70710318 C11.9023712,6.31657888 11.9023712,5.68341391 12.2928955,5.29288961 C12.6834198,4.90236532 13.3165848,4.90236532 13.7071091,5.29288961 L19.7071091,11.2928896 C20.085688,11.6714686 20.0989336,12.281055 19.7371564,12.675721 L14.2371564,18.675721 C13.863964,19.08284 13.2313966,19.1103429 12.8242777,18.7371505 C12.4171587,18.3639581 12.3896557,17.7313908 12.7628481,17.3242718 L17.6158645,12.0300721 L12.2928955,6.70710318 Z" fill="#000000" fill-rule="nonzero" />
                                            <path d="M3.70710678,15.7071068 C3.31658249,16.0976311 2.68341751,16.0976311 2.29289322,15.7071068 C1.90236893,15.3165825 1.90236893,14.6834175 2.29289322,14.2928932 L8.29289322,8.29289322 C8.67147216,7.91431428 9.28105859,7.90106866 9.67572463,8.26284586 L15.6757246,13.7628459 C16.0828436,14.1360383 16.1103465,14.7686056 15.7371541,15.1757246 C15.3639617,15.5828436 14.7313944,15.6103465 14.3242754,15.2371541 L9.03007575,10.3841378 L3.70710678,15.7071068 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(9.000003, 11.999999) rotate(-270.000000) translate(-9.000003, -11.999999) " />
                                        </g>
                                    </svg> <span class="kt-nav__link-text"><?php echo $hero['project_title'];?></span>
                                </a>
                            </li>
                            <?php endforeach; endif;?>
                            <li class="kt-nav__item">
                                <a href="<?php echo base_url('projects/ongoing');?>" class="kt-nav__link">
                                    <i class="kt-nav__link-icon fa flaticon2-open-text-book"></i>
                                    <span class="kt-nav__link-text">View All</span>
                                </a>
                            </li>
                            <li class="kt-nav__item">
                                <a href="#newProject" data-toggle="modal" data-backdrop="false" class="kt-nav__link" data-action="list" data-type="trash">
                                    <i class="kt-nav__link-icon kt-nav__link-icon--size fa flaticon2-plus"></i>
                                    <span class="kt-nav__link-text">Add Project</span>
                                </a>
                            </li>


                            <li class="kt-nav__item kt-margin-t-20 kt-margin-b-20">
                                <span class="kt-nav__link-title">Fineshed Projects</span>
                            </li>
                            <?php if(!empty($fprojects)):
                            foreach($fprojects as $hero):?>
                            <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                    <i class="kt-nav__link-icon fa fa-genderless kt-font-success"></i>
                                    <span class="kt-nav__link-text"><?php echo $hero['project_title'];?></span>
                                </a>
                            </li>
                            <?php endforeach; endif;?>
                            <li class="kt-nav__item">
                                <a href="<?php echo base_url('projects/finished');?>" class="kt-nav__link">
                                    <i class="kt-nav__link-icon fa flaticon2-open-text-book"></i>
                                    <span class="kt-nav__link-text">View All</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!--End:: Tasks Aside-->

                <!--Begin:: Tasks Content-->
                <div class="kt-grid__item kt-grid__item--fluid kt-todo__content" id="kt_todo_content">
                    <div class="kt-todo__tasks-top">
                        <div class="kt-portlet">

                            <!--Begin:: Tasks Toolbar-->
                            <div class="kt-todo__header">
                                <h3 class="kt-todo__title">Task Management</h3>

                                <!--Begin:: Tasks Nav-->
                                <div class="kt-todo__nav">
                                    <a href="javascript:;" class="kt-todo__link kt-todo__link--active">Full Tasks Details</a>
                                </div>
                                <!--End:: Tasks Nav-->

                                <!--Begin:: Tasks Users-->
                                <div class="kt-todo__users">
                                    <?php if(!empty($lmwc = myTaskUserLM())){
                                        foreach ($lmwc as $key => $task) {?>
                                            <?php if(file_exists(uploadPath('profile_pictures/').$task['avatar'])){?>
                                                <a href="#" class="kt-media kt-media--xs" data-toggle="kt-tooltip" data-placement="top" title="" data-original-title="Nick Mana">
                                                    <img src="<?php echo uploadFilePath('profile_pictures/').$task['avatar'];?>" alt="image">
                                                </a>
                                            <?php }else{?>
                                                <a href="#" class="kt-media kt-media--xs kt-media--danger" data-toggle="kt-tooltip" data-placement="top" title="" data-original-title="Sean Stone">
                                                    <span><?php echo strtoupper($task['firstname'][0].' '.$task['lastname'][0]);?></span>
                                                </a>
                                            <?php  }?>
                                        <?php } }?>
                                </div>

                                <!--End:: Tasks Users-->
                            </div>

                            <!--End:: Tasks Toolbar-->
                        </div>
                    </div>
                    <div class="kt-todo__tasks-bottom">
                        <div class="row">

                            <div class="col-xl-12" id="detailsTask">

                                <!--Begin:: Inbox View-->
                                <div class="kt-grid__item kt-grid__item--fluid  kt-portlet kt-portlet--height-fluid kt-todo__view" id="kt_todo_view">

                                    <!--Begin:: Portlet Body-->
                                    <div class="kt-portlet__body kt-portlet__body--fit-y">

                                        <!--Begin:: Wrapper-->
                                        <div class="kt-todo__wrapper">

                                            <!--Begin:: Head-->
                                            <div class="kt-todo__head">
                                                <div class="kt-todo__toolbar">
                                                    <div class="kt-todo__info">
                                                        <span class="kt-media kt-media--sm" data-toggle="expand" style="background-image: url('<?php echo base_url('uploads/profile_pictures/'.$data->avatar);?>')">
                                                            <span></span>
                                                        </span>
                                                        <a href="javascript:;" class="kt-todo__name">
                                                            <?php echo $data->firstname?> <?php echo $data->lastname;?>
                                                        </a>
                                                    </div>
                                                    <div class="kt-todo__details">
                                                        <a href="<?php echo base_url('task');?>" class="kt-todo__icon kt-todo__icon--back">
                                                            <i class="flaticon2-left-arrow-1"></i>
                                                        </a>
                                                        <a href="#" class="kt-todo__icon" data-toggle="kt-tooltip" title="Archive" hidden>
                                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                    <rect x="0" y="0" width="24" height="24" />
                                                                    <path d="M6,2 L18,2 C18.5522847,2 19,2.44771525 19,3 L19,12 C19,12.5522847 18.5522847,13 18,13 L6,13 C5.44771525,13 5,12.5522847 5,12 L5,3 C5,2.44771525 5.44771525,2 6,2 Z M7.5,5 C7.22385763,5 7,5.22385763 7,5.5 C7,5.77614237 7.22385763,6 7.5,6 L13.5,6 C13.7761424,6 14,5.77614237 14,5.5 C14,5.22385763 13.7761424,5 13.5,5 L7.5,5 Z M7.5,7 C7.22385763,7 7,7.22385763 7,7.5 C7,7.77614237 7.22385763,8 7.5,8 L10.5,8 C10.7761424,8 11,7.77614237 11,7.5 C11,7.22385763 10.7761424,7 10.5,7 L7.5,7 Z" fill="#000000" opacity="0.3" />
                                                                    <path d="M3.79274528,6.57253826 L12,12.5 L20.2072547,6.57253826 C20.4311176,6.4108595 20.7436609,6.46126971 20.9053396,6.68513259 C20.9668779,6.77033951 21,6.87277228 21,6.97787787 L21,17 C21,18.1045695 20.1045695,19 19,19 L5,19 C3.8954305,19 3,18.1045695 3,17 L3,6.97787787 C3,6.70173549 3.22385763,6.47787787 3.5,6.47787787 C3.60510559,6.47787787 3.70753836,6.51099993 3.79274528,6.57253826 Z" fill="#000000" />
                                                                </g>
                                                            </svg> </a>

                                                        <a hidden href="javascript:(0);" onclick="deleteTasks(<?php echo $data->task_key?>)" class="kt-todo__icon" data-toggle="kt-tooltip" title="Delete">
                                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                    <rect x="0" y="0" width="24" height="24" />
                                                                    <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero" />
                                                                    <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3" />
                                                                </g>
                                                            </svg> </a>
                                                        New SubTask <a href="#newSubTask" class="kt-media kt-media--xs  kt-bg-success kt-margin-l-10" data-target="#newSubTask" data-backdrop="false" data-toggle="modal" data-placement="top" title="" data-original-title="Add Participants">
                                                            <span><i class="kt-nav__link-icon fa flaticon2-plus kt-font-light"></i></span>
                                                        </a> &nbsp;

                                                       | Dedline: <button type="button" class="btn btn-label-danger btn-upper btn-sm btn-bold"><?php echo $data->task_deadline?></button>

                                                        <?php if ($data->task_status == 'Pending') { ?>
                                                            <button type="button" class="btn btn-label-danger btn-upper btn-sm btn-bold"><?php echo $data->task_status?></button>
                                                        <?php } ?>
                                                        <?php if ($data->task_status == 'Completed') { ?>
                                                            <button type="button" class="btn btn-label-success btn-upper btn-sm btn-bold"><?php echo $data->task_status?></button>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--End:: Head-->

                                            <!--Begin:: Body-->
                                            <div class="kt-todo__body">
                                                <div class="kt-todo__title">
                                                    <a href="javascript:;" class="kt-todo__text"><?php echo $data->project_title?></a>
                                                    <div class="kt-todo__labels">
                                                        <span class="kt-todo__label">
                                                            <i class="kt-todo__dot fa fa-genderless kt-font-info"></i>
                                                            <span class="kt-todo__text"><?php echo $data->task_status?></span>
                                                        </span>
                                                        <?php if ($data->task_mode == 'Urgent') { ?>
                                                        <span class="kt-todo__label">
                                                            <i class="kt-todo__dot fa fa-genderless kt-font-danger"></i>
                                                            <span class="kt-todo__text"><?php echo $data->task_mode?></span>
                                                        </span>
                                                        <?php } ?>
                                                        <?php if ($data->task_mode == 'Normal') { ?>
                                                        <span class="kt-todo__label">
                                                            <i class="kt-todo__dot fa fa-genderless kt-font-success"></i>
                                                            <span class="kt-todo__text"><?php echo $data->task_mode?></span>
                                                        </span>
                                                        <?php } ?>

                                                    </div>
                                                </div>
                                                <div class="kt-todo__desc">
                                                    <?php echo $data->task_desc?>
                                                </div>
                                                <div class="kt-todo__files">
                                                    <?php  if(!empty($subtask)){
                                                    foreach ($subtask as $key => $row) {  $key++;?>
                                                    <span class="kt-todo__file">
                                                        <i class="flaticon2-clip-symbol kt-font-warning"></i>
                                                        <a href="javascript:;"><?php echo $row['task_det_task_desc'];?></a><br>
                                                        <i class="flaticon2-user kt-font-success"></i>
                                                        <a href="javascript:;"><?php echo $row['firstname'];?> <?php echo $row['lastname'];?></a>&nbsp;
                                                        <?php if ($row['task_det_task_status'] == 'Completed') { ?>
                                                        <a href="javascript:;"><i class="flaticon2-file kt-font-success"></i><?php echo $row['task_det_task_status'];?></a>
                                                        <?php } ?>
                                                        <?php if ($row['task_det_task_status'] == 'Pending') { ?>
                                                        <a href="javascript:;"><i class="flaticon2-file kt-font-danger"></i><?php echo $row['task_det_task_status'];?></a>
                                                        <?php } ?>
                                                        <?php if ($row['task_det_task_status'] == 'OnProgress') { ?>
                                                            <a href="javascript:;"><i class="flaticon2-file kt-font-info"></i><?php echo $row['task_det_task_status'];?></a>
                                                        <?php } ?> &nbsp;
                                                        <?php if ($row['task_det_task_status'] == 'OnProgress' || $row['task_det_task_status'] == 'Pending') { ?>
                                                        <a href="javascript:editSubTask(<?php echo $row['task_det_key'];?>)"><i class="flaticon2-pen kt-font-success"></i>Update</a>
                                                        <?php } ?> &nbsp;
                                                        <?php if ($row['task_det_task_status'] == 'OnProgress') { ?>
                                                        <a href="javascript:setPendingAdmin('<?php echo $row['task_det_key'];?>');"><i class="flaticon2-circular-arrow kt-font-danger"></i>Set Pending</a>
                                                        <?php } ?>
                                                        <?php if ($row['task_det_task_status'] == 'Pending' && $row['task_det_task_emp'] == profile()->user_key) { ?>
                                                        <a href="javascript:startTask('<?php echo $row['task_det_key'];?>');"><button type="button" class="btn btn-warning btn-sm">Start Task</button></a>
                                                        <?php } ?>
                                                        <?php if ($row['task_det_task_status'] == 'OnProgress' && $row['task_det_task_emp'] == $auth_user_id) { ?>
                                                        <a href="javascript:editPercentage(<?php echo $row['task_det_key'];?>)"><button type="button" class="btn btn-info btn-sm">Update Percentage</button></a>
                                                        <?php } ?>
                                                    </span><hr>
                                                    <?php } } ?>

                                                </div>
                                                <h4><center>Comments</center></h4>
                                                <div class="kt-todo__comments" style="overflow-y: scroll; height:300px;">
                                                    <?php  if(!empty($comment)){
                                                    foreach ($comment as $key => $row) {  $key++;?>
                                                    <div class="kt-todo__comment" id="comment">
                                                        <div class="kt-todo__box">
                                                            <span class="kt-media kt-media--sm" data-toggle="expand" style="background-image: url('assets/media/users/100_1.jpg')">
                                                                <span></span>
                                                            </span>
                                                            <a href="#" class="kt-todo__username"><img class="img-circle" style="max-height: 20px; width: 20px;" src="<?php echo uploadFilePath('profile_pictures/').$row['avatar'];?>" alt="image">&nbsp;<?php echo $row['firstname'];?> <?php echo $row['lastname'];?></a>
                                                            <span class="kt-todo__date"><?php echo timeAgo($row['comment_date_create']);?></span>
                                                        </div>
                                                        <span class="kt-todo__text"><?php echo $row['comment_task_comment'];?></span>
                                                    </div>
                                                    <?php } } ?>

                                                </div>
                                            </div>

                                            <!--End:: Body-->

                                            <!--Begin:: Foot-->
                                            <form id="commentForm" action="#" method="get" onsubmit="return false">
                                            <div class="kt-todo__foot">
                                                <div class="kt-todo__form" id="kt_todo_post_form">
                                                    <input hidden type="text" value="<?php echo $data->task_key?>" name="comment_task_key">
                                                    <div class="kt-todo__body">
                                                        <textarea data-provide="markdown" class="form-control" name="comment_task_comment" placeholder="write comment..."></textarea>
                                                    </div>
                                                    <div class="kt-todo__foot">
                                                        <div class="kt-todo__primary">
                                                            <div class="btn-group">
                                                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            </form>
                                            <!--End:: Foot-->
                                        </div>

                                        <!--End:: Wrapper-->
                                    </div>

                                    <!--End:: Portlet Body-->
                                </div>

                                <!--End:: Inbox View-->
                            </div>

                        </div>
                    </div>
                </div>

                <!--End:: Tasks Content-->
            </div>
            <!--End::Tasks-->

        </div>
        <!-- end:: Content -->
    </div>


<div class="modal fade- modal-sticky-top-right" id="taskDetails" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Update Task</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>

<div class="modal fade- modal-sticky-top-right" id="subtaskDetails" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Update Sub-Task</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>

<div class="modal fade- modal-sticky-top-left" id="projectDetails" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Update Project</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>

<div class="modal fade- modal-sticky-top-left" id="newProject" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Create New Project</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <form id="newProject" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
                <div class="form-group row">
                    <div class="col-lg-4 col-md-9 col-sm-12">
                        <input hidden class="form-control" id="kt_timepicker_1" readonly name="project_time_created" type="text" />
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row form-group">
                        <div class="col-6">
                            <label>Project Title</label>
                            <input type="text" required name="project_title" placeholder="Project Title " class="form-control"/>
                        </div>
                        <div class="col-6">
                            <label>Project Client</label>
                            <input type="text" name="project_client" placeholder="Project Client" class="form-control"/>
                        </div>
                    </div>

                    <div class="row form-group">
                        <div class="col-6">
                            <label>Project Deadline</label>
                            <input type="date" name="project_deadline" placeholder="Project Deadline " class="form-control"/>
                        </div>
                        <div class="col-6">
                            <label>Project Budget</label>
                            <input type="text" name="project_budget" placeholder="Project Budget" class="form-control number" />
                        </div>
                    </div>

                    <div class="row form-group">
                        <div class="col-6">
                            <label>Project Start</label>
                            <input type="date" name="project_start_date" placeholder="Project Start Date " class="form-control"/>
                        </div>
                        <div class="col-6">
                            <label>Project End</label>
                            <input type="date" name="project_end_date" placeholder="Project End Date" class="form-control" />
                        </div>
                    </div>

                    <div class="form-group m-form__group row">
                        <label >Project Description</label>
                        <div class="col-md-12">
                            <textarea data-provide="markdown" class="form-control" name="project_desc"></textarea>
                        </div>
                    </div>
                    <div class="row form-group">
                        <label >Client Logo</label>
                        <div class="col-12">
                            <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                <div class="m-dropzone__msg dz-message needsclick">
                                    <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                    <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
                    <button type="submit" name="submit" class="btn btn-success">Submit</button>
                </div>
                <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
            </form>
        </div>
    </div>
</div>

<div class="modal fade- modal-sticky-top-right" id="newSubTask" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Assign Sub-Task</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">
                <form id="newSubTaskAdmin" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">

                    <div class="modal-body">
                        <div class="row form-group">
                            <div class="col-6">
                                <label>Responsible Person</label>
                                <select class="form-control kt-select2" id="kt_select2_3_modal" name="task_det_task_emp">
                                    <option disabled>Select Employee</option>
                                    <?php if(!empty($employees)):
                                        foreach($employees as $emp):?>
                                            <option value="<?php echo $emp['user_id'];?>" selected><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                                        <?php endforeach; endif;?>
                                </select>
                            </div>
                            <div class="col-6">
                                <label>Task Mode</label>
                                <select class="form-control kt-select2" id="kt_select2_1_modal" name="task_det_task_mode">
                                    <option disabled>Select mode</option>
                                    <option value="Urgent">Urgent</option>
                                    <option value="Normal">Normal</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group m-form__group row">
                            <label >Task Description</label>
                            <div class="col-md-12">
                                <textarea data-provide="markdown" class="form-control" name="task_det_task_desc"></textarea>
                            </div>
                        </div>

                        <input type="text" hidden name="task_det_project_key" value="<?php echo $data->task_project_key?>">
                        <input type="text" hidden name="task_det_task_key" value="<?php echo $data->task_key?>">
                        <input type="text" hidden name="task_det_task_start" value="<?php echo $data->task_start?>">
                        <input type="text" hidden name="task_det_task_deadline" value="<?php echo $data->task_deadline?>">

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-success">Submit</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<div class="modal fade- modal-sticky-top-right" id="taskPercentage" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Update Task Percentage</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>

<?php include VIEWPATH.'includes/footer.php';
include __DIR__.'/scripts.php';
?>
<script type="text/javascript">

    $('form#commentForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('task/index/commentTask/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Posting comment Task ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    //$("div#comment").load(<?php //echo base_url('task/index/taskDetails/'.$task_key);?>);
                    $("div#comment").load(window.location.href + " div#comment" );
                    //$("div#comment").load("div#comment");
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                    window.location.reload();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                //$('div#taskDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })

</script>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>

<!--begin::Page Scripts(used by this page) -->
<!--begin::Page Scripts(used by this page) -->
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/select2.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/plugins/custom/tinymce/tinymce.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/editors/tinymce.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-datetimepicker.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-timepicker.js" type="text/javascript"></script>


<div id="myTask" class="modal fade- modal-sticky-bottom-right">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">My Task List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="kt-quick-panel__nav">
                <ul class="nav nav-tabs nav-tabs-line nav-tabs-bold nav-tabs-line-3x nav-tabs-line-brand  kt-notification-item-padding-x" role="tablist">
                    <li class="nav-item active">
                        <a class="nav-link active" data-toggle="tab" href="#kt_quick_panel_tab_notifications" role="tab"><?php echo profile()->firstname;?> <?php echo profile()->lastname;?></a>
                    </li>
                </ul>
            </div>
            <div class="kt-quick-panel__content">
                <div class="tab-content">
                    <div class="tab-pane fade show kt-scroll active" id="kt_quick_panel_tab_notifications" role="tabpanel">
                        <div class="kt-notification">
                                <?php if(!empty($tasksme)): foreach($tasksme as $key=> $herome):
                                        $key++;?>
                                <a href="<?php echo base_url('task/mytask');?>" class="kt-notification__item">
                                    <div class="kt-notification__item-icon">
                                        <i class="flaticon2-open-box kt-font-success"></i>
                                    </div>
                                    <div class="kt-notification__item-details">
                                        <div class="kt-notification__item-title">
                                            <?php echo $herome['task_det_task_desc'];?>
                                        </div>
                                        <div class="kt-notification__item-time">
                                            <?php echo $herome['task_status'];?> | Deadline: <?php echo $herome['task_det_task_deadline'];?> | Created By: <?php echo $herome['firstname'];?> <?php echo $herome['lastname'];?>
                                        </div>
                                    </div>
                                </a>

                                <?php endforeach; endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>