<!--Begin:: Head-->
<div class="kt-todo__head">
    <div class="kt-todo__toolbar">
        <div class="kt-todo__info">
            <span class="kt-media kt-media--sm" data-toggle="expand" style="background-image: url('assets/media/users/100_13.jpg')">
                <span></span>
            </span>
            <a href="#" class="kt-todo__name"> Dave Stone</a>
        </div>
        <div class="kt-todo__details">
            <a href="#" class="kt-todo__icon kt-todo__icon--back">
                <i class="flaticon2-left-arrow-1"></i>
            </a>
            <a href="javascript:(0);" onclick="deleteTask(<?php echo $data->task_key?>)"  class="kt-todo__icon" data-toggle="kt-tooltip" title="Delete">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <rect x="0" y="0" width="24" height="24" />
                        <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero" />
                        <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3" />
                    </g>
                </svg> </a>
            <button type="button" class="btn btn-label-danger btn-upper btn-sm btn-bold"><?php echo $data->task_deadline?></button>
            <?php if ($data->task_status == 'Pending') { ?>
            <button type="button" class="btn btn-label-danger btn-upper btn-sm btn-bold"><?php echo $data->task_status?></button>
            <?php } ?>
            <?php if ($data->task_status == 'Completed') { ?>
                <button type="button" class="btn btn-label-success btn-upper btn-sm btn-bold"><?php echo $data->task_status?></button>
            <?php } ?>
        </div>
    </div>
</div>
<!--End:: Head-->

<!--Begin:: Body-->
<div class="kt-todo__body">
    <div class="kt-todo__title">
        <a href="#" class="kt-todo__text"><?php echo $data->project_title?></a>
        <div class="kt-todo__labels">
                <span class="kt-todo__label">
                    <i class="kt-todo__dot fa fa-genderless kt-font-info"></i>
                    <span class="kt-todo__text"><?php echo $data->task_status?></span>
                </span>
            <span class="kt-todo__label">
                <i class="kt-todo__dot fa fa-genderless kt-font-danger"></i>
                <span class="kt-todo__text"><?php echo $data->task_mode?></span>
            </span>
        </div>
    </div>
    <div class="kt-todo__desc">
        <?php echo $data->task_desc?>
    </div>

    <div class="kt-todo__comments">
        <div class="kt-todo__comment" id="comment">
            <div class="kt-todo__box">
                <span class="kt-media kt-media--sm" data-toggle="expand" style="background-image: url('assets/media/users/100_1.jpg')">
                    <span></span>
                </span>
                <a href="#" class="kt-todo__username">Comments</a>
            </div>
            <?php  if(! empty($comment)){
            foreach ($comment as $key => $row) {  $key++;?>
            <span class="kt-todo__text">
                <p class="kt-todo__username"><b>BY:<?php echo $row['firstname'];?> <?php echo $row['lastname'];?></b></p>
                <?php echo $row['comment_task_comment'];?>
            </span>
            <?php } } ?>



        </div>
    </div>
</div>
<!--End:: Body-->

<!--Begin:: Foot-->
<form id="commentForm" action="#" method="get" onsubmit="return false">
<div class="kt-todo__foot">
    <div class="kt-todo__form" id="kt_todo_post_form">

            <input hidden type="text" value="<?php echo $data->task_key?>" name="comment_task_key">
        <div class="kt-todo__body">
            <textarea data-provide="markdown" class="form-control" name="comment_task_comment" placeholder="write comment..."></textarea>
        </div>
        <div class="kt-todo__foot">
            <div class="kt-todo__primary">
                <div class="btn-group">
                    <button type="submit" name="submit" class="btn btn-success">Submit</button>
                </div>

            </div>

        </div>

    </div>
</div>
</form>

<!--End:: Foot-->

<script type="text/javascript">

    $('form#commentForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('task/index/commentTask/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Posting comment Task ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    //$("div#comment").load(<?php //echo base_url('task/index/taskDetails/'.$task_key);?>);
                    $("div#comment").load(window.location.href + " div#comment" );
                    //$("div#comment").load("div#comment");
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                //$('div#taskDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })

    function deleteTask(task){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('task/index/deleteTasks/task')?>/'+task,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Task ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + task).hide();
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_table_task');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }
</script>