<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyTaskForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="form-group row kt-margin-t-20">
            <label class="col-form-label col-lg-3 col-sm-12">Select Project</label>
            <div class="col-lg-9 col-md-9 col-sm-12">
                <select class="form-control kt-select2" id="kt_select2_1_modal" name="task_project_key">
                    <option disabled>Select Project</option>
                    <?php if(!empty($projects)):
                        foreach($projects as $hero):?>
                            <option value="<?php echo $hero['project_key'];?>"><?php echo $hero['project_title'];?></option>
                        <?php endforeach; endif;?>
                </select>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-form-label col-lg-3 col-sm-12">Responsible Person(s)</label>
            <div class="col-lg-9 col-md-9 col-sm-12">
                <select class="form-control kt-select2" id="kt_select2_3_modal" name="employees[]" multiple="multiple">
                    <option disabled>Select Employee(s)</option>
                    <?php if(!empty($employees)):
                        foreach($employees as $emp):?>
                            <option value="<?php echo $emp['user_id'];?>" selected><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                        <?php endforeach; endif;?>
                </select>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-form-label col-lg-3 col-sm-12">Task Deadline</label>
            <div class="col-lg-9 col-md-9 col-sm-12">
                <div class="input-group date">
                    <input type="text" class="form-control" value="<?php echo $task->task_deadline;?>" name="task_deadline" placeholder="Select date and time" id="kt_datetimepicker_5" />
                    <div class="input-group-append">
                        <span class="input-group-text">
                            <i class="la la-calendar glyphicon-th"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group row kt-margin-t-20">
            <label class="col-form-label col-lg-3 col-sm-12">Task Mode</label>
            <div class="col-lg-9 col-md-9 col-sm-12">
                <select class="form-control kt-select2" id="kt_select2_1_modal" name="task_mode">
                    <option disabled="">Select Task Mode</option>
                    <option <?php if($task->task_mode == 'Urgent') echo 'selected';?>>Urgent</option>
                    <option <?php if($task->task_mode == 'Normal') echo 'selected';?>>Normal</option>
                </select>
            </div>
        </div>

        <div class="form-group m-form__group row">
            <label >Task Description</label>
            <div class="col-md-12">
                <textarea data-provide="markdown" class="form-control" value="<?php echo $task->task_desc;?>" name="task_desc"><?php echo $task->task_desc;?></textarea>
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit</button>
    </div>
</form>

<script type="text/javascript">
    $('form#modifyTaskForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('task/index/updateTask/'.$task->task_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating Task ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#taskDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#taskDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>