<script type="text/javascript">

  jQuery(document).ready(function() {
    $('select').css('width','100%');
    $('select').select2({placeholder: 'select option'});
    let height = $(window).innerHeight()  - 250;
    $('.lm_max_height').css({ height: height });
    $(window).resize(function(){
      $('.lm_max_height').css({ height: height });
    });

    $('form#newTask').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
          url: '<?php echo base_url('task/index/newTask/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newTask",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Creating new Task ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                notifySuccess(obj.message);
                //var table = $.fn.dataTable.tables( { api: true } );
                //table.clear().draw();
                  //window.location.reload();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newTask');
                $('div#kt_select2_modal').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newTask');
              }
      });
    })

  });

  jQuery(document).ready(function() {
      $('select').css('width','100%');
      $('select').select2({placeholder: 'select option'});
      let height = $(window).innerHeight()  - 250;
      $('.lm_max_height').css({ height: height });
      $(window).resize(function(){
          $('.lm_max_height').css({ height: height });
      });

      $('form#newProject').submit( function(event){
          let form = $( this );
          event.preventDefault();
          let formdata = form.serialize();
          $.ajax({
              url: '<?php echo base_url('task/projects/newProject/')?>',
              type: 'get',
              data: formdata,
              beforeSend: function(){
                  KTApp.block("form#newProject",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Creating new Project ...."
                  });
              },
              success: function(r){
                  var obj = JSON.parse(r);
                  if(obj.status == 'ok'){
                      notifySuccess(obj.message);
                      //var table = $.fn.dataTable.tables( { api: true } );
                      //table.clear().draw();
                      //window.location.reload();
                  }else{
                      Swal.fire('',obj.message,'warning');
                  }
                  KTApp.unblock('form#newProject');
                  $('div#newProject').modal('hide');
              },
              error: function(){
                  KTApp.unblock('form#newProject');
              }
          });
      })

  });

  Dropzone.autoDiscover = false;
  var options = {
      url: "<?php echo base_url('task/projects/uploadexpensedocs');?>",
      paramName: "file", // The name that will be used to transfer the file
      maxFiles: 10,
      maxFilesize: 3, // MB
      success: function(file, response){
          let oldValue = $('input#uploadedfiles').val();
          if(oldValue.length > 0){
              oldValue = oldValue + 'LM-55';
          }
          let newValue =  oldValue + response.files;
          $('input#uploadedfiles').val(newValue);
      },
  };
  var expsenseDocs = new Dropzone("div#crop-image",options);

  function deleteTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: '<?php echo base_url('task/index/deleteTasks/task')?>/'+task,
                  type: 'get',
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Deleting Task ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          $('div#id-' + task).hide();
                          notifySuccess(obj.message);
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                      KTApp.unblock('#lm_table_task');
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }
              });
          }
      })
  }

  function loadTaskDetails(key){
      let $div =  $('div#details');
      $.ajax({
          url: '<?php echo base_url('task/index/taskDetails/');?>' + key + '/',
          type: 'get',
          beforeSend: function(){
              KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"danger",
                  message:"Loading task information ..."
              });
          },
          success: function (result){
              $div.html(result);
              KTApp.unblock($div);
          },
          error: function (xhr){
              KTApp.unblock($div);
              Swal.fire('',xhr.statusText,'warning');
          }
      });
  }

  function details(task){
    let $modal =  $('div#leaveDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url('/hrm/leave/index/detailsLeave/');?>' + task,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading leave details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function editTask(task){
    let $modal =  $('div#taskDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
        url: '<?php echo base_url('task/index/modifyTask/');?>' + task,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading task details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function startTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to start your TASK!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Start it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('task/index/startTask/');?>" + task,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Starting Task assigned ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function finishTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to finish your TASK!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Finish it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('task/index/finishTask/');?>" + task,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Approving Request ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function pauseTask(task){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to pause your TASK!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, pause it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('task/index/pauseTask/');?>" + task,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_task",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Approving Request ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_task');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_task');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function deleteSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["group_key"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to DELETE " + table.rows('.selected').data().length + " groups",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Delete them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('/customers/category/deleteselected/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

  function viewTask(task){
      let $modal =  $('div#myTask');
      let $div = $modal.find('.modal-body');
      $div.html('');
      $modal.modal('show');
      $.ajax({
          url: '<?php echo base_url('task/index/viewMyTask/');?>' + task,
          type: 'get',
          beforeSend: function(){
              KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Loading my task ...."
              });
          },
          success: function (result){
              $div.html(result);
              KTApp.unblock($div);
          },
          error: function (xhr){
              $modal.modal('hide');
              KTApp.unblock($div);
              Swal.fire('',xhr.statusText,'warning');
          }
      })
  }

</script>