<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarTask();?>

    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <div class="row" hidden>
            <div class="col-lg-12">
                <!--begin::Portlet-->
                <div class="kt-portlet kt-portlet--last kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
                    <div class="kt-portlet__head kt-portlet__head--md" style="">
                        <div class="kt-portlet__head-label">
                            <h3 class="kt-portlet__head-title">Project List</h3>
                        </div>
                    </div>
                    <div class="kt-portlet__body">
                        <table class="table table-striped table-bordered" id="lm_table_project">
                            <thead>
                            <tr>
                                <th>Project Title</th>
                                <th>Client</th>
                                <th>Start</th>
                                <th>End</th>
                                <th>Budget</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>

                <!--end::Portlet-->
            </div>
        </div>

        <div class="row">
            <?php if(!empty($projects)):
            foreach($projects as $hero):?>
            <div class="col-xl-4" id="id-<?php echo $hero['project_key'];?>">

                <!--begin:: Portlet-->
                <div class="kt-portlet kt-portlet--height-fluid">
                    <div class="kt-portlet__body kt-portlet__body--fit">

                        <!--begin::Widget -->
                        <div class="kt-widget kt-widget--project-1">
                            <div class="kt-widget__head d-flex">
                                <div class="kt-widget__label">
                                    <div class="kt-widget__media kt-widget__media--m">
                                            <span class="kt-media kt-media--md kt-media--circle kt-hidden-">
                                                <img src="<?php echo uploadFilePath('project_client_image/'.$hero['project_client_image']);?>" alt="image">
                                            </span>
                                        <span class="kt-media kt-media--md kt-media--circle kt-hidden">
                                                <img src="<?php echo uploadFilePath('project_client_image/'.$hero['project_client_image']);?>" alt="image">
                                            </span>
                                    </div>
                                    <div class="kt-widget__info kt-padding-0 kt-margin-l-15">
                                        <a href="#" class="kt-widget__title">

                                            <?php echo nl2br( substr(ucfirst($hero['project_client']),0,20));
                                            if(strlen($hero['project_client']) > 20) echo'...'?>
                                        </a>
                                        <span class="kt-widget__desc"><?php echo $hero['project_title'];?></span>
                                    </div>
                                </div>
                                <div class="kt-widget__toolbar">
                                    <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                        <i class="flaticon-more-1"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-fit dropdown-menu-right">
                                        <ul class="kt-nav">
                                            <li class="kt-nav__item">
                                                <a href="javascript:modify('<?php echo $hero['project_key'];?>');" class="kt-nav__link">
                                                    <i class="kt-nav__link-icon flaticon2-edit"></i>
                                                    <span class="kt-nav__link-text">Edit</span>
                                                </a>
                                            </li>
                                            <li class="kt-nav__item">
                                                <a href="javascript:deleteItem('<?php echo $hero['project_key'];?>');" class="kt-nav__link">
                                                    <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                    <span class="kt-nav__link-text">Delete</span>
                                                </a>
                                            </li>
                                            <li class="kt-nav__item">
                                                <a href="#" class="kt-nav__link">
                                                    <i class="kt-nav__link-icon flaticon2-pie-chart-1"></i>
                                                    <span class="kt-nav__link-text">Charts</span>
                                                </a>
                                            </li>
                                            <li class="kt-nav__item">
                                                <a href="#" class="kt-nav__link">
                                                    <i class="kt-nav__link-icon flaticon2-avatar"></i>
                                                    <span class="kt-nav__link-text">Members</span>
                                                </a>
                                            </li>
                                            <li class="kt-nav__item">
                                                <a href="javascript:details('<?php echo $hero['project_key'];?>');" class="kt-nav__link">
                                                    <i class="kt-nav__link-icon flaticon2-open-text-book"></i>
                                                    <span class="kt-nav__link-text">Details</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="kt-widget__body">
                            <span class="kt-widget__text kt-margin-t-0 kt-padding-t-5">
                                <?php echo $hero['project_desc'];?>
                            </span>
                                <div class="kt-widget__stats kt-margin-t-20">
                                    <div class="kt-widget__item d-flex align-items-center kt-margin-r-30">
															<span class="kt-widget__date kt-padding-0 kt-margin-r-10">Start</span>
                                        <div class="kt-widget__label">
                                            <span class="btn btn-label-brand btn-sm btn-bold btn-upper"><?php echo $hero['project_start_date'];?></span>
                                        </div>
                                    </div>
                                    <div class="kt-widget__item d-flex align-items-center kt-padding-l-0">
                                            <span class="kt-widget__date kt-padding-0 kt-margin-r-10 ">Due</span>
                                        <div class="kt-widget__label">
                                            <span class="btn btn-label-danger btn-sm btn-bold btn-upper"><?php echo $hero['project_end_date'];?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-widget__container">
                                    <span class="kt-widget__subtitel">Progress</span>
                                    <div class="kt-widget__progress d-flex align-items-center flex-fill">
                                        <div class="progress" style="height: 5px;width: 100%;">
                                            <div class="progress-bar kt-bg-success" role="progressbar" style="width: <?php echo $hero['project_progress'];?>%;" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>
                                        <span class="kt-widget__stat"><?php echo $hero['project_progress'];?>%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="kt-widget__footer">
                                <div class="kt-widget__wrapper">
                                    <div class="kt-widget__section">
                                        <div class="kt-widget__blog">
                                            <i class="flaticon2-list-1"></i>
                                            <a href="#" class="kt-widget__value kt-font-brand"><?php echo $hero['project_task'];?> Tasks</a>
                                        </div>
                                        <div class="kt-widget__blog">
                                            <i class="flaticon2-talk"></i>
                                            <a href="#" class="kt-widget__value kt-font-brand">654 Comments</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--end::Widget -->
                    </div>
                </div>

                <!--end:: Portlet-->
            </div>
            <?php endforeach; endif;?>

        </div>

    </div>
    <!-- end:: Content -->
</div>

<div class="modal fade- modal-sticky-top-left" id="newProject" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Create New Project</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <form id="newProject" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
                <div class="form-group row">
                    <div class="col-lg-4 col-md-9 col-sm-12">
                        <input hidden class="form-control" id="kt_timepicker_1" readonly name="project_time_created" type="text" />
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row form-group">
                        <div class="col-4">
                            <label>Project Title</label>
                            <input type="text" required name="project_title" placeholder="Project Title " class="form-control"/>
                        </div>
                        <div class="col-4">
                            <label>Project Client</label>
                            <input type="text" name="project_client" placeholder="Project Client" class="form-control"/>
                        </div>
                        <div class="col-4">
                            <label>Project Budget</label>
                            <input type="text" name="project_budget" placeholder="Project Budget" class="form-control number" />
                        </div>
                    </div>

                    <div class="row form-group">
                        <div class="col-4">
                            <label>Project Deadline</label>
                            <input type="date" name="project_deadline" placeholder="Project Deadline " class="form-control"/>
                        </div>
                        <div class="col-4">
                            <label>Project Start</label>
                            <input type="date" name="project_start_date" placeholder="Project Start Date " class="form-control"/>
                        </div>
                        <div class="col-4">
                            <label>Project End</label>
                            <input type="date" name="project_end_date" placeholder="Project End Date" class="form-control" />
                        </div>

                    </div>

                    <div class="form-group m-form__group row">
                        <label >Project Description</label>
                        <div class="col-md-12">
                            <textarea data-provide="markdown" class="form-control" name="project_desc"></textarea>
                        </div>
                    </div>
                    <div class="row form-group">
                        <label >Client Logo</label>
                        <div class="col-12">
                            <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                                <div class="m-dropzone__msg dz-message needsclick">
                                    <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                                    <span class="m-dropzone__msg-desc">Upload 1 files</span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
                    <button type="submit" name="submit" class="btn btn-success">Submit</button>
                </div>
                <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
            </form>
        </div>
    </div>
</div>


<?php include VIEWPATH.'includes/footer.php';
include __DIR__.'/projectscripts.php';
?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>
<!--begin::Page Scripts(used by this page) -->
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/file-upload/dropzonejs.js" type="text/javascript"></script>

<style type="text/css">
    html,body {
        min-height:100%;
        height:100%;
        background-image:url(<?php echo base_url('uploads/bg.jpg');?>);
        background-size:cover;
        background-position:top center;
        font-family:helvetica neue, helvetica, arial, sans-serif;
        font-weight:200;
    }
</style>

<div class="modal fade- modal-sticky-top-left" id="projectDetails" role="dialog" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="">Project Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="la la-remove"></span>
                </button>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
        </div>
    </div>
</div>


<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>