<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyProjectForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <label>Project Title</label>
                <input type="text" required name="project_title" value="<?php echo $project->project_title;?>" placeholder="Project Title " class="form-control"/>
            </div>
            <div class="col-6">
                <label>Project Client</label>
                <input type="text" name="project_client" value="<?php echo $project->project_client;?>" placeholder="Project Client" class="form-control"/>
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Project Deadline</label>
                <input type="date" name="project_deadline" value="<?php echo $project->project_deadline;?>" placeholder="Project Deadline " class="form-control"/>
            </div>
            <div class="col-6">
                <label>Project Budget</label>
                <input type="text" name="project_budget" value="<?php echo $project->project_budget;?>" placeholder="Project Budget" class="form-control number" />
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Project Start</label>
                <input type="date" name="project_start_date" value="<?php echo $project->project_start_date;?>" placeholder="Project Start Date " class="form-control"/>
            </div>
            <div class="col-6">
                <label>Project End</label>
                <input type="date" name="project_end_date" value="<?php echo $project->project_end_date;?>" placeholder="Project End Date" class="form-control" />
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Project Status</label>
                <select class="form-control" name="project_status">
                    <option disabled>Select Status</option>
                    <option <?php if($project->project_status == 'Pending') echo 'selected';?>>Pending</option>
                    <option <?php if($project->project_status == 'OnProgress') echo 'selected';?>>Started</option>
                    <option <?php if($project->project_status == 'Completed') echo 'selected';?>>Completed</option>
                </select>
            </div>
            <div class="col-6">
                <label>Project Progress</label>
                <input type="number" min="0" max="100" name="project_progress" value="<?php echo $project->project_progress;?>" placeholder="" class="form-control" />
            </div>
        </div>

        <div class="form-group m-form__group row">
            <label >Project Description</label>
            <div class="col-md-12">
                <textarea data-provide="markdown" value="<?php echo $project->project_desc;?>" class="form-control" name="project_desc"><?php echo $project->project_desc;?></textarea>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit</button>
    </div>
</form>

<script type="text/javascript">
    $('form#modifyProjectForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('task/projects/updateProject/'.$project->project_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating Project ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#projectDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#projectDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>