<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php $count = count($customers); contact_list($count);?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Reports</a></li>
                            <li class="breadcrumb-item"><a href="javascript:(0);">HRM</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Contact List</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <!--begin::Portlet-->
        <div class="kt-portlet kt-portlet--mobile">
            <div class="kt-portlet__body kt-portlet__body--fit">

                <!--begin: Datatable -->
                <div class="kt-datatable" id="kt_apps_user_list_datatable"></div>

                <!--end: Datatable -->
            </div>
        </div>

        <!--end::Portlet-->

        <!--begin::Modal-->
        <div class="modal fade" id="kt_datatable_records_fetch_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Selected Records</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="kt-scroll" data-scroll="true" data-height="200">
                            <ul id="kt_apps_user_fetch_records_selected"></ul>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-brand" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!--end::Modal-->

    </div>

    <!-- end:: Content -->
</div>

<?php
include VIEWPATH.'includes/footer.php';?>
<!--end::Page Scripts -->
<script type="text/javascript">
    "use strict";
    // Class definition

    var KTUserListDatatable = function() {

        // variables
        var datatable;

        // init
        var init = function() {
            // init the datatables. Learn more: https://keenthemes.com/metronic/?page=docs&section=datatable
            datatable = $('#kt_apps_user_list_datatable').KTDatatable({
                // datasource definition
                data: {
                    type: 'remote',
                    source: {
                        read: {
                            url: '<?= base_url('reports/hrm/contacts/datasource')?>',
                        },
                    },
                    pageSize: 10, // display 20 records per page
                    serverPaging: true,
                    serverFiltering: true,
                    serverSorting: true,
                },

                // layout definition
                layout: {
                    scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
                    footer: false, // display/hide footer
                },

                // column sorting
                sortable: true,

                pagination: true,

                search: {
                    input: $('#generalSearch'),
                    delay: 400,
                },

                // columns definition
                columns: [{
                    field: 'RecordID',
                    title: '#',
                    sortable: false,
                    width: 20,
                    selector: {
                        class: 'kt-checkbox--solid'
                    },
                    textAlign: 'center',
                }, {
                    field: "customer",
                    title: "Customer",
                    width: 200,
                    // callback function support for column rendering
                    template: function(data, i) {

                        var pos = KTUtil.getRandomInt(0, 5);
                        var position = [
                            'Developer',
                            'Designer',
                            'CEO',
                            'Manager',
                            'Architect',
                            'Sales'
                        ];

                        var output = '';
                        var stateNo = KTUtil.getRandomInt(0, 6);
                        var states = [
                            'success',
                            'brand',
                            'danger',
                            'success',
                            'warning',
                            'primary',
                            'info'
                        ];
                        var state = states[stateNo];

                        output = '<div class="kt-user-card-v2">\
								<div class="kt-user-card-v2__pic">\
									<div class="kt-badge kt-badge--xl kt-badge--' + state + '">' + data.firstname.substring(0, 1) + data.lastname.substring(0, 1)  + '</div>\
								</div>\
								<div class="kt-user-card-v2__details">\
									<a href="#" class="kt-user-card-v2__name">' + data.employee + '</a>\
									<span class="kt-user-card-v2__desc">' + data.category_name + '</span>\
								</div>\
							</div>';

                        return output;
                    }
                }, {
                    field: 'country',
                    title: 'Country',
                    template: function(row) {
                        return row.country;
                    },
                }, {
                    field: 'state',
                    title: 'Address',
                    template: function(row) {
                        var output = '';
                        output = '<div class="kt-user-card-v2__details">\
									<a href="#" class="kt-user-card-v2__name">' + row.state + '</a><br>\
									<span class="kt-user-card-v2__desc">' + row.city + '</span>\
								</div>\
							</div>';

                        return output;
                    },
                }, {
                    field: 'email',
                    title: 'Email',
                    template: function(row) {
                        return row.email;
                    },
                }, {
                    field: 'phonenumber',
                    title: 'Phone',
                    template: function(row) {
                        return row.phonenumber;
                    },
                }, {
                    field: 'joined',
                    title: 'Joined Date',
                    type: 'date',
                    format: 'MM/DD/YYYY',
                }]
            });
        }

        // search
        var search = function() {
            $('#kt_form_status').on('change', function() {
                datatable.search($(this).val().toLowerCase(), 'Status');
            });
        }

        // selection
        var selection = function() {
            // init form controls
            //$('#kt_form_status, #kt_form_type').selectpicker();

            // event handler on check and uncheck on records
            datatable.on('kt-datatable--on-check kt-datatable--on-uncheck kt-datatable--on-layout-updated',	function(e) {
                var checkedNodes = datatable.rows('.kt-datatable__row--active').nodes(); // get selected records
                var count = checkedNodes.length; // selected records count

                $('#kt_subheader_group_selected_rows').html(count);

                if (count > 0) {
                    $('#kt_subheader_search').addClass('kt-hidden');
                    $('#kt_subheader_group_actions').removeClass('kt-hidden');
                } else {
                    $('#kt_subheader_search').removeClass('kt-hidden');
                    $('#kt_subheader_group_actions').addClass('kt-hidden');
                }
            });
        }

        // selected records print
        var printAll = function() {
            $('#kt_subheader_group_actions_print_all').on('click', function() {
                // fetch selected IDs
                var ids = datatable.rows('.kt-datatable__row--active').nodes().find('.kt-checkbox--single > [type="checkbox"]').map(function(i, chk) {
                    return $(chk).val();
                });

                if (ids.length > 0) {
                    // learn more: https://sweetalert2.github.io/
                    swal.fire({
                        buttonsStyling: false,

                        text: "Are you sure to print all records ?",
                        type: "danger",

                        confirmButtonText: "Yes, Print!",
                        confirmButtonClass: "btn btn-sm btn-bold btn-danger",

                        showCancelButton: true,
                        cancelButtonText: "No, cancel",
                        cancelButtonClass: "btn btn-sm btn-bold btn-brand"
                    }).then(function(result) {
                        if (result.value) {
                            swal.fire({
                                title: 'Deleted!',
                                text: 'Your selected records have been printed! :(',
                                type: 'success',
                                buttonsStyling: false,
                                confirmButtonText: "OK",
                                confirmButtonClass: "btn btn-sm btn-bold btn-brand",
                            })
                            // result.dismiss can be 'cancel', 'overlay',
                            // 'close', and 'timer'
                        } else if (result.dismiss === 'cancel') {
                            swal.fire({
                                title: 'Cancelled',
                                text: 'You selected records have not been printed! :)',
                                type: 'error',
                                buttonsStyling: false,
                                confirmButtonText: "OK",
                                confirmButtonClass: "btn btn-sm btn-bold btn-brand",
                            });
                        }
                    });
                }
            });
        }

        var updateTotal = function() {
            datatable.on('kt-datatable--on-layout-updated', function () {
                //$('#kt_subheader_total').html(datatable.getTotalRows() + ' Total');
            });
        };

        // selected records print
        var printSelected = function() {
            $('#kt_subheader_group_actions_print_selected').on('click', function() {
                // fetch selected IDs
                var ids = datatable.rows('.kt-datatable__row--active').nodes().find('.kt-checkbox--single > [type="checkbox"]').map(function(i, chk) {
                    return $(chk).val();
                });

                if (ids.length > 0) {
                    // learn more: https://sweetalert2.github.io/
                    swal.fire({
                        buttonsStyling: false,

                        text: "Are you sure to print " + ids.length + " selected records ?",
                        type: "danger",

                        confirmButtonText: "Yes, print!",
                        confirmButtonClass: "btn btn-sm btn-bold btn-danger",

                        showCancelButton: true,
                        cancelButtonText: "No, cancel",
                        cancelButtonClass: "btn btn-sm btn-bold btn-brand"
                    }).then(function(result) {
                        if (result.value) {
                            swal.fire({
                                title: 'Deleted!',
                                text: 'Your selected records have been printed! :(',
                                type: 'success',
                                buttonsStyling: false,
                                confirmButtonText: "OK",
                                confirmButtonClass: "btn btn-sm btn-bold btn-brand",
                            })
                            // result.dismiss can be 'cancel', 'overlay',
                            // 'close', and 'timer'
                        } else if (result.dismiss === 'cancel') {
                            swal.fire({
                                title: 'Cancelled',
                                text: 'You selected records have not been printed! :)',
                                type: 'error',
                                buttonsStyling: false,
                                confirmButtonText: "OK",
                                confirmButtonClass: "btn btn-sm btn-bold btn-brand",
                            });
                        }
                    });
                }
            });
        }

        return {
            // public functions
            init: function() {
                init();
                search();
                selection();
                updateTotal();
                printSelected();
                printAll();
            },
        };
    }();

    // On document ready
    KTUtil.ready(function() {
        KTUserListDatatable.init();
    });

    function deletes(){
        alert();
    }
</script>
</body>

<!-- end::Body -->
</html>
