<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuQuotations();?>

    <!-- begin:: Content -->
        <div class="kt-container kt-container--fluid">
            <div class="row">
                <div class="col-12">
                    <div class="bs-example">
                        <nav >
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:(0);">Quotations</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">Details</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">Modify</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            
            <div class="kt-portlet" data-portlet="true" id="kt_portlet_chat_of_accounts">
                <div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                            QUOTATION DETAILS MODIFICATION
                        </h3>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <div class="kt-portlet__head-group">
                            <a href="<?php echo base_url('quotations/details/'.$quotation['quot_key']);?>" class="btn btn-sm btn-outline-primary"><i class="la la-file-code-o"></i> Details</a>
                        </div>
                    </div>
                </div>
<!--                onsubmit="create_quotation(); return false;"-->
                <?php
                $text = "[{
                             'id': '".$quotation['quot_id']."',
                             'key': '".$quotation['quot_key']."',
                             'amount': '".$quotation['quot_total_after_tax']."',
                             'recipient': '".$quotation['firstname']." ".$quotation['middlename']." ".$quotation['lastname']."',
                             'date of issue': '".$quotation['quot_issued_date']."',
                             'status': '".$quotation['quot_status']."',                             
                             }]";
                $path = writablePath('quotations/qrimages/'.$quotation['quot_key'].'.png');
                $this->qrcodes->createImage($text,$path);
                ?>
                <div class="kt-portlet__body kt-portlet__body--fullheight" id="list-content">
                    <?php echo form_open(base_url('quotations/modify/'.$quotation['quot_key']),['id'=>'modify-quotation-form','class'=>'t-form']);?>
                    <?php if(!empty($form_action)){ ?>
                        <div class="form-group row">
                            <div class="alert alert-<?php echo $form_class?> fade show" role="alert">
                                <div class="alert-icon"><i class="flaticon-questions-circular-button"></i></div>
                                <div class="alert-text"><?php echo $form_message;?></div>
                                <div class="alert-close">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true"><i class="la la-close"></i></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                        <div class="form-group row">
                            <div class="col-md-4">
                                <label>Recipient</label>
                                <input value="<?php echo $quotation['firstname'].' '.$quotation['lastname'];?>" id="bms-client-display" required  type="text" class="form-control" readonly>
                            </div>
                            <div class="col-md-4">
                                <label>Billing Address</label>
                                <input id="bms-client-address" value="<?php echo $quotation['quot_address'];?>" required name="quot_address" type="text" class="form-control"   />
                            </div>
                            <div class="col-md-4">
                                <label>Status</label>
                                <select name="quot_status" required class="form-control">
                                    <option <?php if(strtolower($quotation['quot_status']) == "pending") echo "selected";?> value="PENDING">PENDING</option>
                                    <option <?php if(strtolower($quotation['quot_status']) == "sent") echo "selected";?> value="SENT">SENT</option>
                                    <option <?php if(strtolower($quotation['quot_status']) == "draft") echo "selected";?> value="DRAFT">DRAFT</option>
                                </select>
                            </div>
                        </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="kt-portlet kt-portlet--bordered" id="kt_repeater_items">
                                <div class="kt-portlet__head">
                                    <div class="kt-portlet__head-label">
                                        <h3 class="kt-portlet__head-title">Custom Items</h3>
                                    </div>
                                </div>
                                <div class="kt-portlet__body">
                                    <div id="kt_repeater_products">
                                        <div data-repeater-list="group_items">
                                            <div data-repeater-item class="align-items-center">
                                                <hr/>
                                                <div class="row item-container">
                                                    <div class="col-md-3">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Item Name</label>
                                                            <div class="kt-form__control">
                                                                <input type="text" name="quot_item" placeholderx="Item name" class="form-control quot_item" required />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Item Description</label>
                                                            <div class="kt-form__control">
                                                                <input name="quot_item_details" type="text" class="form-control quot_item_details" placeholderx="Description">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Tax Option</label>
                                                            <div class="kt-form__control">
                                                                <select required style="width: 100%;" name="quot_item_tax_inclusive" class="select_tax_option form-control quot_item_tax_inclusive">
                                                                    <option value="1">Tax Inclusive</option>
                                                                    <option value="0" selected>Tax Exclusive</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Item Tax</label>
                                                            <div class="kt-form__control">
                                                                <?php $classes = $this->taxesModel->taxClasses(); ?>
                                                                <select  style="width: 100%;" name="quot_item_tax" class="form-control quote_item_tax select_tax quot_item_tax">
                                                                    <option value="0">No Tax</option>
                                                                    <?php if(!empty($classes)){
                                                                        foreach ($classes as $class){ ?>
                                                                            <option value="<?php echo $class['tax_class_key'];?>"><?= $class['tax_class_title'] ?></option>
                                                                        <?php }
                                                                    } ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <input name="quot_item_tax_percent" type="hidden" value="0" class="form-control quot_item_tax_percent">
                                                    <div class="col-md-2">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Item Price</label>
                                                            <div class="kt-form__control">
                                                                <input required name="quot_item_price" type="text" class="form-control quot_item_price quot_item_price">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Quantity</label>
                                                            <div class="kt-form__control">
                                                                <input required name="quot_item_qty" type="text" class="form-control quot_item_qty">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Item Tax Amount</label>
                                                            <div class="kt-form__control">
                                                                <input type="text" readonly name="quot_item_tax_value"  class="form-control quot_item_tax_value" required />
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">Before Tax Amount</label>
                                                            <div class="kt-form__control">
                                                                <input type="text" readonly name="quot_item_before_tax"  class="form-control quot_item_before_tax" required />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="kt-form__group--inline">
                                                            <label class="col-form-label">After Tax Amount</label>
                                                            <div class="kt-form__control">
                                                                <input required readonly  name="quot_item_after_tax" type="text" class="form-control quot_item_after_tax" >
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">

                                                        <label class="col-form-label">&nbsp</label><br/>
                                                        <a href="javascript:;" data-repeater-delete="" class="btn btn-icon btn-outline-danger btn-bold">
                                                            <i class="la la-trash-o"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><br/>
                                    <div class="kt-portlet__foot kt-portlet__foot--sm kt-align-right form-group">
                                        <a href="javascript:;" data-repeater-create="" class="btn btn-bold btn-sm btn-label-brand">
                                            <i class="la la-plus"></i> Add
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <label>Description</label>
                                <textarea required name="quot_details" class="form-control col-12" placeholder="Descriptions"><?php echo nl2br($quotation['quot_details']);?></textarea>
                            </div>
                        </div>
                    <div >
                        <div class="row">
                            <div class="form-group col-md-4">
                                <div class="kt-section__body">

                                    <h3 class="kt-section__title kt-section__title-sm kt-align-lest">Timing</h3>
                                    <div class="form-group row">
                                        <div class="col-12">
                                            <label>Date of Issue</label>
                                            <input required value="<?php echo date("Y-m-d",strtotime($quotation['quot_issued_date']));?>" name="quot_issued_date" class="form-control" type="date" placeholder="date" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-4">
                                <h3 class="kt-section__title kt-section__title-sm kt-align-left">Summary</h3>
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <th style="vertical-align: middle;" >Sub Total</th>
                                            <td><input name="quot_sub_total" value="<?php echo round(to_money($quotation['quot_total_after_tax']));?>" readonly type="number"  class="form-control quot_sub_total" placeholder="Sub Total"> </td>
                                        </tr>
                                    </tbody>
                                    <tbody id="tax-body">
                                        <tr>
                                            <th style="vertical-align: middle;" >TAX</th>
                                            <td><input  value="<?php echo round(to_money($quotation['quot_total_tax']));?>" name="quot_total_tax" readonly type="number"  class="form-control quot_total_tax" > </td>
                                        </tr>
                                        <tr>
                                            <th style="vertical-align: middle;" >After TAX</th>
                                            <td><input name="quot_total_after_tax" value="<?php echo round(to_money($quotation['quot_total_after_tax']));?>" id="after_tax"  readonly type="number"  class="form-control quot_total_after_tax" placeholder="After TAX"> </td>
                                        </tr>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                        <?php if(strtolower($quotation['quot_status']) != "invoice"){?>
                        <div class="row">
                            <div class="col-md-8"></div>
                            <div class="form-group col-md-4">
                                <button class="btn  btn-success text-uppercase" type="submit">Update Quotation</button>&nbsp
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                        <input type="hidden" id="total-tax-class" value="0" />
                        <input type="hidden" id="total-tax" value="<?php $ttotal = 0; if(!empty($taxes)){

                            foreach ($taxes as $tax){
                                $ttotal += $tax['quot_data_tax_value'];
                            }
                        } echo number_format($ttotal/100,2);?>" />
                    </form>
                </div>
            </div>
        </div>
    <!-- end:: Content -->
</div>

<?php
    include VIEWPATH.'includes/footer.php';?>
    <script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
   <?php include 'scripts.php';
?>

<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>

