<script type="text/javascript">
    var LmProfile = function(){

        const baseUrl = location.protocol.concat("//").concat(window.location.hostname)

        // Personal information
        const accountInformationForm = $("form#accountInformationForm");
        let accountInformationFormSubmit = function() {
            accountInformationForm.submit(function(e) {
                e.preventDefault();

                let btn = $("button#submit");
                let data = accountInformationForm.serialize();
                accountInformationForm.validate({
                    rules: {
                        user_lang: {
                            required: true
                        },
                        timezone: {
                            required: true
                        }
                    }
                });

                if (!accountInformationForm.valid()) {
                    return;
                }

                $.ajax({
                    type: 'post',
                    cache: false,
                    data:data,
                    dataType: 'json',
                    url: baseUrl + '/profile/index/updateaccount',
                    beforeSend: function(){
                        KTApp.block(accountInformationForm, {
                            overlayColor: "#000000",
                            type: "loader",
                            state: "success",
                            message: "Sending data ..."
                        });
                        btn.addClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', true);
                    },
                    success: function(response, status, xhr, $form) {
                        KTApp.unblock(accountInformationForm);
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                        $('[name="'+ response.login_token_name +'"]').val( response.token );
                        if(response.status == 1){
                            Swal.fire("",response.message,"success");
                            return;
                        }

                        if(response.status == 0){
                            btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                            Swal.fire("",response.message,"warning");
                            return;
                        }

                    },
                    error: function(xhr){
                        Swal.fire("",xhr.statusText,"warning");
                        KTApp.unblock(accountInformationForm);
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                    }
                });
            });
        }

        // Personal information
        const securityInformationForm = $("form#securityInformationForm");
        let securityInformationFormSubmit = function() {
                securityInformationForm.submit(function(e) {
                e.preventDefault();

                let btn = $("button#submit");
                let data = securityInformationForm.serialize();
                securityInformationForm.validate({
                    rules: {
                        oldpassword: {
                            required: true
                        },
                        newpassword: {
                            required: true
                        },
                        dob: {
                            required: true
                        },
                        phone: {
                            required: true
                        }
                    }
                });

                if (!securityInformationForm.valid()) {
                    return;
                }

                $.ajax({
                    type: 'post',
                    cache: false,
                    data:data,
                    dataType: 'json',
                    url: baseUrl + '/profile/index/updatepassword',
                    beforeSend: function(){
                        KTApp.block(securityInformationForm, {
                            overlayColor: "#000000",
                            type: "loader",
                            state: "success",
                            message: "Sending data ..."
                        });
                        btn.addClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', true);
                    },
                    success: function(response, status, xhr, $form) {
                        KTApp.unblock(securityInformationForm);
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                        $('[name="'+ response.login_token_name +'"]').val( response.token );
                        if(response.status == 1){
                            securityInformationForm.resetForm();
                            Swal.fire("",response.message,"success");
                            return;
                        }

                        if(response.status == 0){
                            btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                            Swal.fire("",response.message,"warning");
                            return;
                        }

                    },
                    error: function(xhr){
                        Swal.fire("",xhr.statusText,"warning");
                        KTApp.unblock(securityInformationForm);
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                    }
                });
            });
        }

        // Personal information
        const personalInformationForm = $("form#personalInformationForm");
        let personalInformationFormSubmit = function() {
            personalInformationForm.submit(function(e) {
                e.preventDefault();

                let btn = $("button#personalInformationButton");
                let data = personalInformationForm.serialize();
                personalInformationForm.validate({
                    rules: {
                        firstname: {
                            required: true
                        },
                        lastname: {
                            required: true
                        },
                        dob: {
                            required: true
                        },
                        phone: {
                            required: true
                        }
                    }
                });

                if (!personalInformationForm.valid()) {
                    return;
                }

                $.ajax({
                    type: 'post',
                    cache: false,
                    data:data,
                    dataType: 'json',
                    url: baseUrl + '/profile/index/updatepersonaldata',
                    beforeSend: function(){
                        KTApp.block(personalInformationForm, {
                            overlayColor: "#000000",
                            type: "loader",
                            state: "success",
                            message: "Sending data ..."
                        });
                        btn.addClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', true);
                    },
                    success: function(response, status, xhr, $form) {
                        KTApp.unblock(personalInformationForm);
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                        $('[name="'+ response.login_token_name +'"]').val( response.token );
                        if(response.status == 1){
                            Swal.fire("",response.message,"success");
                            return;
                        }

                        if(response.status == 0){
                            btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                            Swal.fire("",response.message,"warning");
                            return;
                        }

                    },
                    error: function(xhr){
                        Swal.fire("",xhr.statusText,"warning");
                        KTApp.unblock(personalInformationForm);
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                    }
                });
            });
        }

        var avatar;
        var offcanvas;

        // Private functions
        var initAside = function () {
            // Mobile offcanvas for mobile mode
            offcanvas = new KTOffcanvas('kt_user_profile_aside', {
                overlay: true,
                baseClass: 'kt-app__aside',
                closeBy: 'kt_user_profile_aside_close',
                toggleBy: 'kt_subheader_mobile_toggle'
            });
        }

        var initUserForm = function() {
            avatar = new KTAvatar('kt_user_avatar');
        }

        return {
            // public functions
            init: function() {
                securityInformationFormSubmit();
                personalInformationFormSubmit();
                accountInformationFormSubmit();
                initAside();
                initUserForm();
            }
        };
    }();

    // Class Initialization
    jQuery(document).ready(function() {
        LmProfile.init();
        $("select").select2({placeholder:"select option"})
    });
</script>

