<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->
<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
    <?php topToolBarPayrolls('process');?>
    <!-- begin:: Content -->
    <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-portlet kt-portlet--mobile">
                <div class="kt-portlet__head kt-portlet__head--md">
                    <div class="kt-portlet__head-label"  style="width:100%;">
                        <h3 class="kt-portlet__head-title"><?php echo ucwords($employee->firstname.' '.$employee->middlename.' '.$employee->lastname);?></h3>
                    </div>
                </div>
                <hr/>
                <?php  //var_dump($_SESSION)?>
                <div class="kt-portlet__body">
                    <form id="employeesForm" onsubmit="return false;" class="kt-form">
                        <div class="kt-heading kt-heading--md">Enter payroll Details</div>
                        <!--begin: Form Wizard Step 5-->
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Payroll Date</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <input required type="date" class="form-control" value="<?= date('Y-m-d')?>" name="payroll_timestamp" placeholder="Payroll Date">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Basic Salary</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <input required type="text" class="form-control number" name="basic_salary" placeholder="Basic Salary">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Gross Salary</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <input required type="text" class="form-control number" name="payroll_gross_salary" placeholder="Gross Salary">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Taxable Amount</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <input required type="text" class="form-control number" name="payroll_taxable_salary" placeholder="Taxable Amount">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">PAYE</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <input required type="text" class="form-control number" name="payroll_paye" placeholder="PAYE">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Net Pay</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <input required type="text" class="form-control number" name="payroll_net_salary" placeholder="Net Pay">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Debit Account</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <select id="payroll-debit-account" style="width: 100%;" required class="form-control" name="payroll_debit_account">
                                        <option selected disabled="true">Select Account</option>
                                        <?php if($accounts = accounts()){
                                            foreach ($accounts as $account){?>
                                                <option value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                                            <?php }
                                        } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label">Credit Account</label>
                            <div class="col-8">
                                <div class="input-group">
                                    <select id="payroll-credit-account" style="width: 100%;" required class="form-control" name="payroll_credit_account">
                                        <option selected disabled="true">Select Account</option>
                                        <?php if($accounts = accounts()){
                                            foreach ($accounts as $account){?>
                                                <option value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                                            <?php }
                                        } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-3"></div>
                            <div class="col-8">
                                <div class="btn-toolbar justify-content-between" role="toolbar" aria-label="Toolbar with button groups">
                                    <div class="btn-group" role="group" aria-label="First group">
                                        <button type="button" data-keyboard="false" data-target="#insurance-modal" data-toggle="modal" data-backdrop="false" class="btn btn-label-success"><i class="la la-plus"></i> Insurance</button>
                                        <button type="button" data-keyboard="false" data-target="#allowances-modal" data-toggle="modal" data-backdrop="false" class="btn btn-label-primary"><i class="la la-plus"></i> Allowance</button>
                                        <button type="button" data-keyboard="false" data-target="#deductions-modal" data-toggle="modal" data-backdrop="false" class="btn btn-label-warning"><i class="la la-plus"></i> Deduction</button>
                                        <!--<button type="button" data-keyboard="false" data-target="#benefits-modal" data-toggle="modal" data-backdrop="false" class="btn btn-label-danger"><i class="la la-plus"></i> Benefit</button>-->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-12">
                                <div id="insurance-container">
                                    <?php $data = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
                                    if(!empty($data)){?>
                                        <table class="table table-sm table-success table-bordered">
                                            <tr>
                                                <th colspan="4">Insurance Data</th>
                                            </tr>
                                            <tr>
                                                <th>Insurer</th>
                                                <th>Company Cost</th>
                                                <th>Employee Cost</th>
                                                <th>Action</th>
                                            </tr>
                                            <tbody>
                                            <?php foreach ($data as $key => $datum){?>
                                                <tr>
                                                    <td><?= $this->insurancesModel->insuranceDetails($datum['pr_insurer'])->pr_insurer?></td>
                                                    <td><?= $datum['pr_company_cost'];?></td>
                                                    <td><?= $datum['pr_employee_cost'];?></td>
                                                    <td style="text-align: center;"><a href="javascript:removeSessionInsurance(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td colspan="3"></td>
                                                <td style="text-align: center;"><a href="javascript:removeSessionInsuranceAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    <?php } ?>
                                </div>
                                <div id="allowances-container">
                                    <?php
                                    $data = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
                                    if(!empty($data)){?>
                                        <table class="table table-sm table-primary table-bordered">
                                            <tr>
                                                <th colspan="4">Allowance Data</th>
                                            </tr>
                                            <tr>
                                                <th>Allowance</th>
                                                <th>Type</th>
                                                <th>Value</th>
                                                <th>Action</th>
                                            </tr>
                                            <tbody>
                                            <?php foreach ($data as $key => $datum){?>
                                                <tr>
                                                    <td><?= $this->allowancesModel->allowanceDetails($datum['allowance_key'])->pr_allowance_name?></td>
                                                    <td><?= $datum['allowance_type'];?></td>
                                                    <?php if($datum['allowance_type'] == 'percent'){?>
                                                        <td><?= $datum['allowance_value'];?></td>
                                                    <?php  }else{ ?>
                                                        <td><?= number_format(to_money($datum['allowance_value']));?></td>
                                                    <?php } ?>

                                                    <td style="text-align: center;"><a href="javascript:removeSessionAllowance(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td colspan="3"></td>
                                                <td style="text-align: center;"><a href="javascript:removeSessionAllowanceAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    <?php }
                                    ?>
                                </div>
                                <div id="deductions-container">
                                    <?php
                                    $data = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
                                    if(!empty($data)){?>
                                        <table class="table table-sm table-warning table-bordered">
                                            <tr>
                                                <th colspan="4">Deduction Data</th>
                                            </tr>
                                            <tr>
                                                <th>Deduction</th>
                                                <th>Type</th>
                                                <th>Value</th>
                                                <th>Action</th>
                                            </tr>
                                            <tbody>
                                            <?php foreach ($data as $key => $datum){?>
                                                <tr>
                                                    <td><?= $this->deductionsModel->deductionDetails($datum['deduction_key'])->deduction_name?></td>
                                                    <td><?= $datum['deduction_type'];?></td>
                                                    <?php if($datum['deduction_type'] == 'percent'){?>
                                                        <td><?= $datum['deduction_value'];?></td>
                                                    <?php  }else{ ?>
                                                        <td><?= number_format(to_money($datum['deduction_value']));?></td>
                                                    <?php } ?>

                                                    <td style="text-align: center;"><a href="javascript:removeSessionDeduction(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td colspan="3"></td>
                                                <td style="text-align: center;"><a href="javascript:removeSessionDeductionAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    <?php }
                                    ?>
                                </div>
                                <div id="benefits-container">
                                    <?php
                                    $data = !empty($_SESSION['benefits']) ? $_SESSION['benefits']: false;
                                    if(!empty($data)){?>
                                        <table class="table table-sm table-danger table-bordered">
                                            <tr>
                                                <th colspan="3">Benefit Data</th>
                                            </tr>
                                            <tr>
                                                <th>Benefit</th>
                                                <th>Value</th>
                                                <th>Action</th>
                                            </tr>
                                            <tbody>
                                            <?php foreach ($data as $key => $datum){?>
                                                <tr>
                                                    <td><?= $this->benefitsModel->benefitDetails($datum['benefit_key'])->benefit_name?></td>
                                                    <td><?= number_format(to_dollar($datum['benefit_value']));?></td>

                                                    <td style="text-align: center;"><a href="javascript:removeSessionBenefit(<?= $key ?>);"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td colspan="2"></td>
                                                <td style="text-align: center;"><a href="javascript:removeSessionBenefitAll();"><i class="fa fa-trash-alt kt-font-danger"></i></a></td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    <?php }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <!--end: Form Wizard Step 5-->
                        <div class="row">
                            <label class="col-md-7 col-form-label"></label>
                            <div class="col-md-4">
                                <!--<button type="button" data-dismiss="modal" class="btn btn-sm btn-block btn-danger" name="button"><b>Cancel</b></button>-->
                                <button type="submit" class="btn btn-sm btn-block btn-success" name="button"><b>Process Payroll</b></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- end:: Content -->
</div>

<!-- begin:: Footer -->
<?php include VIEWPATH.'includes/footer.php'; ?>
<!-- end:: Footer -->
<div class="modal fade" id="insurance-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterPaye" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongPaye">Add Insurance</h5>
                <a data-dismiss="modal" href="#insurance-modal" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back">
                <form id="addInsuranceForm" class="kt-form" action="#" method="get" onsubmit="return false">
                    <div class="form-group row">
                        <div class="col-12">
                            <select name="insurer" id="insurance-insurer" class="form-control" style="width: 100%" >
                                <option value="">Select Insurance</option>
                                <?php if(!empty($insurances = $this->insurancesModel->insurances())){
                                    foreach ($insurances as $insurance){?>
                                        <option value="<?= $insurance['pr_insurance_key']?>"><?= $insurance['pr_insurer'];?></option>
                                    <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label">
                            <label class="label"> Company Cost</label>
                        </div>
                        <div class="col-md-8">
                            <input id="company-cost" required type="text" maxlength="30" name="company_cost" class="form-control" placeholder="Company Cost">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label"><label class="label"> Employee Cost</label></div>
                        <div class="col-md-8">
                            <input id="employee-cost" required type="text" maxlength="30" name="employee_cost" class="form-control" placeholder="Company Cost">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-8 col-form-label"></label>
                        <div class="col-4">
                            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Add Insurance</b></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Add Insurance</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="deductions-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterPaye" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongPaye">Add Insurance</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back">
                <form id="addDeductionForm" class="kt-form" action="#" method="get" onsubmit="return false">
                    <div class="form-group row">
                        <div class="col-12">
                            <select name="deduction_key" id="deduction_key" class="form-control" style="width: 100%" >
                                <option value="">Select Deduction</option>
                                <?php if(!empty($deductions = $this->deductionsModel->deductions())){
                                    foreach ($deductions as $deduction){?>
                                        <option value="<?= $deduction['deduction_key']?>"><?= $deduction['deduction_name'];?></option>
                                    <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label">
                            <label class="label"> Deduction Type</label>
                        </div>
                        <div class="col-md-8">
                            <input readonly id="deduction_type" required type="text" maxlength="30" name="deduction_type" class="form-control" placeholder="Deduction Type">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label"><label class="label"> Deduction Value</label></div>
                        <div class="col-md-8">
                            <input  id="deduction_value" required type="text"  name="deduction_value" class="form-control" placeholder="Deduction Value">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-8 col-form-label"></label>
                        <div class="col-4">
                            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Add Deduction</b></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Add Deduction</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="allowances-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterPaye" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongPaye">Add Allowance</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back">
                <form id="addAllowanceForm" class="kt-form" action="#" method="get" onsubmit="return false">
                    <div class="form-group row">
                        <div class="col-12">
                            <select name="allowance_key" id="allowance_key" class="form-control" style="width: 100%" >
                                <option value="">Select Deduction</option>
                                <?php if(!empty($allowances = $this->allowancesModel->allowances())){
                                    foreach ($allowances as $allowance){?>
                                        <option value="<?= $allowance['pr_allowance_key']?>"><?= $allowance['pr_allowance_name'];?></option>
                                    <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label">
                            <label class="label"> Allowance Type</label>
                        </div>
                        <div class="col-md-8">
                            <input readonly id="allowance_type" required type="text"  name="allowance_type" class="form-control" placeholder="Allowance Type">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label"><label class="label"> Allowance Value</label></div>
                        <div class="col-md-8">
                            <input  id="allowance_value" required type="text"  name="allowance_value" class="form-control" placeholder="Allowance Value">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-8 col-form-label"></label>
                        <div class="col-4">
                            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Add Allowance</b></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Add Allowance</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="benefits-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterPaye" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongPaye">Add Benefit</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back">
                <form id="addBenefitForm" class="kt-form" action="#" method="get" onsubmit="return false">
                    <div class="form-group row">
                        <div class="col-12">
                            <select required name="benefit_key" id="benefit_key" class="form-control" style="width: 100%" >
                                <option value="">Select Benefit</option>
                                <?php if(!empty($benefits = $this->benefitsModel->benefits())){
                                    foreach ($benefits as $benefit){?>
                                        <option value="<?= $benefit['benefit_key']?>"><?= $benefit['benefit_name'];?></option>
                                    <?php }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4 col-form-label"><label class="label"> Benefit Value</label></div>
                        <div class="col-md-8">
                            <input  id="benefit_value" required type="text"  name="benefit_value" class="form-control" placeholder="Benefit Value">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-8 col-form-label"></label>
                        <div class="col-4">
                            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Add Benefit</b></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Add Benefit</small>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="processNowModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Payroll processing</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name')?> | Payroll processing </small>
            </div>
        </div>
    </div>
</div>

<!-- begin::Quick Panel -->
<?php include VIEWPATH.'/menus/right.php'; ?>
<script type="text/javascript">
    $(function(){
        $('select').select2({placeholder: 'Select Option'});

        $('#benefit_key').change( function(){
            let benefit = $( this ).val();
            let $block = $('div#benefits-modal');
            $.ajax({
                url: '<?php echo base_url('payrolls/benefits/jsondata')?>/' + benefit,
                type: 'get',
                beforeSend: function(){
                    KTApp.block($block,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock($block);
                    if( result.status == true){
                        $('input#benefit_value').val(result.benefit_value);
                    }
                },
                error: function(xhr){
                    KTApp.unblock($block);
                    Swal.fire('',xhr.statusText,'warning');
                }
            });
        })
        $('form#addBenefitForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/benefits/addsessiondata');?>',
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    $('div#benefits-container').load('<?php echo base_url('payrolls/benefits/getsessiondata');?>')
                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })

        $('#allowance_key').change( function(){
            let allowance = $( this ).val();
            let $block = $('div#allowances-modal');
            $.ajax({
                url: '<?php echo base_url('payrolls/allowances/jsondata')?>/' + allowance,
                type: 'get',
                beforeSend: function(){
                    KTApp.block($block,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock($block);
                    if( result.status == true){
                        $('input#allowance_type').val(result.allowance_type);
                        $('input#allowance_value').val(result.allowance_value);
                    }
                },
                error: function(xhr){
                    KTApp.unblock($block);
                    Swal.fire('',xhr.statusText,'warning');
                }
            });
        })
        $('form#addAllowanceForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/allowances/addsessiondata');?>',
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    $('div#allowances-container').load('<?php echo base_url('payrolls/allowances/getsessiondata');?>')
                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })

        $('#deduction_key').change( function(){
            let deduction = $( this ).val();
            let $block = $('div#deductions-modal');
            $.ajax({
                url: '<?php echo base_url('payrolls/deductions/jsondata')?>/' + deduction,
                type: 'get',
                beforeSend: function(){
                    KTApp.block($block,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock($block);
                    if( result.status == true){
                        $('input#deduction_type').val(result.deduction_type);
                        $('input#deduction_value').val(result.deduction_value);
                    }
                },
                error: function(xhr){
                    KTApp.unblock($block);
                    Swal.fire('',xhr.statusText,'warning');
                }
            });
        })
        $('form#addDeductionForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/deductions/addsessiondata');?>',
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    $('div#deductions-container').load('<?php echo base_url('payrolls/deductions/getsessiondata');?>')
                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })

        $('#insurance-insurer').change( function(){
            let payroll = $( this ).val();
            let $block = $('div#insurance-modal');
            $.ajax({
                url: '<?php echo base_url('payrolls/insurance/jsondata')?>/'+payroll,
                type: 'get',
                beforeSend: function(){
                    KTApp.block($block,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock($block);
                    if( result.status == true){
                        $('input#company-cost').val(result.company_cost);
                        $('input#employee-cost').val(result.employee_cost);
                    }else{
                        Swal.fire('',result.employee_cost,'warning');
                    }
                },
                error: function(xhr){
                    KTApp.unblock($block);
                    Swal.fire('',xhr.statusText,'warning');
                }
            });
        })
        $('form#addInsuranceForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/insurance/addsessiondata');?>',
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Updating Variable ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    $('div#insurance-container').load('<?php echo base_url('payrolls/insurance/getsessiondata');?>')
                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })

    })

    function removeSessionBenefit(key){
        var url = '<?php echo base_url('payrolls/benefits/removesessiondata/');?>' + key;

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: url,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#benefits-container').load('<?php echo base_url('payrolls/benefits/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }
    function removeSessionBenefitAll(){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/benefits/removesessiondataall');?>',
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#benefits-container').load('<?php echo base_url('payrolls/benefits/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }

    function removeSessionAllowance(key){
        var url = '<?php echo base_url('payrolls/allowances/removesessiondata/');?>' + key;

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: url,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#allowances-container').load('<?php echo base_url('payrolls/allowances/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }
    function removeSessionAllowanceAll(){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/allowances/removesessiondataall');?>',
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#allowances-container').load('<?php echo base_url('payrolls/allowances/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }

    function removeSessionDeduction(key){
        var url = '<?php echo base_url('payrolls/deductions/removesessiondata/');?>' + key;

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: url,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#deductions-container').load('<?php echo base_url('payrolls/deductions/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }
    function removeSessionDeductionAll(){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/deductions/removesessiondataall');?>',
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#deductions-container').load('<?php echo base_url('payrolls/deductions/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }

    function removeSessionInsurance(key){
        var url = '<?php echo base_url('payrolls/insurance/removesessiondata/');?>' + key;

        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: url,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#insurance-container').load('<?php echo base_url('payrolls/insurance/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }
    function removeSessionInsuranceAll(){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/insurance/removesessiondataall');?>',
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"Removing ..."
                        });
                    },
                    success: function(){
                        KTApp.unblockPage();
                        $('div#insurance-container').load('<?php echo base_url('payrolls/insurance/getsessiondata');?>')
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }

    (function($, undefined) {
        "use strict";
        // When ready.
        $(function() {
            var $input = $( "input.number" );
            $input.on( "keyup", function( event ) {
                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if ( selection !== '' ) {
                    return;
                }
                // When the arrow keys are pressed, abort.
                if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                    return;
                }
                var $this = $( this );
                // Get the value.
                var input = $this.val();
                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt( input, 10 ) : 0;
                $this.val( function() {
                    return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                } );
            });
        });
    })(jQuery);

    $('form#employeesForm').submit( function(event){
        let form = $( this );
        let $div =  $('div.kt-portlet__body');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('payrolls/index/processoraction/'.$employee->user_id);?>',
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Processing payroll ..."
                });
            },
            success: function(r){
                KTApp.unblock($div);
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    Swal.fire('Success', obj.message, 'success');
                }else{
                    Swal.fire('An error occurred', obj.message, 'warning');
                }
            },
            error: function(xhr){
                KTApp.unblock($div);
                Swal.fire('Server Error!', xhr.statusText, 'warning');
            }
        });
    })
</script>
</body>
</html>
