<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<table class="table table-bordered">
    <tr>
        <th colspan="2">Payroll details</th>
    </tr>
    <tr>
        <td>Employee</td>
        <td><?= !empty($employee->firstname) && !empty($employee->lastname) ? $employee->firstname.' '.$employee->lastname:'N/A';?></td>
    </tr>
    <tr>
        <td>Date</td>
        <td><?= !empty($payroll->payroll_timestamp)? date('d-M-Y',strtotime($payroll->payroll_timestamp)):'N/A';?></td>
    </tr>
    <tr>
        <td>Net Salary</td>
        <td><?= !empty($payroll->payroll_net_salary)? number_format(to_money($payroll->payroll_net_salary)):'N/A';?></td>
    </tr>
    <tr>
        <td colspan="2">Payroll taxes</td>
    </tr>
    <?php $totalT =0;
    if(!empty($taxesy = isEmployeeTax($employee->user_id, $tax_key = $taxes['et_tax_key']))){
        foreach ($taxesy as $k => $tax) {?>
            <tr>
                <td><?php echo $tax['payroll_tax_name'];?></td>
                <td><?php echo number_format(to_money($tax['pd_t_amount']));?></td>
            </tr>
            <?php $totalT += $tax['pd_t_amount']; } } ?>
    <tr>
        <td>Total</td>
        <td><?php echo number_format(to_money($totalT));?></td>
    </tr>
    <?php $totalV =0; if(!empty($variables = employee_deductions($employee->user_id))){
        foreach ($variables as $y => $variable) {?>
            <tr>
                <td><?php echo $variable['deduction_name'].' <b>'.$variable['deduction_type'].'</b>';?></td>
                <td><?php echo number_format(to_money($variable['emp_deduction_value_amount']));?></td>
            </tr>
            <?php $totalV += $variable['emp_deduction_value_amount']; } } ?>
    <tr>
        <td>Total</td>
        <td><?php echo number_format(to_money($totalV));?></td>
    </tr>
    <tr>
        <td>PAYE</td>
        <td><?php if(!empty($payroll->pd_y_amount)) { echo number_format(to_money($payroll->pd_y_amount));}else{ echo 0;}?></td>
    </tr>
    <tr>
        <td>Take Home</td>
        <td><?= !empty($payroll->payroll_net_salary)? number_format(to_money($payroll->payroll_net_salary - $totalT + $totalV)):0;?></td>
    </tr>
</table>
