<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifyinsuranceForm" action="#" onsubmit="return false;">
    <div class="form-group row">
        <div class="col-12">
            <input required value="<?= $insurance->pr_insurer?>" type="text" maxlength="30" name="insurer" class="form-control" placeholder="Insurer">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="insurance-debit-account" style="width: 100%;" required class="form-control" name="insurance_debit_account">
                <option value="">Debit Account</option>
                <?php if($accounts = accounts()){
                    foreach ($accounts as $account){?>
                        <option <?php if(strtolower($insurance->pr_insurance_debit_account) == $account['account_key']) echo 'selected';?> value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="insurance-credit-account" style="width: 100%;" required class="form-control" name="insurance_credit_account">
                <option value="">Debit Account</option>
                <?php if($accounts = accounts()){
                    foreach ($accounts as $account){?>
                        <option <?php if(strtolower($insurance->pr_insurance_credit_account) == $account['account_key']) echo 'selected';?> value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="insurance-type" style="width: 100%;" required class="form-control" name="insurance_type">
                <option value="">Insurance Type</option>
                <option <?php if(strtolower($insurance->pr_insurance_type) == 'percentage') echo 'selected';?> value="percentage">Percentage</option>
                <option <?php if(strtolower($insurance->pr_insurance_type) == 'fixed') echo 'selected';?> value="fixed">Fixed Amount</option>
            </select>
        </div>
    </div>
    <?php if($insurance->pr_insurance_type =='fixed'){?>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= number_format(to_money($insurance->pr_company_cost))?>" maxlength="30" name="company_cost" class="form-control" placeholder="Company Cost">
            </div>
        </div>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= number_format(to_money($insurance->pr_employee_cost))?>" maxlength="30" name="employee_cost" class="form-control" placeholder="Employee Cost">
            </div>
        </div>
    <?php }else{ ?>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= $insurance->pr_company_cost?>" maxlength="30" name="company_cost" class="form-control" placeholder="Company Cost">
            </div>
        </div>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= $insurance->pr_employee_cost?>" maxlength="30" name="employee_cost" class="form-control" placeholder="Employee Cost">
            </div>
        </div>
    <?php } ?>

    <div class="form-group row">
        <div class="col-12">
            <textarea class="form-control" name="insurance_details" rows="3" cols="80" placeholder="Insurance details"><?= $insurance->pr_insurance_details?></textarea>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-9 col-form-label"></label>
        <div class="col-3">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Update</b></button>
        </div>
    </div>
</form>

<script type="text/javascript">
    $('select#insurance-type').select2({placeholder: "Select Insurance Type"});
    $('select#insurance-mode').select2({placeholder: "Select Insurance Mode"});
    jQuery(document).ready(function() {
        $('select#insurance-type').select2({placeholder: "Select Insurance Type"});
        $('select#insurance-mode').select2({placeholder: "Select Insurance Mode"});
        $('form#modifyinsuranceForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/insurance/updateinsurance/'.$insurance->pr_insurance_key);?>' ,
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Updating Insurance ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    if(result.status == true){
                        $('div#insuranceModify').modal('hide');
                        notifySuccess(result.message);
                        window.location.reload();
                    }else{
                        notifyWarning(result.message);
                    }

                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })
    });

</script>
