<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    @media print {
        .table{
            border: 1px solid silver;
        }
    }
    td {
        vertical-align: baseline;
        word-wrap: break-word
    }
    th {
        vertical-align: center;
        word-wrap: break-word
    }
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarPayrolls('payrolls');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Payrolls</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Current Payroll</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="kt-portlet kt-portlet--mobile">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3>List of Employees </h3>
                </div>
            </div>
            <div class="kt-portlet__body">
                <table class="table table-sm table-striped">
                    <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Employment</th>
                        <th>Gross</th>
                        <th>Deduction</th>
                        <th>Allowances</th>
                        <th>Internal Dept</th>
                        <th>Net Pay</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(!empty($employees)){
                        foreach ($employees as $key => $employee){
                            $classes = ['danger','danger','brand','brand','info','info','success','success','warning','warning'];
                            $i = random_int(0,9);
                            ?>
                            <tr>
                                <td>
                                    <div class="kt-user-card-v2">
                                        <div class="kt-user-card-v2__pic">
                                            <div class="kt-badge kt-badge--xl kt-badge--<?= $classes[$i] ?>"><?= $employee['firstname'][0].$employee['lastname'][0];?></div>
                                        </div>
                                        <div class="kt-user-card-v2__details">
                                            <a href="<?= base_url('hrm/employees/details/'.$employee['user_id'])?>" class="kt-user-card-v2__name"><?= $employee['firstname'].' '.$employee['lastname'];?></a>
                                            <span class="kt-user-card-v2__desc"><?= $employee['category_name']?></span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="kt-user-card-v2">
                                        <div class="kt-user-card-v2__details">
                                            <a href="#" class="kt-user-card-v2__name"><?= $employee['job_status'];?></a>
                                            <span class="kt-user-card-v2__desc"><?= $employee['department_name']?></span>
                                        </div>
                                    </div>
                                </td>
                                <td>0</td>
                                <td>0</td>
                                <td>0</td>
                                <td>0</td>
                                <td>0</td>
                                <td style="vert-align: middle; vertical-align: middle"><!--<a data-key="<?= $employee['user_id']?>" onclick="javascript:employeeDetails(<?= $employee['user_id']?>)" data-toggle="modal" data-backdrop="false" href="#employeeDetails"><span class="kt-badge--wide kt-badge--inline kt-badge kt-badge--success  text-uppercase">view</span></a>-->
                                    <div class="dropdown dropdown-inline">
                                                <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="flaticon-more"></i>
                                                </span>
                                        <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">
                                            <a class="dropdown-item" href="<?php echo base_url('payrolls/index/slips/'.$employee['user_id']);?>"><i class="la la-plus kt-font-success"></i> Salary Slips</a>
                                            <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-keyboard="false" data-key="<?= $employee['user_id']?>" href="#internalDept"><i class="la la-minus kt-font-warning"></i> Internal Debts</a>
                                            <!--<a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-keyboard="false" data-key="<?= $employee['user_id']?>" href="#insurance"><i class="la la-money kt-font-info"></i> Insurances</a>-->
                                            <!--<a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-keyboard="false" data-key="<?= $employee['user_id']?>" href="#deductions"><i class="la la-minus kt-font-danger"></i> Deductions</a>-->
                                            <!--<a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-keyboard="false" data-key="<?= $employee['user_id']?>" href="#benefits"><i class="la la-plus kt-font-success"></i> Benefits</a>-->
                                            <!--<div class="dropdown-divider"></div>-->
                                            <!--<a class="dropdown-item"  href="<?= base_url('hrm/employees/details/'.$employee['user_id'])?>"><i class="la la-cog kt-font-dark"></i> Profile</a>-->
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php }
                    } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- end:: Content -->
</div>

<div class="modal fade" id="employeeDetails" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Employee Details</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Employee Details</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="internalDept" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Internal Dept</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Employee Details</small>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="salarySlip" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Pay Slip</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> <?= config_item('application_name') ?> | Salary Slips</small>
            </div>
        </div>
    </div>
</div>
<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php include 'scripts.php';
?>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
