<script>

    "use strict";
    // Class definition


    jQuery(document).ready(function() {
        $('select#deduction-type').select2({placeholder: "Select Deduction Type"});
        $('select#deduction-debit-account').select2({placeholder: "Select Debit Account"});
        $('select#deduction-credit-account').select2({placeholder: "Select Credit Account"});

        $('form#newDeductionForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/deductions/newdeduction/')?>',
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Deduction ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    if(result.status == true){
                        $('div#newDeduction').modal('hide');
                        notifySuccess(result.message);
                        window.location.reload();
                    }else{
                        notifyWarning(result.message);
                    }

                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })
    });

    function deletededuction(deduction){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payrolls/deductions/delete/deduction')?>/'+deduction,
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Deduction ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if(result.status == true){
                            notifySuccess(result.message);
                            window.location.reload();
                        }else{
                            notifyWarning(result.message);
                        }

                    },
                    error: function(){
                        KTApp.unblockPage();
                    }
                });
            }
        })
    }

    $('#deductionModify').on('show.bs.modal', function (event) {
        var modal = $(this)
        modal.find('.modal-body').html('Loading details ...');
        var button = $(event.relatedTarget)
        var key = button.data('key')
        modal.find('.modal-body').load('<?php echo base_url('payrolls/deductions/deductionModify/');?>' + key);
    })

    $('#deductionDetails').on('show.bs.modal', function (event) {
        var modal = $(this)
        modal.find('.modal-body').html('Loading details ...');
        var button = $(event.relatedTarget)
        var key = button.data('key')
        modal.find('.modal-body').load('<?php echo base_url('payrolls/deductions/deductionDetails/');?>' + key);
    })
</script>