<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifyAllowanceForm" action="#" onsubmit="return false;">
    <div class="form-group row">
        <div class="col-12">
            <input required value="<?= $allowance->pr_allowance_name?>" type="text" maxlength="30" name="allowance_name" class="form-control" placeholder="Allowance Name">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="allowance-debit-account" style="width: 100%;" required class="form-control" name="allowance_debit_account">
                <option value="">Debit Account</option>
                <?php if($accounts = accounts()){
                    foreach ($accounts as $account){?>
                        <option <?php if(strtolower($allowance->pr_allowance_debit_account) == $account['account_key']) echo 'selected';?> value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="allowance-credit-account" style="width: 100%;" required class="form-control" name="allowance_credit_account">
                <option value="">Debit Account</option>
                <?php if($accounts = accounts()){
                    foreach ($accounts as $account){?>
                        <option <?php if(strtolower($allowance->pr_allowance_credit_account) == $account['account_key']) echo 'selected';?> value="<?= $account['account_key']?>"><?= $account['account_name']?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select id="allowance-type" style="width: 100%;" required class="form-control" name="allowance_type">
                <option value="">Allowance Type</option>
                <option <?php if(strtolower($allowance->pr_allowance_type) == 'percentage') echo 'selected';?> value="percentage">Percentage</option>
                <option <?php if(strtolower($allowance->pr_allowance_type) == 'fixed') echo 'selected';?> value="fixed">Fixed Amount</option>
            </select>
        </div>
    </div>
    <?php if($allowance->pr_allowance_type == 'fixed'){?>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= number_format(to_money($allowance->pr_allowance_value))?>" maxlength="30" name="allowance_value" class="form-control" placeholder="Allowance Value">
            </div>
        </div>
    <?php }else{?>
        <div class="form-group row">
            <div class="col-12">
                <input required type="decimal" value="<?= $allowance->pr_allowance_value?>" maxlength="30" name="allowance_value" class="form-control" placeholder="Allowance Value">
            </div>
        </div>
    <?php } ?>
    <div class="form-group row">
        <div class="col-12">
            <textarea class="form-control" name="allowance_details" rows="3" cols="80" placeholder="Allowance details"><?= $allowance->pr_allowance_details?></textarea>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-9 col-form-label"></label>
        <div class="col-3">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Update</b></button>
        </div>
    </div>
</form>

<script type="text/javascript">
    $('select#allowance-type').select2({placeholder: "Select Allowance Type"});
    $('select#allowance-mode').select2({placeholder: "Select Allowance Mode"});
    jQuery(document).ready(function() {
        $('form#modifyAllowanceForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('payrolls/allowances/updateallowance/'.$allowance->pr_allowance_key);?>' ,
                type: 'post',
                data: formdata,
                beforeSend: function(){
                    KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Updating Allowance ..."
                    });
                },
                success: function(result){
                    KTApp.unblockPage();
                    if(result.status == true){
                        $('div#allowanceModify').modal('hide');
                        notifySuccess(result.message);
                        window.location.reload();
                    }else{
                        notifyWarning(result.message);
                    }

                },
                error: function(){
                    KTApp.unblockPage();
                }
            });
        })
    });

</script>
