<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

       <?php topToolbar();?>

        <!-- begin:: Content -->
        <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
            <?php if(!empty($success)){ ?>
                <div class="alert alert-success fade show" role="alert">
                    <div class="alert-icon"><i class="flaticon-questions-circular-button"></i></div>
                    <div class="alert-text"><?php echo $success;?></div>
                    <div class="alert-close">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true"><i class="la la-close"></i></span>
                        </button>
                    </div>
                </div>
            <?php } ?>

            <?php  include "top_blocks.php"; ?>

            <form class="row" action="<?= base_url('payments/export')?>" method="post">
                <div class="form-group col-12">
                    <input type="text" class="form-control" name="filename" placeholder="Name of to be exported" required>
                </div>
                <div class="form-group col-md-3">
                    <input value="<?= date('Y-m-d')?>" required type="date" name="start" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <input value="<?= date('Y-m-d')?>" required type="date" name="end" class="form-control">
                </div>
                <div class="form-group col-md-3">
                    <select class="form-control select" name="status" required >
                        <option selected value="all">All Status</option>
                        <option value="pending">Pending</option>
                        <option value="approved">Approved</option>
                        <option value="paid">Paid Full</option>
                        <option value="partial paid">Paid Partial</option>
                        <option value="denied">Denial</option>
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <button type="submit"  class="btn btn-block btn-primary">Submit</button>
                </div>
            </form>
            <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
                <div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                            List of Requests <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                        </h3>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#payments-list" role="tab" aria-selected="false">
                                    Requests
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#payments-list-bin" role="tab" aria-selected="true">
                                    Recycle Bin
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="kt-portlet__body kt-portlet__body--fullheight">
                    <div class="tab-content">
                        <div class="tab-pane  active" id="payments-list">
                            <table id="bms_table_payments" class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Requester</th>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Paid</th>
                                    <th>Balance</th>
                                    <th>Payment Method</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="tab-pane" id="payments-list-bin">
                            <table id="bms_table_payments_bin" class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Requester</th>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Paid</th>
                                    <th>Balance</th>
                                    <th>Payment Method</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- end:: Content -->
    </div>
<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
    } else {
    $when = '';
}
?>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<!--begin::Page Scripts(used by this page) -->
<?php include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php include 'scripts.php'; ?>

<script type="text/javascript">

    var LMDatatablePayments = function() {

        var initPayments = function() {
            // begin first table
            let table = $('#bms_table_payments');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('payments/datasource/'.$hash.$when);?>',
                    columns: [
                        {data: 'request_id'},
                        {data: 'firstname'},
                        {data: 'request_date'},
                        {data: 'request_amount'},
                        {data: 'request_paid'},
                        {data: 'request_balance'},
                        {data: 'method_name'},
                        {data: 'request_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                if(full.company_name != null){
                                    return '<a href="javascript:(0)">'+ full.company_name + '</a>';
                                }
                                else {
                                    return '<a href="javascript:(0)">'+ full.firstname +' '+ full.lastname + '</a>';
                                }

                            }
                        },
                        {
                            targets: 3,
                            "width": "10%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.request_amount)) +'</a> ';
                            },
                        },{
                            targets: 4,
                            "width": "10%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.request_paid)) +'</a> ';
                            },
                        },{
                            targets: 5,
                            "width": "10%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.request_balance)) +'</a> ';
                            },
                        },
                        {
                            targets: 7,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "pending": {'request_status': 'Pending', 'class': 'kt-font-warning'},
                                    "approved": {'request_status': 'Approved', 'class': ' kt-font-brand'},
                                    "denied": {'request_status': 'Denied', 'class': ' kt-font-brand'},
                                    "paid": {'request_status': 'Paid', 'class': ' kt-font-success'},
                                    "partial paid": {'request_status': 'Partial Paid', 'class': ' kt-font-info'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="<?php echo base_url('payments/details/');?>' + full.request_key + '"><span class="' + status[data].class + ' kt-font-bolder">' + status[data].request_status + '</span></a>';
                            },
                        },
                        {
                            targets: 8,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                return '<a href="<?php echo base_url('payments/details/');?>'+ full.request_key + '" > View Details</a> &nbsp' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '<i class="flaticon-more-v2"></i>\n' +
                                    '</span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '<a class="dropdown-item"  href="<?php echo base_url('payments/payments/');?>' + full.request_key + '"><i class="la la-edit kt-font-warning"></i> Payments</a>\n' +
                                    '<a class="dropdown-item"  href="javascript:deletePayment(' + full.request_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                            },
                        },
                    ]
                });
            }
        };

        var initRecycle = function() {
            // begin first table
            let table = $('#bms_table_payments_bin');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('payments/datasourcebin/'.$hash.$when);?>',
                    columns: [
                        {data: 'request_id'},
                        {data: 'firstname'},
                        {data: 'request_date'},
                        {data: 'request_amount'},
                        {data: 'request_paid'},
                        {data: 'request_balance'},
                        {data: 'method_name'},
                        {data: 'request_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                if(full.company_name != null){
                                    return '<a href="javascript:(0)">'+ full.company_name + '</a>';
                                }
                                else {
                                    return '<a href="javascript:(0)">'+ full.firstname +' '+ full.lastname + '</a>';
                                }

                            }
                        },
                        {
                            targets: 3,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.request_amount)) +'</a> ';
                            },
                        },{
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.request_paid)) +'</a> ';
                            },
                        }
                        ,{
                            targets: 5,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.request_balance)) +'</a> ';
                            },
                        },
                        {
                            targets: 7,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "pending": {'request_status': 'Pending', 'class': 'kt-font-warning'},
                                    "approved": {'request_status': 'Approved', 'class': ' kt-font-brand'},
                                    "paid": {'request_status': 'Paid', 'class': ' kt-font-success'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="<?php echo base_url('payments/details/');?>' + full.request_key + '"><span class="' + status[data].class + ' kt-font-bolder">' + status[data].request_status + '</span></a>';
                            },
                        },
                        {
                            targets: 8,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                return '<a href="<?php echo base_url('payments/details/');?>'+ full.request_key + '" > View Details</a> &nbsp' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '<i class="flaticon-more-v2"></i>\n' +
                                    '</span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '<a class="dropdown-item"  href="javascript:restorePayment(' + full.request_key + ');"><i class="la la-reply kt-font-success"></i> Restore</a>\n' +
                                    // '<a class="dropdown-item"  href="javascript:deleteForever(' + full.request_key + ');"><i class="la la-trash kt-font-danger"></i> Delete Permanently</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                            },
                        },
                    ]
                });
            }
        };

        return {
            //main function to initiate the module
            init: function() {
                initPayments();
                initRecycle();
            },

        };

    }();

    jQuery(document).ready(function() {

        LMDatatablePayments.init();

    });

    function deletePayment(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payments/delete')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restorePayment(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payments/restore')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>

<div class="modal fade" id="new-request" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Create Payment Request</h5>
                <a id="print" href="javascript:(0);" class=" modal-title text-white"
                   style="right:60px; position:absolute;">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                         height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M16,17 L16,21 C16,21.5522847 15.5522847,22 15,22 L9,22 C8.44771525,22 8,21.5522847 8,21 L8,17 L5,17 C3.8954305,17 3,16.1045695 3,15 L3,8 C3,6.8954305 3.8954305,6 5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,15 C21,16.1045695 20.1045695,17 19,17 L16,17 Z M17.5,11 C18.3284271,11 19,10.3284271 19,9.5 C19,8.67157288 18.3284271,8 17.5,8 C16.6715729,8 16,8.67157288 16,9.5 C16,10.3284271 16.6715729,11 17.5,11 Z M10,14 L10,20 L14,20 L14,14 L10,14 Z"
                                  id="Combined-Shape" fill="#000000"/>
                            <rect id="Combined-Shape-Copy" fill="#000000" opacity="0.3" x="8" y="2" width="8" height="2"
                                  rx="1"/>
                        </g>
                    </svg>
                </a>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal"
                   class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                         height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z"
                                  id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10"
                                  rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back" id="printArea">
                <form class="row" id="new-request-form" >
                    <div class="form-group col-md-6">
                        <label>Requester</label>
                        <select name="request_requester" class="form-control select" required style="width: 100%;">
                            <option value="">Select option</option>
                            <?php if(!empty($customers = employees())){
                                foreach ($customers as $customer){?>
                                    <option value="<?= $customer['user_id']?>"><?= $customer['firstname'].' '.$customer['lastname']?></option>
                                <?php }
                            } ?>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Requester Date</label>
                        <input type="date" name="request_date" class="form-control" required placeholder="Requester Date">
                    </div>
                    <div class="form-group col-md-6">
                        <label>Client</label>
                        <select id="client_request" name="request_client" class="form-control select" required  style="width: 100%;">
                            <option value="">Select option</option>
                            <?php if(!empty($customers = customers())){
                                foreach ($customers as $customer){
                                    if(!empty($customer['firstname'])){?>
                                    <option value="<?= $customer['user_id']?>"><?= $customer['firstname'].' '.$customer['lastname']?></option>
                                <?php }}
                                foreach ($customers as $customer){
                                    if(!empty($customer['company_name'])){?>
                                        <option value="<?= $customer['user_id']?>"><?= $customer['company_name']?></option>
                                    <?php }}
                            } ?>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                      <label>Client Project</label>
                      <div id="client_projects">
                          <select style="width: 100%;" required class="form-control select">
                              <option value="">Choose Client First</option>
                          </select>
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Mode of Payment</label>
                        <select name="request_payment_mode" class="form-control select" required  style="width: 100%;">
                            <option value="">Select option</option>
                            <?php if(!empty($customers = paymentMethods())){
                                foreach ($customers as $customer){?>
                                    <option value="<?= $customer['method_key']?>"><?= $customer['method_name']?></option>
                                <?php }
                            } ?>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Request Receiver</label>
                        <input type="text" name="request_receiver" class="form-control" placeholder="Request Receiver">
                    </div>
                    <div class="form-group col-md-12">
                        <label>Attachment</label>
                        <input type="file" name="file" class="form-control" placeholder="Request Receiver">
                    </div>
                    <div class="form-group col-md-12">
                        <label>Payment Details</label>
                        <textarea type="text" name="request_payment_details" class="form-control" placeholder="Payment Details"></textarea>
                    </div>
                    <div class="col-12">
                            <div class="kt-portlet kt-portlet--bordered" id="kt_repeater_items">
                                <div class="kt-portlet__head">
                                    <div class="kt-portlet__head-label">
                                        <h3 class="kt-portlet__head-title">Particulars</h3>
                                    </div>
                                </div>
                                <div class="kt-portlet__body">
                                    <div id="kt_repeater_products">
                                        <div data-repeater-list="group_items">
                                            <div data-repeater-item class="align-items-center">

                                                <div class="item-container">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="kt-form__group--inline">
                                                                <label class="col-form-label">Item Name</label>
                                                                <div class="kt-form__control">
                                                                    <?php $data = $this->paymentItems->find_all();?>
                                                                    <select class="form-control request_reason" name="request_reason">

                                                                        <option value="">Select Option</option>
                                                                        <?php
                                                                        if(!empty($data)){
                                                                            foreach ($data as $key => $datum){?>
                                                                                <option value="<?= $datum['item_key']?>"><?= strtoupper($datum['item_name'])?></option>
                                                                            <?php }}?>

                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="kt-form__group--inline">
                                                                <label class="col-form-label">Item Price</label>
                                                                <div class="kt-form__control">
                                                                    <input required name="request_item_price" type="text" class="form-control request_item_price request_item_price">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="kt-form__group--inline">
                                                                <label class="col-form-label">Quantity</label>
                                                                <div class="kt-form__control">
                                                                    <input required name="request_item_qty" type="text" class="form-control request_item_qty">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="kt-form__group--inline">
                                                                <label class="col-form-label">Currency</label>
                                                                <div class="kt-form__control">
                                                                    <select class="form-control request_item_currency" name="request_item_currency">
                                                                        <option value="">Select Option</option>
                                                                        <option value="TZS">TZS</option>
                                                                        <option value="USD">USD</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="kt-form__group--inline">
                                                                <label class="col-form-label">Sub Total</label>
                                                                <div class="kt-form__control">
                                                                    <input type="text" readonly name="request_item_sub_total"  class="form-control request_item_sub_total" required />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-10 kt-form__group--inline">
                                                            <label class="col-form-label">Other Reason</label>
                                                            <textarea class="form-control request_other_reason" name="request_other_reason" placeholder="Other Reason" ></textarea>
                                                        </div>
                                                        <div class="col-md-2 kt-form__group--inline">
                                                            <label class="col-form-label">&nbsp<br/><p></p></label>
                                                            <a style="width: 100%;" href="javascript:;" data-repeater-delete="" class="btn btn-block  btn-outline-danger btn-bold">
                                                                Remove</i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br/>
                                    <div class="kt-portlet__foot kt-portlet__foot--sm kt-align-right form-group">
                                        <div class="row">
                                            <div class="col-md-10">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <button type="submit" class="btn btn-block btn-warning">Submit</button>
                                                    </div>
                                                    <div class="col-md-4"></div>
                                                    <div class="col-md-4">
                                                        <input class="form-control grand_total" name="request_amount" placeholder="Request Amount" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">

                                                <a href="javascript:;" data-repeater-create="" class="btn btn-bold btn-sm btn-label-brand">
                                                    <i class="la la-plus"></i> Add
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>
</div>
</div>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
