<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->
<link href="<?php echo base_url('resources')?>/assets/css/pages/inbox/inbox.css" rel="stylesheet" type="text/css" />
<style>
    td {word-wrap: break-word}
    #invoice{
        padding: 30px;
    }

    .invoice {
        position: relative;
        background-color: #FFF;
        min-height: 680px;
        padding: 15px
    }

    .invoice header {
        padding: 10px 0;
        margin-bottom: 20px;
        border-bottom: 1px solid #3989c6
    }

    .invoice .company-details {
        text-align: right
    }

    .invoice .company-details .name {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .contacts {
        margin-bottom: 20px
    }

    .invoice .invoice-to {
        text-align: left
    }

    .invoice .invoice-to .to {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .invoice-details {
        text-align: right
    }

    .invoice .invoice-details .invoice-id {
        margin-top: 0;
        color: #3989c6
    }

    .invoice main {
        padding-bottom: 50px
    }

    .invoice main .thanks {
        margin-top: -100px;
        font-size: 2em;
        margin-bottom: 50px
    }

    .invoice main .notices {
        padding-left: 6px;
        border-left: 6px solid #3989c6
    }

    .invoice main .notices .notice {
        font-size: 1.2em
    }

    .invoice table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        margin-bottom: 20px
    }

    .invoice table td,.invoice table th {
        padding: 15px;
        background: #eee;
        border-bottom: 1px solid #fff
    }

    .invoice table th {
        white-space: nowrap;
        font-weight: 400;
        font-size: 16px
    }

    .invoice table td h3 {
        margin: 0;
        font-weight: 400;
        color: #3989c6;
        font-size: 1.2em
    }

    .invoice table .qty,.invoice table .total,.invoice table .unit {
        text-align: right;
        font-size: 1.2em
    }

    .invoice table .no {
        color: #fff;
        font-size: 1.6em;
        background: #3989c6
    }

    .invoice table .unit {
        background: #ddd
    }

    .invoice table .total {
        background: #3989c6;
        color: #fff
    }

    .invoice table tbody tr:last-child td {
        border: none
    }

    .invoice table tfoot td {
        background: 0 0;
        border-bottom: none;
        white-space: nowrap;
        text-align: right;
        padding: 10px 20px;
        font-size: 1.2em;
        border-top: 1px solid #aaa
    }

    .invoice table tfoot tr:first-child td {
        border-top: none
    }

    .invoice table tfoot tr:last-child td {
        color: #3989c6;
        font-size: 1.4em;
        border-top: 1px solid #3989c6
    }

    .invoice table tfoot tr td:first-child {
        border: none
    }

    .invoice footer {
        width: 100%;
        text-align: center;
        color: #777;
        border-top: 1px solid #aaa;
        padding: 8px 0
    }

    @media print {
        body * {
            visibility: hidden;
        }

        .invoice, .invoice * {
            visibility: visible;
        }
    }
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolbar();?>

    <!-- begin:: Content -->
        <div class="kt-container kt-container--fluid">
            <div class="row">
                <div class="col-12">
                    <div class="bs-example">
                        <nav >
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:(0);">Payments</a></li>
                                <li class="breadcrumb-item"><a href="javascript:(0);">Requests</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">Details</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="kt-portlet" >
<!--                onsubmit="create_invoice(); return false;"-->
                <div class="kt-portlet__body " id="list-content">
                    <!--Author      : @arboshiki-->
                    <div>

                        <div class="toolbar hidden-print">
                            <div class="text-right">
                                <button id="printInvoice" class="btn btn-info"><i class="fa fa-print"></i> Print</button>
                                <?php if(!empty($request['doc_name'])){?>
                                    <a target="_blank" href="<?php echo base_url('uploads/payments/'.$request['doc_name']);?>" class="btn btn-primary"><i class="la la-file"></i> View Attachment</a>
                               <?php  } ?>
                                <?php if( has_role("Edit_Payment") & strtolower($request['request_status']) == 'pending'){?> <a href="<?php echo base_url('payments/modify/'.$request['request_key']);?>" class="btn btn-info"><i class="la la-edit"></i> Modify</a><?php } ?>
                                <a href="<?php echo base_url('payments/payments/'.$request['request_key']);?>" class="btn btn-primary"><i class="la la-edit"></i> Payments</a>
                                <?php if( has_role("Approve_Payment")){?><a href="javascript:approve(<?= $request['request_key']?>);" class="btn btn-success"><i class="la la-money"></i> Approve</a><?php } ?>
                                <?php if( has_role("Denial_Payment")){?><a href="javascript:dennie(<?= $request['request_key']?>);" class="btn btn-danger"><i class="la la-money"></i> Denie</a><?php } ?>
                                <?php if( has_role("Retire_Payment")){?><a href="javascript:retire(<?= $request['request_key']?>);" class="btn btn-warning"><i class="la la-money"></i> Retire</a><?php } ?>
                            </div>
                            <hr>
                        </div>
                        <div class="invoice overflow-auto" id="invoice">
                            <div style="min-width: 600px">
                                <header>
                                    <div class="row">
                                        <div class="col company-details">
                                            <div href="#" class="kt-invoice__logo">
                                                <?= display_address()?>
                                            </div>
                                        </div>
                                    </div>
                                </header>
                                <main>
                                    <?php
                                        if(strtolower($request['request_status']) == 'denied') {?>
                                            <div class="alert alert-outline-danger" role="alert">
                                                <div class="alert-text">
                                                    <h4 class="alert-heading">This request has been <b>REFUSED</b></h4>
                                                    <p>Reason for refusal </p>
                                                    <hr>
                                                    <p class="mb-0"><?= $request['request_cancel_reason']?></p>
                                                </div>
                                            </div>
                                        <?php }
                                    ?>
                                    <div class="row contacts">
                                        <div class="col invoice-to">
                                            <div class="text-gray-light">Requester Name:</div>
                                            <h2 class="to">
                                                <?php
                                                if(!empty($request['company_name'])):
                                                    echo $request['company_name'];
                                                else:
                                                    echo $request['firstname'].' '.$request['lastname'];
                                                endif;
                                                ?>
                                            </h2>
                                        </div>

                                        <div class="col invoice-to">
                                            <div class="text-gray-light">Receiver:</div>
                                            <h2 class="to">
                                                <?php
                                                echo ucwords($request['request_receiver']);
                                                ?>
                                            </h2>
                                        </div>
                                        <div class="col invoice-details">
                                            <h1 class="invoice-id">#<?=  $request['request_id']. " | ".ucwords($request['request_status']).' - '.$request['request_retired'] ?></h1>
                                            <div class="date">Date of Request: <?=  date("d/m/Y",strtotime($request['request_date'])) ?></div>
                                        </div>
                                    </div>

                                    <?php if(!empty($request['request_other_reason'])){?>
                                        <div class="alert alert-secondary">
                                            <?= $request['request_other_reason'] ?>
                                        </div>
                                    <?php } ?>

                                    <?php
                                        $client = profile($request['request_client'])
                                    ?>
                                    <table class="table table-sm table-condensed table-borderless">
                                        <thead>
                                            <tr>
                                                <th class="text-left">Client</th>
                                                <th class="text-left">Contact</th>
                                                <th class="text-left">Project ID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="text-left"><?= $client->firstname.' '.$client->lastname?></td>
                                                <td class="text-left"><?= $client->email?></td>
                                                <td class="text-left"><?= $request['request_project']?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <br/>
                                    <table class="table table-sm table-condensed table-borderless">
                                        <thead>
                                        <tr>
                                            <th class="text-left">Receiver</th>
                                            <th class="text-left">Payment Method</th>
                                            <th class="text-left">Payment Details</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td  class="text-left"><?= $request['request_receiver']?></td>
                                                <td  class="text-left"><?= $request['method_name']?></td>
                                                <td  class="text-left"><?= $request['request_payment_details']?></td>
                                            </tr>
                                        </tbody>
                                    </table>


                                    <table border="0" cellspacing="0" cellpadding="0">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th class="text-left">REASON</th>
                                            <th class="text-left">OTHER REASON</th>
                                            <th class="text-right">PRICE</th>
                                            <th class="text-right">CURRENCY</th>
                                            <th class="text-right">QUANTITY</th>
                                            <th class="text-right" >SUB TOTAL</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(!empty($items)){
                                            foreach ($items as $i => $item){ ?>
                                                <tr>
                                                    <td class="no"><?= $i + 1;?></td>
                                                    <td class="text-left">
                                                        <h3>
                                                            <?php $getItems = $this->paymentItems->find_all();
                                                                foreach ($getItems as $get){
                                                                    if($get['item_key'] == $item['request_data_item_reason']){
                                                                        print strtoupper($get['item_name']);
                                                                    }
                                                                }
                                                            ?>
                                                        </h3>
                                                    </td>
                                                    <td class="text-left"><?= $item['request_data_item_other_reason'];?></td>
                                                    <td class="unit"><?= number_format(round(to_money($item['request_data_item_price'])));?></td>
                                                    <td class="unit"><?= $item['request_data_item_currency'];?></td>
                                                    <td class="qty"><?= number_format(round($item['request_data_item_qty']));?></td>
                                                    <td class="qty"><?= number_format(round(to_money($item['request_data_item_sub_total'])));?>
                                                </tr>
                                            <?php }
                                        } ?>

                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <td colspan="4"></td>
                                            <td colspan="2">Request Amount</td>
                                            <td><?= number_format(round(to_money($request['request_amount'])));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="4"></td>
                                            <td colspan="2">Request Paid</td>
                                            <td><?= number_format(round(to_money($request['request_paid'])));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="4"></td>
                                            <td colspan="2">Request Balance</td>
                                            <td><?= number_format(round(to_money($request['request_amount'] - $request['request_paid'])));?></td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </main>
                                <footer>
                                    Request was created on a computer and is valid without the signature and seal.
                                </footer>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <!-- end:: Content -->
    <!--Begin:: Inbox Compose-->
    <div class="modal modal-sticky-bottom-right modal-sticky-lg" id="kt_compose" role="dialog" data-backdrop="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content kt-inbox">
                <div class="kt-inbox__form" id="kt_inbox_compose_form">
                    <?php $attr = array( 'class' => 'kt-form','id'=>'formCompose');
                    echo form_open('', $attr );?>
                    <div class="kt-inbox__head">
                        <div class="kt-inbox__title">Compose email</div>
                        <div class="kt-inbox__actions">
                            <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light" data-dismiss="modal">
                                <i class="flaticon2-cross"></i>
                            </button>
                        </div>
                    </div>
                    <div class="kt-inbox__body">
                        <div class="kt-inbox__to">
                            <div class="kt-inbox__wrapper">
                                <div class="kt-inbox__field kt-inbox__field--to">
                                    <div class="kt-inbox__input">
                                        <label>To : </label>
                                        <input type="email" class="form-control" name="compose_to" placeholder="Enter email here" value="<?= $request['email']; ?>" id="compose_to" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="kt-inbox__subject" hidden>
                            <input class="form-control" name="compose_subject" placeholder="Subject : Enter subject here" value="Invoice - <?= $request['request_id']; ?>" id="title" required>
                        </div>
                        <div class="kt-inbox__subject">
                            <textarea class="form-control summernote" name="compose_msg" placeholder="Type message here..." id="body" required></textarea>
                        </div>
                    </div>
                    <div class="kt-inbox__foot">
                        <div class="kt-inbox__primary">
                            <div class="btn-group">
                                <button type="submit" class="btn btn-brand btn-bold">
                                    Send Invoice
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
    <!--End:: Inbox Compose-->

    <!--Begin:: Link invoice to freight -->
    <div class="modal modal-sticky-bottom-right modal-sticky-lg" id="kt_to_freight" role="dialog" data-backdrop="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content kt-inbox">
                <div class="kt-inbox__form" id="kt_inbox_compose_form">
                    <?php $attr = array( 'class' => 'kt-form','id'=>'linkCompose');
                    echo form_open('', $attr );?>
                    <div class="kt-inbox__head">
                        <div class="kt-inbox__title">Link this Invoice to Freight</div>
                        <div class="kt-inbox__actions">
                            <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light" data-dismiss="modal">
                                <i class="flaticon2-cross"></i>
                            </button>
                        </div>
                    </div>
                    <div class="kt-inbox__body">
                        <div class="kt-inbox__to">
                            <div class="kt-inbox__wrapper">
                                <div class="kt-inbox__field kt-inbox__field--to">
                                    <div class="kt-inbox__input">
                                        <input type="number" class="form-control file_number" name="file_number" placeholder="Enter file number here" id="file_number" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="kt-inbox__foot">
                        <div class="kt-inbox__primary">
                            <div class="btn-group">
                                <button type="submit" class="btn btn-brand btn-bold">
                                    SUBMIT
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!--End:: Link invoice to freight-->
</div>

<?php include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>

<script>
    $('#printInvoice').click(function(){
        Popup($('#invoice').outerHTML);
        function Popup(data)
        {
            window.print();
            return true;
        }
    });
</script>
<script>

    async function paynow(activity) {

        const { value: ipAddress } = await Swal.fire({
            title: 'Enter Amount Paid',
            input: 'text',
            inputLabel: 'Payment Amount',
            inputValue: "",
            showCancelButton: true,
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value === '') {
                        resolve('Please Enter Amount')
                    } else {
                        Swal.close();
                        let data = {'amount' : value, 'key': activity}
                        update_payment(data);
                    }
                })
            }
        })

    }

    function update_payment(data){
        $.ajax({
            url: '<?php echo base_url('payments/paynow')?>',
            type: 'post',
            data: data,
            beforeSend: function(){
                KTApp.blockPage({
                    overlayColor:"#000000",
                    type:"loader",
                    state:"warning",
                    message:"Updating request ..."
                });
            },
            success: function(result){
                KTApp.unblockPage();
                if( result.status == true){
                    notifySuccess(result.message);
                    window.location.reload();
                }else{

                    swal.fire("","An error occurred! "+ result.message,"warning");
                }
            },
            error: function(xhr){
                KTApp.unblockPage();
                <?php if(ENVIRONMENT !== 'production'){?>
                Swal.fire('Server Error!', xhr.statusText,'error');
                <?php }?>
            }
        });
    }

    function update_reason(data){
        $.ajax({
            url: '<?php echo base_url('payments/dennie')?>',
            type: 'post',
            data: data,
            beforeSend: function(){
                KTApp.blockPage({
                    overlayColor:"#000000",
                    type:"loader",
                    state:"warning",
                    message:"Updating request ..."
                });
            },
            success: function(result){
                KTApp.unblockPage();
                if( result.status == true){
                    notifySuccess(result.message);
                    window.location.reload();
                }else{

                    swal.fire("","An error occurred! "+ result.message,"warning");
                }
            },
            error: function(xhr){
                KTApp.unblockPage();
                <?php if(ENVIRONMENT !== 'production'){?>
                Swal.fire('Server Error!', xhr.statusText,'error');
                <?php }?>
            }
        });
    }

    function approve(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Approve it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payments/approve')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Approving Payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            window.location.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function retire(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Retire!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('payments/retire')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Retiring Payment ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            window.location.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    async function dennie(activity) {

        const { value: ipAddress } = await Swal.fire({
            title: 'Reason why dennie',
            input: 'textarea',
            inputLabel: 'Enter reason',
            inputValue: "",
            showCancelButton: true,
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value === '') {
                        resolve('Please provide reason')
                    } else {
                        Swal.close();
                        let data = {'reason' : value, 'key': activity}
                        update_reason(data);
                    }
                })
            }
        })

    }


    $("#kt_compose").on('show.bs.modal', function (event) {
        $("form#formCompose").resetForm();
    })

    $("#kt_to_freight").on('show.bs.modal', function (event) {
        $("form#linkCompose").resetForm();
    })

    $(function () {
        $('form#formCompose').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);

            $.ajax({
                url: "<?php echo base_url('freight/index/sendInvoice/'.$request['request_key']);?>",
                data: formdata,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Sending Invoice, please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    $("#kt_compose").modal("hide");
                    if( result.status === true){
                        notifySuccess(result.message);

                    }else{
                        $("#kt_compose").modal("hide");
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    $("#kt_compose").modal("hide");
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Success!', 'Invoice Successfully sent','success');
                    //Swal.fire('Server Error!', xhr.statusText,'warning');
                    <?php }?>
                }

            });
        });
    })

    $(function () {
        $('form#linkCompose').submit(function (event) {
            event.preventDefault();
            let file_number = $('input#file_number').val();
            //alert(file_number);
            Swal.fire({
                title: 'Are you sure?',
                type: 'warning',
                text: 'You are about to link this invoice to file number '+ file_number,
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, link it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?php echo base_url('freight/index/request_to_freight')?>/' + file_number,
                        data: {
                            'request_key' : '<?= $request['request_key']; ?>',
                        },
                        type: 'post',
                        beforeSend: function(){
                            $("#kt_to_freight").modal("hide");
                            KTApp.blockPage({
                                overlayColor:"#000000",
                                type:"loader",
                                state:"warning",
                                message:"Processing, please wait ..."
                            });
                        },
                        success: function(result){
                            $("#kt_to_freight").modal("hide");
                            KTApp.unblockPage();
                            if( result.status == true){
                                swal.fire("Success", "Invoice Successfully linked to freight", "success");
                                //notifySuccess(result.message);
                            }else{
                                swal.fire("Warning",result.message,"warning");
                            }
                        },
                        error: function(xhr){
                            $("#kt_to_freight").modal("hide");
                            KTApp.unblockPage();
                            <?php if(ENVIRONMENT !== 'production'){?>
                            Swal.fire('Error!', xhr.statusText,'warning');
                            <?php }?>
                        }
                    });
                }
            })
        });
    })
</script>
<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>

