<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/css/pages/inbox/inbox.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}

    td {word-wrap: break-word}
    #invoice{
        padding: 30px;
    }

    .invoice {
        position: relative;
        background-color: #FFF;
        min-height: 680px;
        padding: 15px
    }

    .invoice header {
        padding: 10px 0;
        margin-bottom: 20px;
        border-bottom: 1px solid #3989c6
    }

    .invoice .company-details {
        text-align: right
    }

    .invoice .company-details .name {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .contacts {
        margin-bottom: 20px
    }

    .invoice .invoice-to {
        text-align: left
    }

    .invoice .invoice-to .to {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .invoice-details {
        text-align: right
    }

    .invoice .invoice-details .invoice-id {
        margin-top: 0;
        color: #3989c6
    }

    .invoice main {
        padding-bottom: 50px
    }

    .invoice main .thanks {
        margin-top: -100px;
        font-size: 2em;
        margin-bottom: 50px
    }

    .invoice main .notices {
        padding-left: 6px;
        border-left: 6px solid #3989c6
    }

    .invoice main .notices .notice {
        font-size: 1.2em
    }

    .invoice table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        margin-bottom: 20px
    }

    .invoice table td,.invoice table th {
        padding: 15px;
        background: #eee;
        border-bottom: 1px solid #fff
    }

    .invoice table th {
        white-space: nowrap;
        font-weight: 400;
        font-size: 16px
    }

    .invoice table td h3 {
        margin: 0;
        font-weight: 400;
        color: #3989c6;
        font-size: 1.2em
    }

    .invoice table .qty,.invoice table .total,.invoice table .unit {
        text-align: right;
        font-size: 1.2em
    }

    .invoice table .no {
        color: #fff;
        font-size: 1.6em;
        background: #3989c6
    }

    .invoice table .unit {
        background: #ddd
    }

    .invoice table .total {
        background: #3989c6;
        color: #fff
    }

    .invoice table tbody tr:last-child td {
        border: none
    }

    .invoice table tfoot td {
        background: 0 0;
        border-bottom: none;
        white-space: nowrap;
        text-align: right;
        padding: 10px 20px;
        font-size: 1.2em;
        border-top: 1px solid #aaa
    }

    .invoice table tfoot tr:first-child td {
        border-top: none
    }

    .invoice table tfoot tr:last-child td {
        color: #3989c6;
        font-size: 1.4em;
        border-top: 1px solid #3989c6
    }

    .invoice table tfoot tr td:first-child {
        border: none
    }

    .invoice footer {
        width: 100%;
        text-align: center;
        color: #777;
        border-top: 1px solid #aaa;
        padding: 8px 0
    }

    @media print {
        body * {
            visibility: hidden;
        }

        .invoice, .invoice * {
            visibility: visible;
        }
    }
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuInvoices();?>

    <!-- begin:: Content -->
        <div class="kt-container kt-container--fluid">
            <div class="row">
                <div class="col-12">
                    <div class="bs-example">
                        <nav >
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:(0);">Invoices</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">Details</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            
            <div class="kt-portlet" >
<!--                onsubmit="create_invoice(); return false;"-->
                <div class="kt-portlet__body kt-portlet__body--fullheight" id="list-content">
                    <!--Author      : @arboshiki-->
                    <div >

                        <div class="toolbar hidden-print">
                            <div class="text-right">
                                <a href="<?php echo base_url('invoices/modify/'.$invoice['inv_key']);?>" class="btn btn-info"><i class="la la-edit"></i> Modify</a>
                                <button id="printInvoice" class="btn btn-info"><i class="fa fa-print"></i> Print</button>
                                <button id="sendInvoicey" class="btn btn-info" data-toggle="modal" data-target="#kt_compose"><i class="la la-envelope"></i> Send</button>
                                <?php $paid = 0;
                                if (!empty($payments)){
                                foreach ($payments as $payment) {
                                    $paid += $payment['inv_pay_amount'];
                                    }}
                                $balance = $invoice['inv_total_after_tax'] - $paid;
                                if($balance > 0){?>
                                    <a href="#add-payment" data-toggle="modal" data-backdrop="false" class="btn btn-info"><i class="la la-money"></i> Add Payments</a>
                               <?php } ?>
                            </div>
                            <hr>
                        </div>
                        <div class="invoice overflow-auto" id="invoice">
                            <div >
                                <header>
                                    <div class="row">
                                        <div class="col">
                                            <a  href="javascript:(0);">
                                                <?php
                                                $text = "{'id':'".$invoice['inv_id']."', 'key':'".$invoice['inv_key']."','amount':'".number_format(to_money($invoice['inv_total_after_tax']))."', 'recipient':'".$invoice['firstname']." ".$invoice['middlename']." ".$invoice['lastname']."','date of issue':'".$invoice['inv_issued_date']."', 'expiring date':'".$invoice['inv_expiring_date']."'}";
                                                $path = writablePath('invoices/qrimages/'.$invoice['inv_key'].'.png');
                                                $qrurl = writablePathUrl('invoices/qrimages/'.$invoice['inv_key'].'.png');
                                                $this->qrcodes->createImage($text,$path);
                                                ?>
                                                <img data-holder-rendered="true" class="pull-left"  style="display: block; width: 120px; height: auto;  margin-left: 0px;" src="<?php echo $qrurl;?>" />
                                            </a>
                                        </div>
                                        <div class="col company-details">
                                            <div href="#" class="kt-invoice__logo">
                                                <a href="#"><img style="width: 200px; height: 120px" src="<?php echo base_url('resources/')?>assets/images/rurutz-logo.PNG"></a><br>
                                                <span class="kt-invoice__desc">
                                                    <span> Plot No.162/38, 2nd Floor, Diamond Plaza, </span>
                                                    <span> Office No. 201, Mirambo Street & Samora Avenue, Dar es Salaam, Tanzania, </span>
                                                    <span> Tel:+255 786 490 408 | +255 754 490 408 | </span>
                                                    <span> e-mail: joyce.kazyoba@rurutz.com </span>
                                                    <span> info1@rurutz.com, website: www.ruru.co.tz </span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </header>
                                <main>
                                    <div class="row contacts">
                                        <div class="col invoice-to">
                                            <div class="text-gray-light">INVOICE TO:</div>
                                            <h2 class="to">
                                                <?php
                                                if(!empty($invoice['company_name'])):
                                                    echo $invoice['company_name'];
                                                else:
                                                    echo $invoice['firstname'].' '.$invoice['middlename'].' '.$invoice['lastname'];
                                                endif;
                                                ?>
                                            </h2>
                                            <div class="address"><?=  $invoice['inv_address'] ?></div>
                                            <div class="email text-muted"><a class="text-muted" href="mailto:john@example.com"><?=  $invoice['mobilephone'] ?></a></div>
                                        </div>
                                        <div class="col invoice-details">
                                            <h1 class="invoice-id">INVOICE <?=  $invoice['inv_id'] ?></h1>
                                            <div class="date">Date of Invoice: <?=  date("d/m/Y",strtotime($invoice['inv_issued_date'])) ?></div>
                                            <div class="date">Due Date: <?=  date("d/m/Y",strtotime($invoice['inv_expiring_date'])) ?></div>
                                        </div>
                                    </div>
                                    <table class="table  table-light--info table-striped">
                                        <thead class="text-muted">
                                        <tr class="text-muted">
                                            <th colspan="7">PAYMENTS</th>
                                        </tr>
                                        <tr class="text-muted">
                                            <th>Date</th>
                                            <th>Receiver</th>
                                            <th>Payment Method</th>
                                            <th>Reference</th>
                                            <th>Amount</th>
                                            <th>Post Status</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php  $paid = 0; if(!empty($payments)){
                                                foreach ($payments as $payment){
                                                    $paid += $payment['inv_pay_amount'];?>
                                                    <tr>
                                                        <td><?php echo date('d-M-Y',strtotime($payment['inv_pay_date']));?></td>
                                                        <td><?php echo $payment['firstname'].' '.$payment['lastname'];?></td>
                                                        <td><?php echo $payment['method_name'];?></td>
                                                        <td><?php echo $payment['inv_pay_reference'];?></td>
                                                        <td><?php echo number_format(to_money($payment['inv_pay_amount']));?></td>
                                                        <td class="kt-font-bolder text-muted"><?php echo $payment['inv_pay_post_status'];?></td>
                                                    </tr>
                                                <?php }
                                            } ?>
                                        </tbody>
                                    </table>

                                    <table class="table" border="0" cellspacing="0" cellpadding="0">
                                        <tr>
                                            <td colspan="2"></td>
                                            <td colspan="2">INVOICE AMOUNT</td>
                                            <td><?= number_format(to_money($invoice['inv_total_after_tax']));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"></td>
                                            <td colspan="2">PAID</td>
                                            <td><?= number_format(to_money($paid));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"></td>
                                            <td colspan="2">BALANCE</td>
                                            <td>
                                                <?php $balance = $invoice['inv_total_after_tax'] - $paid;?>
                                                <?= number_format(to_money($balance));?>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                    <?php
                                        $status['inv_total_balance'] = $balance;
                                        $status['inv_total_paid'] = $paid;
                                         if($balance <= 0){
                                                $status['inv_status'] = "PAID";
                                           }else if($balance > 0 && $balance < $invoice['inv_total_after_tax']){
                                                $status['inv_status'] = "PARTIAL";
                                           }else{
                                                $status['inv_status'] = "UNPAID";
                                         };
                                         $this->db->where('inv_key',$invoice['inv_key']);
                                         $this->db->update("invoices",$status);
                                     ?>
                                </main>
                            </div>
                            <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                            <div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <!-- end:: Content -->
</div>
<!--Begin:: Invoice Compose-->
<div class="modal modal-sticky-bottom-right modal-sticky-lg" id="kt_compose" role="dialog" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content kt-inbox">
            <div class="kt-inbox__form" id="kt_inbox_compose_form">
                <?php $attr = array( 'class' => 'kt-form','id'=>'formCompose');
                echo form_open('', $attr );?>
                <div class="kt-inbox__head">
                    <div class="kt-inbox__title">Compose email</div>
                    <div class="kt-inbox__actions">
                        <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light" data-dismiss="modal">
                            <i class="flaticon2-cross"></i>
                        </button>
                    </div>
                </div>
                <div class="kt-inbox__body">
                    <div class="kt-inbox__to">
                        <div class="kt-inbox__wrapper">
                            <div class="kt-inbox__field kt-inbox__field--to">
                                <div class="kt-inbox__input">
                                    <label>To : </label>
                                    <input type="email" class="form-control" name="compose_to" placeholder="Enter email here" value="<?= $invoice['email']; ?>" id="compose_to" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="kt-inbox__subject" hidden>
                        <input class="form-control" name="compose_subject" placeholder="Subject : Enter subject here" value="Invoice - <?= $invoice['inv_id']; ?>" id="title" required>
                    </div>
                    <div class="kt-inbox__subject">
                        <textarea class="form-control summernote" name="compose_msg" placeholder="Type message here..." id="body" required></textarea>
                    </div>
                </div>
                <div class="kt-inbox__foot">
                    <div class="kt-inbox__primary">
                        <div class="btn-group">
                            <button type="submit" class="btn btn-brand btn-bold">
                                Send Invoice
                            </button>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<!--End:: Invoice Compose-->
<div class="modal" id="add-payment" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog  modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 >Add Payment</h3>
            </div>
            <div class="modal-body" style="min-height: 100px;">
                <form id="add-payment-form" class="kt-form col-12" onsubmit="add_payment(); return false;">
                    <input name="inv_pay_invoice" type="hidden"  class="form-control col-12" value="<?php echo $invoice['inv_key'];?>" required />
                    <div class="form-group row">
                        <label>Payment Method</label>
                        <select name="inv_pay_method" required style="width: 100%;" class="form-control col-12">
                            <option selected value="">Select Option</option>
                            <?php if(!empty($payments = paymentMethods())){
                                foreach ($payments as $payment){?>
                                    <option value="<?php echo $payment['method_key'];?>"><?php echo $payment['method_name'];?></option>
                               <?php }
                            } ?>
                        </select>
                    </div>
                    <div class="form-group row">
                            <label>Payment Reference</label>
                            <input name="inv_pay_reference"  class="form-control col-12" placeholder="Reference" required />
                    </div>
                    <div class="form-group row">
                            <label>Payment Amount</label>
                            <input name="inv_pay_amount"  class="form-control col-12 number" placeholder="Amount" required />
                    </div>

                    <div class="form-group row">
                        <label>Description</label>
                        <textarea  name="inv_pay_details"  class="form-control col-12" placeholder="Description" required ></textarea>
                    </div>
                    <div class="form-group row">
                        <div class="col-6">
                            <button class="btn pull-left btn-dark" data-dismiss="modal">Cancel</button>
                        </div>
                        <div class="col-6">
                            <button class="btn pull-right btn-success" type="submit">Add Payment</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<?php include VIEWPATH.'includes/footer.php';?>
<!--begin::Page Vendors(used by this page) -->
<script src="<?= base_url('resources/')?>/assets/plugins/custom/tinymce/tinymce.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<script>
    $('#printInvoice').click(function(){
        Popup($('#invoice').outerHTML);
        function Popup(data)
        {
            window.print();
            return true;
        }
    });
</script>
<script>
    $("#kt_compose").on('show.bs.modal', function (event) {
        $("form#formCompose").resetForm();
    })

    $(function () {

        $('form#formCompose').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);

            $.ajax({
                url: "<?php echo base_url('freight/index/sendInvoice/'.$invoice['inv_key']);?>",
                data: formdata,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Sending Invoice, please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Success!', 'Invoice Successfully sent','success');
                    //Swal.fire('Server Error!', xhr.statusText,'warning');
                    <?php }?>
                }

            });
        });
    })
</script>
<script>

    "use strict";
    // Class definition

    var KTTinymce = function () {
        // Private functions
        var demos = function () {

            tinymce.init({
                selector: '#kt-tinymce-1',
                toolbar: false,
                statusbar: false
            });

            tinymce.init({
                selector: '#kt-tinymce-2'
            });

            tinymce.init({
                selector: '#kt-tinymce-3',
                toolbar: 'advlist | autolink | link image | lists charmap | print preview',
                plugins : 'advlist autolink link image lists charmap print preview'
            });

            tinymce.init({
                selector: '#kt-tinymce-4',
                menubar: false,
                toolbar: ['styleselect fontselect fontsizeselect',
                    'undo redo | cut copy paste | bold italic | link image | alignleft aligncenter alignright alignjustify',
                    'bullist numlist | outdent indent | blockquote subscript superscript | advlist | autolink | lists charmap | print preview |  code'],
                plugins : 'advlist autolink link image lists charmap print preview code'
            });
        }

        return {
            // public functions
            init: function() {
                demos();
            }
        };
    }();

    // Initialization
    jQuery(document).ready(function() {
        KTTinymce.init();
    });

    $("select").select2({placeholder: "Select Option"});
    $('#add-payment').on('show.bs.modal', function (event) {
        let modal = $(this);
        const form = modal.find('form');
        form.resetForm();
    })

    function add_payment() {
        let form = $('form#add-payment-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('invoices/addpayment');?>',
            type: 'post',
            data: formData,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Adding Payment, Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblock(form);
                if (result.status == true) {
                    $('#add-payment').modal("hide");
                    Swal.fire('', result.message, 'success');
                    window.location.reload();
                } else {
                    Swal.fire('', result.message, 'warning');
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }
</script>


<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>

