<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->
<link href="<?php echo base_url('resources')?>/assets/css/pages/inbox/inbox.css" rel="stylesheet" type="text/css" />
<style>
    td {word-wrap: break-word}
    #invoice{
        padding: 30px;
    }

    .invoice {
        position: relative;
        background-color: #FFF;
        min-height: 680px;
        padding: 15px
    }

    .invoice header {
        padding: 10px 0;
        margin-bottom: 20px;
        border-bottom: 1px solid #3989c6
    }

    .invoice .company-details {
        text-align: right
    }

    .invoice .company-details .name {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .contacts {
        margin-bottom: 20px
    }

    .invoice .invoice-to {
        text-align: left
    }

    .invoice .invoice-to .to {
        margin-top: 0;
        margin-bottom: 0
    }

    .invoice .invoice-details {
        text-align: right
    }

    .invoice .invoice-details .invoice-id {
        margin-top: 0;
        color: #3989c6
    }

    .invoice main {
        padding-bottom: 50px
    }

    .invoice main .thanks {
        margin-top: -100px;
        font-size: 2em;
        margin-bottom: 50px
    }

    .invoice main .notices {
        padding-left: 6px;
        border-left: 6px solid #3989c6
    }

    .invoice main .notices .notice {
        font-size: 1.2em
    }

    .invoice table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        margin-bottom: 20px
    }

    .invoice table td,.invoice table th {
        padding: 15px;
        background: #eee;
        border-bottom: 1px solid #fff
    }

    .invoice table th {
        white-space: nowrap;
        font-weight: 400;
        font-size: 16px
    }

    .invoice table td h3 {
        margin: 0;
        font-weight: 400;
        color: #3989c6;
        font-size: 1.2em
    }

    .invoice table .qty,.invoice table .total,.invoice table .unit {
        text-align: right;
        font-size: 1.2em
    }

    .invoice table .no {
        color: #fff;
        font-size: 1.6em;
        background: #3989c6
    }

    .invoice table .unit {
        background: #ddd
    }

    .invoice table .total {
        background: #3989c6;
        color: #fff
    }

    .invoice table tbody tr:last-child td {
        border: none
    }

    .invoice table tfoot td {
        background: 0 0;
        border-bottom: none;
        white-space: nowrap;
        text-align: right;
        padding: 10px 20px;
        font-size: 1.2em;
        border-top: 1px solid #aaa
    }

    .invoice table tfoot tr:first-child td {
        border-top: none
    }

    .invoice table tfoot tr:last-child td {
        color: #3989c6;
        font-size: 1.4em;
        border-top: 1px solid #3989c6
    }

    .invoice table tfoot tr td:first-child {
        border: none
    }

    .invoice footer {
        width: 100%;
        text-align: center;
        color: #777;
        border-top: 1px solid #aaa;
        padding: 8px 0
    }

    @media print {
        body * {
            visibility: hidden;
        }

        .invoice, .invoice * {
            visibility: visible;
        }
    }
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuInvoices();?>

    <!-- begin:: Content -->
        <div class="kt-container kt-container--fluid">
            <div class="row">
                <div class="col-12">
                    <div class="bs-example">
                        <nav >
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:(0);">Invoices</a></li>
                                <li class="breadcrumb-item active"><a href="javascript:(0);">Details</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            
            <div class="kt-portlet" >
<!--                onsubmit="create_invoice(); return false;"-->
                <div class="kt-portlet__body kt-portlet__body--fullheight" id="list-content">
                    <!--Author      : @arboshiki-->
                    <div>

                        <div class="toolbar hidden-print">
                            <div class="text-right">
                                <!--<button id="linkInvoice" data-toggle="modal" data-target="#kt_to_freight" class="btn btn-info"><i class="fa fa-link"></i> Link to Freight</button>-->
                                <a href="<?php echo base_url('invoices/modify/'.$invoice['inv_key']);?>" class="btn btn-info"><i class="la la-edit"></i> Modify</a>
                                <button id="printInvoice" class="btn btn-info"><i class="fa fa-print"></i> Print</button>
                                <button id="sendInvoicey" class="btn btn-info" data-toggle="modal" data-target="#kt_compose"><i class="la la-envelope"></i> Send</button>
                                <a href="<?php echo base_url('invoices/payments/'.$invoice['inv_key']);?>" class="btn btn-info"><i class="la la-money"></i> Payments</a>
                            </div>
                            <hr>
                        </div>
                        <div class="invoice overflow-auto" id="invoice">
                            <div style="min-width: 600px">
                                <header>
                                    <div class="row">
                                        <div class="col">
                                            <a  href="javascript:(0);">
                                                <?php
                                                $text = "{'id':'".$invoice['inv_id']."', 'key':'".$invoice['inv_key']."','amount':'".number_format($invoice['inv_total_after_tax'])."', 'recipient':'".$invoice['company_name']." ".$invoice['firstname']." ".$invoice['middlename']." ".$invoice['lastname']."','date of issue':'".$invoice['inv_issued_date']."','expiring date':'".$invoice['inv_expiring_date']."', 'status':'".$invoice['inv_status']."'}";
                                                $path = writablePath('invoices/qrimages/'.$invoice['inv_key'].'.png');
                                                $qrurl = writablePathUrl('invoices/qrimages/'.$invoice['inv_key'].'.png');
                                                $this->qrcodes->createImage($text,$path);
                                                ?>
                                                <img data-holder-rendered="true" class="pull-left"  style="display: block; width: 120px; height: auto;  margin-left: 0px;" src="<?php echo $qrurl;?>" />
                                            </a>
                                        </div>
                                        <div class="col company-details">
                                            <div href="#" class="kt-invoice__logo">
                                                <a href="#"><img style="height: 100%;" src="<?php echo base_url('resources/')?>assets/images/rurutz-logo.PNG"></a><br>
                                                <span class="kt-invoice__desc">
                                                    <span> Plot No.15555, 5th Floor, Lockminds Tower, </span>
                                                    <span> Office No. 100, Lockminds Street & Shamp Avenue, Dar es Salaam, Tanzania, </span>
                                                    <span> Tel:+255 000 555 555 | +255 111 555 555 | </span>
                                                    <span> e-mail: demo@lockminds.com </span>
                                                    <span> info1@lockminds.com, website: www.lockminds.com </span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </header>
                                <main> 
                                    <div class="row contacts">
                                        <div class="col invoice-to">
                                            <div class="text-gray-light">INVOICE TO:</div>
                                            <h2 class="to">
                                                <?php
                                                if(!empty($invoice['company_name'])):
                                                echo $invoice['company_name'];
                                                else:
                                                echo $invoice['firstname'].' '.$invoice['middlename'].' '.$invoice['lastname'];
                                                endif;
                                                ?>
                                            </h2>
                                            <div class="address"><?=  $invoice['inv_address'] ?></div>
                                            <div class="email"><a href="mailto:john@example.com"><?=  $invoice['mobilephone'] ?></a></div>
                                        </div>
                                        <div class="col invoice-details">
                                            <h1 class="invoice-id">INVOICE <?=  $invoice['inv_id'] ?></h1>
                                            <div class="date">Date of Invoice: <?=  date("d/m/Y",strtotime($invoice['inv_issued_date'])) ?></div>
                                            <div class="date">Due Date: <?=  date("d/m/Y",strtotime($invoice['inv_expiring_date'])) ?></div>
                                        </div>
                                    </div>
                                    <table border="0" cellspacing="0" cellpadding="0">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th class="text-left">DESCRIPTION</th>
                                            <th class="text-right">PRICE</th>
                                            <th class="text-right">QUANTITY</th>
                                            <th class="text-right">TAX</th>
                                            <th class="text-right">BEFORE TAX</th>
                                            <th class="text-right">TOTAL</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(!empty($items)){
                                            foreach ($items as $i => $item){ ?>
                                                <tr>
                                                    <td class="no"><?= $i + 1;?></td>
                                                    <td class="text-left">
                                                        <h3>
                                                            <a  href="javascript:(0);">
                                                                <?= $item['inv_data_item'];?>
                                                            </a>
                                                        </h3>
                                                        <?= $item['inv_data_item_details'];?>
                                                    </td>
                                                    <td class="unit"><?= number_format(round(to_money($item['inv_data_item_price'])));?></td>
                                                    <td class="qty"><?= number_format(round($item['inv_data_item_qty']));?></td>
                                                    <td class="qty"><?= number_format(round(to_money($item['inv_data_item_tax_value'])));?><br/>
                                                        <span><small><?= $item['inv_data_item_tax_inclusive'] ? 'Inclusive' : 'Exclusive'?></small></span></td>
                                                    <td class="qty"><?= number_format(round(to_money($item['inv_data_item_before_tax'])));?></td>
                                                    <td class="total"><?= number_format(round(to_money($item['inv_data_item_after_tax'])));?></td>
                                                </tr>
                                            <?php }
                                        } ?>

                                        </tbody>
                                        <tfoot>
                                        <tr>
                                            <td colspan="4"></td>
                                            <td colspan="2">SUBTOTAL</td>
                                            <td><?= number_format(round(to_money($invoice['inv_total_before_tax'])));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="4"></td>
                                            <td colspan="2">TAX</td>
                                            <td><?= number_format(round(to_money($invoice['inv_total_tax'])));?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="4"></td>
                                            <td colspan="2">GRAND TOTAL</td>
                                            <td><?= number_format(round(to_money($invoice['inv_total_after_tax'])));?></td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                    <div class="thanks">Thank you!</div>
                                    <div class="notices">
                                        <div>NOTICE:</div>
                                        <div class="notice"><?= nl2br($invoice['inv_details']) ?></div>
                                    </div>
                                </main>
                                <footer>
                                    Invoice was created on a computer and is valid without the signature and seal.
                                </footer>
                            </div>
                            <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                            <div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <!-- end:: Content -->
    <!--Begin:: Inbox Compose-->
    <div class="modal modal-sticky-bottom-right modal-sticky-lg" id="kt_compose" role="dialog" data-backdrop="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content kt-inbox">
                <div class="kt-inbox__form" id="kt_inbox_compose_form">
                    <?php $attr = array( 'class' => 'kt-form','id'=>'formCompose');
                    echo form_open('', $attr );?>
                    <div class="kt-inbox__head">
                        <div class="kt-inbox__title">Compose email</div>
                        <div class="kt-inbox__actions">
                            <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light" data-dismiss="modal">
                                <i class="flaticon2-cross"></i>
                            </button>
                        </div>
                    </div>
                    <div class="kt-inbox__body">
                        <div class="kt-inbox__to">
                            <div class="kt-inbox__wrapper">
                                <div class="kt-inbox__field kt-inbox__field--to">
                                    <div class="kt-inbox__input">
                                        <label>To : </label>
                                        <input type="email" class="form-control" name="compose_to" placeholder="Enter email here" value="<?= $invoice['email']; ?>" id="compose_to" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="kt-inbox__subject" hidden>
                            <input class="form-control" name="compose_subject" placeholder="Subject : Enter subject here" value="Invoice - <?= $invoice['inv_id']; ?>" id="title" required>
                        </div>
                        <div class="kt-inbox__subject">
                            <textarea class="form-control summernote" name="compose_msg" placeholder="Type message here..." id="body" required></textarea>
                        </div>
                    </div>
                    <div class="kt-inbox__foot">
                        <div class="kt-inbox__primary">
                            <div class="btn-group">
                                <button type="submit" class="btn btn-brand btn-bold">
                                    Send Invoice
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!--End:: Inbox Compose-->

    <!--Begin:: Link invoice to freight -->
    <div class="modal modal-sticky-bottom-right modal-sticky-lg" id="kt_to_freight" role="dialog" data-backdrop="false">
        <div class="modal-dialog" role="document">
            <div class="modal-content kt-inbox">
                <div class="kt-inbox__form" id="kt_inbox_compose_form">
                    <?php $attr = array( 'class' => 'kt-form','id'=>'linkCompose');
                    echo form_open('', $attr );?>
                    <div class="kt-inbox__head">
                        <div class="kt-inbox__title">Link this Invoice to Freight</div>
                        <div class="kt-inbox__actions">
                            <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light" data-dismiss="modal">
                                <i class="flaticon2-cross"></i>
                            </button>
                        </div>
                    </div>
                    <div class="kt-inbox__body">
                        <div class="kt-inbox__to">
                            <div class="kt-inbox__wrapper">
                                <div class="kt-inbox__field kt-inbox__field--to">
                                    <div class="kt-inbox__input">
                                        <input type="number" class="form-control file_number" name="file_number" placeholder="Enter file number here" id="file_number" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="kt-inbox__foot">
                        <div class="kt-inbox__primary">
                            <div class="btn-group">
                                <button type="submit" class="btn btn-brand btn-bold">
                                    SUBMIT
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
    <!--End:: Link invoice to freight-->
</div>

<?php include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>

<script>
    $('#printInvoice').click(function(){
        Popup($('#invoice').outerHTML);
        function Popup(data)
        {
            window.print();
            return true;
        }
    });
</script>
<script>
    $("#kt_compose").on('show.bs.modal', function (event) {
        $("form#formCompose").resetForm();
    })

    $("#kt_to_freight").on('show.bs.modal', function (event) {
        $("form#linkCompose").resetForm();
    })

    $(function () {

        $('form#formCompose').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);

            $.ajax({
                url: "<?php echo base_url('freight/index/sendInvoice/'.$invoice['inv_key']);?>",
                data: formdata,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Sending Invoice, please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    $("#kt_compose").modal("hide");
                    if( result.status === true){
                        notifySuccess(result.message);

                    }else{
                        $("#kt_compose").modal("hide");
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    $("#kt_compose").modal("hide");
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Success!', 'Invoice Successfully sent','success');
                    //Swal.fire('Server Error!', xhr.statusText,'warning');
                    <?php }?>
                }

            });
        });
    })

    $(function () {

        $('form#linkCompose').submit(function (event) {
            event.preventDefault();
            let file_number = $('input#file_number').val();
            //alert(file_number);
            Swal.fire({
                title: 'Are you sure?',
                type: 'warning',
                text: 'You are about to link this invoice to file number '+ file_number,
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, link it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?php echo base_url('freight/index/inv_to_freight')?>/' + file_number,
                        data: {
                            'inv_key' : '<?= $invoice['inv_key']; ?>',
                        },
                        type: 'post',
                        beforeSend: function(){
                            $("#kt_to_freight").modal("hide");
                            KTApp.blockPage({
                                overlayColor:"#000000",
                                type:"loader",
                                state:"warning",
                                message:"Processing, please wait ..."
                            });
                        },
                        success: function(result){
                            $("#kt_to_freight").modal("hide");
                            KTApp.unblockPage();
                            if( result.status == true){
                                swal.fire("Success", "Invoice Successfully linked to freight", "success");
                                //notifySuccess(result.message);
                            }else{
                                swal.fire("Warning",result.message,"warning");
                            }
                        },
                        error: function(xhr){
                            $("#kt_to_freight").modal("hide");
                            KTApp.unblockPage();
                            <?php if(ENVIRONMENT !== 'production'){?>
                            Swal.fire('Error!', xhr.statusText,'warning');
                            <?php }?>
                        }
                    });
                }
            })
        });
    })
</script>
<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>

