<script type="text/javascript">
"use strict";

// Class definition
var KTLockminds = function() {

    // Daterangepicker Init
    var daterangepickerInit = function() {

        if ($('#kt_dashboard_daterangepicker').length == 0) {
            return;
        }
        var picker = $('#kt_dashboard_daterangepicker');
        var start = moment();
        var end = moment();

        function cb(start, end, label) {
            var title = '';
            var range = '';

            if ((end - start) < 100 || label == 'Today') {
              // window.location.href = "<?php echo base_url('/dashboard?when=today');?>";
            } else if (label == 'Yesterday') {
              window.location.href = "<?php echo base_url('/dashboard?when=yesterday');?>";
            } else {
                range = start.format('MMM D') + ' - ' + end.format('MMM D');
                window.location.href = "<?php echo base_url('/dashboard?when=custome&start=');?>" + start + ' &end=' + end;
            }

        }

        picker.daterangepicker({
            direction: KTUtil.isRTL(),
            minYear: '<?php echo date('Y',strtotime(config_item('config_fiscal_year')));?>',
            minDate: '<?php echo date('m/d/Y',strtotime(config_item('config_fiscal_year')));?>',
            startDate: start,
            endDate: end,
            opens: 'left',
            showDropdowns: true,
            linkedCalendars: false,
            ranges: {
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, cb);

        cb(start, end, '');
    }


    return {
        // Init demos
        init: function() {

            // init daterangepicker
            daterangepickerInit();

        }
    };
}();

// Class initialization on page load
jQuery(document).ready(function() {

  KTLockminds.init();

    $( "div.modal" ).draggable({
        cursor: "auto",
        handle: ".modal-header"
    });

    $("#phonenumber").inputmask('+ 999 999 999999', {
        numericInput: true
    });

    (function($, undefined) {
        "use strict";
        // When ready.
        $(function() {
            var $input = $( "input.number" );
            $input.on( "keyup", function( event ) {
                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if ( selection !== '' ) {
                    return;
                }
                // When the arrow keys are pressed, abort.
                if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                    return;
                }
                var $this = $( this );
                // Get the value.
                var input = $this.val();
                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt( input, 10 ) : 0;
                $this.val( function() {
                    return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                } );
            });
        });
    })(jQuery);

});

  function to_money(money){
  let unit = '<?php echo 1 * (!empty($currency = runnCurrency())) ? $currency->bs_conversion : 1;?>';
  let result = money * unit;
  return result.toFixed(<?php echo (!empty($config = $this->configurationModel->loadConfigs())) ? $config->decimal_display : 0;?>);
}

  function ucfirst(string){
  var str = string.toLowerCase();
  return str.charAt(0).toUpperCase() + str.slice(1);
}

  function notifySuccess(message){
		$.notify({
				// options
				message: message,
			},{
				// settings
				element: 'body',
				position: null,
				type: "success",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 500,
				url_target: '_blank',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
				template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
					'<span data-notify="icon"></span> ' +
					'<span data-notify="title">{1}</span> ' +
					'<span data-notify="message">{2}</span>' +
					'<div class="progress" data-notify="progressbar">' +
						'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
					'</div>' +
				'</div>'
			});
	}

  function notifySuccessUnlock(message,urlData){
		$.notify({
				// options
				message: message,
        url: urlData,
			},{
				// settings
				element: 'body',
				position: null,
				type: "success",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 3600000,
				url_target: '_self',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
			});
	}

  function notifyWarning(message){
		$.notify({
				// options
				message: message,
			},{
				// settings
				element: 'body',
				position: null,
				type: "warning",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 2000,
				url_target: '_blank',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
				template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
					'<span data-notify="icon"></span> ' +
					'<span data-notify="title">{1}</span> ' +
					'<span data-notify="message">{2}</span>' +
					'<div class="progress" data-notify="progressbar">' +
						'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
					'</div>' +
				'</div>'
			});
	}


    let refresh = false;
    var checkInternet = function(){
            if (navigator.onLine === true) {
                $("div#internet_status").html("Online");
                $("div#offline_indicator").hide();
                $("button#internet_status_button").removeClass("btn-label-danger").addClass("btn-label-success");
                if(refresh){
                    refresh = false;
                    window.location.reload();
                }
            }else{
                refresh = true;
                $("div#internet_status").html("Offline");
                $("div#offline_indicator").show();
                document.addEventListener("click",disableClick,true);
                $("button#internet_status_button").addClass("btn-label-danger").removeClass("btn-label-success");
            }
    }

    $(document).ready(function(){
        var bmsVar = setInterval(checkInternet, 1000);

        $('#setCurrency').on('show.bs.modal', function (event) {
            let modal = $(this)
            modal.find('.modal-dialog').html(
                '<div class="kt-portlet">'+
                '<div class="kt-portlet__body">' +
                ' Please wait'+
                '</div></div>');
            let target = $(event.relatedTarget)
            let key = target.data('key')
            modal.find('.modal-dialog').load('<?php echo base_url();?>commonajax/setCurrency');
        })

    });

    function disableClick(e){
        e.stopPropagation();
        e.preventDefault();
    }

    function checkpassword(){
        let password = document.getElementById('password');
        let cpassword = document.getElementById('confirm');
        let button = document.getElementById('submit');

        if(cpassword.value !== password.value || password.value.length < 5){
            password.style.border = "2px";
            password.style.borderStyle = "solid";
            password.style.borderColor = 'red';
            cpassword.style.border = "2px";
            cpassword.style.borderStyle = "solid";
            cpassword.style.borderColor = 'red';
            button.setAttribute("disabled", "");
        }else{
            password.style.border = "2px";
            password.style.borderStyle = "solid";
            password.style.borderColor = 'green';
            cpassword.style.border = "2px";
            cpassword.style.borderStyle = "solid";
            cpassword.style.borderColor = 'green';
            button.removeAttribute("disabled", "");
        }
    }

    function checkemail(email){
        let spinner = $('div#spinnerEmail');
        let input = $('input#email');
        event.preventDefault();
        $.ajax({
            url: '<?php echo base_url('/app/checkemailonly/');?>' + encodeURIComponent(email),
            type: 'get',
            beforeSend: function(){
                spinner.addClass('kt-spinner');
                input.removeClass('is-valid is-invalid');
            },
            success: function(r){
                var obj = JSON.parse(r);
                spinner.removeClass('kt-spinner');
                if(obj.status == 'ok'){
                    input.addClass('is-valid');
                }else{
                    input.addClass('is-invalid');
                }
            },
            error: function(){
                spinner.removeClass('kt-spinner');
                Swal.fire('',obj.message,'warning');
            }
        });
    }

    function checkusername(username){
        let spinner = $('div#spinnerUsername');
        let input = $('input#username');
        event.preventDefault();
        $.ajax({
            url: '<?php echo base_url('/app/checkusernameonly/');?>' + encodeURIComponent(username),
            type: 'get',
            beforeSend: function(){
                spinner.addClass('kt-spinner');
                input.removeClass('is-valid is-invalid');
            },
            success: function(r){
                var obj = JSON.parse(r);
                spinner.removeClass('kt-spinner');
                if(obj.status == 'ok'){
                    input.addClass('is-valid');
                }else{
                    input.addClass('is-invalid');
                }
            },
            error: function(){
                spinner.removeClass('kt-spinner');
                Swal.fire('',obj.message,'warning');
            }
        });
    }

    function enableClick(e){

    }

function playAudio() {
    var x = document.getElementById("soundAlert");
    try {
        x.play();
    } catch(err) {

    }
}

function addSpinner(body){
    body.html("<div class='kt-align-center'> <div class='lds-default kt-align-center'><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div></div>");
}
</script>


