<script type="text/javascript">

  var LMDatatableGroups= function() {
    	var initTable = function() {
    		// begin first table
    		var table = $('#lm_table_request').DataTable({
    			responsive: true,
    			// Pagination settings
    			dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			// read more: https://datatables.net/examples/basic_init/dom.html
    			lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
    			pageLength: 10,
    			language: {
    				'lengthMenu': 'Display _MENU_',
            buttons: {
                selectAll: "Select all",
                selectNone: "Select none"
            },
            "emptyTable": "No record found",
    			},
    			searchDelay: 500,
    			processing: true,
    			serverSide: true,
    			select:true,
            "ajax":"<?php echo base_url('/hrm/leave/index/datasourceleaverequest');?>",
    			dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			buttons: [
            {
              text: 'Delete Seleted',
              action: function ( e, dt, node, config ) {
                  deleteSelected( table);
                }
            },
            'selectAll',
            'selectNone',
    				'excelHtml5',
    				'pdfHtml5',
    			],
          columns: [
              {data: 'leave_request_user_id'},
              {data: 'hrm_leave_schemes_titles_title'},
              {data: 'leave_request_from'},
              {data: 'leave_request_to'},
              {data: 'leave_request_created_at'},
              {data: 'leave_request_desc'},
              {data: 'leave_request_status'},
          ],
                initComplete: function () {
                    this.api().columns().every(function () {
                        var column = this;

                        switch (column.data()) {
                            case 'Budget':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Balance':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Status':
                                var status = {
                                    "Approved": {'leave_request_status': 'Approved', 'class': 'kt-badge--success'},
                                    "Not Approved": {'leave_request_status': 'Not Approved', 'class': ' kt-badge--danger'},
                                    "Rejected": {'leave_request_status': 'Rejected', 'class': ' kt-badge--info'},
                                };
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="6"]').append('<option value="' + d + '">' + status[d].leave_request_status + '</option>');
                                });
                                break;
                        }
                    });
                },

          columnDefs: [
              {
                  targets: 0,
                  render: function(data, type, full, meta){
                      return '<a  href="<?php echo base_url('administration/employees/details/');?>' + full.user_id + '"> ' + full.firstname + ' ' + full.lastname + '</a> ';
                  }
              },

              {
                  targets: 6,
                  "width": "15%",
                  render: function (data, type, full, meta) {
                      var status = {
                          "Approved": {'leave_request_status': 'Approved', 'class': 'kt-badge--success'},
                          "Not Approved": {'leave_request_status': 'Not Approved', 'class': ' kt-badge--warning'},
                          "Rejected": {'leave_request_status': 'Rejected', 'class': ' kt-badge--danger'},
                      };
                      if (typeof status[data] === 'undefined') {
                          return data;
                      }
                      return '<a href="#budget-details" data-toggle="modal" data-backdrop="static" data-key="' + full.leave_request_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].leave_request_status + '</span></a> ' +
                          '<div class="dropdown dropdown-inline">\n' +
                          '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                          '                                <i class="flaticon-more"></i>\n' +
                          '                            </span>\n' +
                          '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                          '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:modifyRequest(' + full.leave_request_key + ');"><i class="la la-pencil kt-font-danger kt-font-bolder"></i> Edit</a>\n' +
                          '                                <a class="dropdown-item" data-key="' + full.leave_request_key + '" href="javascript:requestNotApproved(' + full.leave_request_key + ');"><i class="la la-toggle-off kt-font-warning"></i> Set Not Approved</a>\n' +
                          '                                <a class="dropdown-item" data-key="' + full.leave_request_key + '" href="javascript:requestApprove(' + full.leave_request_key + ');"><i class="la la-toggle-off kt-font-success"></i> Approve</a>\n' +
                          '                                <div class="dropdown-divider"></div>' +
                          '                                <a class="dropdown-item" href="javascript:setRejected(' + full.leave_request_key + ');"><i class="la la-balance-scale kt-font-danger"></i> Set Rejected</a>\n' +
                          '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:deleteItemRequest(' + full.leave_request_key + ');"><i class="la la-trash kt-font-danger kt-font-bolder"></i> Delete</a>\n' +
                          '                                <a class="dropdown-item" data-backdrop="false" class="kt-font-danger kt-font-bolder" href="javascript:detailsRequest(' + full.leave_request_key + ');"><i class="la la-cog kt-font-dark"></i> Details</a>\n' +
                          '                            </div>\n' +
                          '                        </div>';
                  },
              }

          ],
    		});
    	};

    	return {
    		//main function to initiate the module
    		init: function() {
    			initTable();
    		},

    	};

    }();

  jQuery(document).ready(function() {
    $('select').css('width','100%');
    $('select').select2({placeholder: 'select option'});
    let height = $(window).innerHeight()  - 250;
    $('.lm_max_height').css({ height: height });
    $(window).resize(function(){
      $('.lm_max_height').css({ height: height });
    });
  	LMDatatableGroups.init();
    $('form#newLeaveRequestForm').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
          url: '<?php echo base_url('hrm/leave/index/newleaveRequest/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newLeaveRequestForm",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Submitting your Request ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                notifySuccess(obj.message);
                var table = $.fn.dataTable.tables( { api: true } );
                table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newLeaveRequestForm');
                $('div#newLeaveRequest').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newLeaveRequestForm');
              }
      });
    })

  });

  jQuery(document).ready(function() {
      $('select').css('width','100%');
      $('select').select2({placeholder: 'select option'});
      let height = $(window).innerHeight()  - 250;
      $('.lm_max_height').css({ height: height });
      $(window).resize(function(){
          $('.lm_max_height').css({ height: height });
      });
      //LMDatatableGroups.init();
      $('form#newLeaveSchemeForm').submit( function(event){
          let form = $( this );
          event.preventDefault();
          let formdata = form.serialize();
          $.ajax({
              url: '<?php echo base_url('hrm/leave/index/newleaveScheme/')?>',
              type: 'get',
              data: formdata,
              beforeSend: function(){
                  KTApp.block("form#newLeaveSchemeForm",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Creating new Scheme ...."
                  });
              },
              success: function(r){
                  var obj = JSON.parse(r);
                  if(obj.status == 'ok'){
                      notifySuccess(obj.message);
                      var table = $.fn.dataTable.tables( { api: true } );
                      table.clear().draw();
                  }else{
                      Swal.fire('',obj.message,'warning');
                  }
                  KTApp.unblock('form#newLeaveSchemeForm');
                  $('div#newLeaveScheme').modal('hide');
              },
              error: function(){
                  KTApp.unblock('form#newLeaveSchemeForm');
              }
          });
      })

  });

  function deleteItemRequest(leave){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('hrm/leave/index/deleteRequest/leave')?>/'+leave,
            type: 'get',
            beforeSend: function(){
                KTApp.block("#lm_table_request",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Deleting Request ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                       notifySuccess(obj.message);
                       KTApp.unblock('#lm_table_request');
                       var table = $.fn.dataTable.tables( { api: true } );
                       table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                 },
              error: function(xhr){
                  KTApp.unblock('#lm_table_request');
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }

  function detailsRequest(leave){
    let $modal =  $('div#leaveDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url('/hrm/leave/index/detailsLeaveRequest/');?>' + leave,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading leave request details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function modifyRequest(leave){
    let $modal =  $('div#leaveDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
        url: '<?php echo base_url('hrm/leave/index/modifyRequest/');?>' + leave,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading leave request details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function requestApprove(leave){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to change REQUEST STATUS!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('hrm/leave/index/requestApprove/');?>" + leave,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_request",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Approving Request ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_request');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_request');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function requestNotApproved(leave){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to change REQUEST STATUS!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('hrm/leave/index/requestNotApprove/');?>" + leave,
                  type: "get",
                  beforeSend: function(){
                      KTApp.block("#lm_table_request",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Approving Request ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_request');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_request');
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function setRejected(leave){
      Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, reject it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: '<?php echo base_url('hrm/leave/index/setReject/reject')?>/'+leave,
                  type: 'get',
                  beforeSend: function(){
                      KTApp.block("#lm_table_request",{
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Rejecting Request ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblock('#lm_table_request');
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.clear().draw();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblock('#lm_table_request');
                      Swal.fire('',xhr.statusText,'warning');
                  }
              });
          }
      })
  }


  function deleteSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["group_key"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to DELETE " + table.rows('.selected').data().length + " groups",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Delete them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('/customers/category/deleteselected/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

</script>