<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">

    function deleteEmployee(employee) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('/hrm/employees/index/delete')?>/' + employee,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting employee ..."
                        });
                    },
                    success: function (response) {
                        KTApp.unblockPage();
                        if (response.status == true) {
                            notifySuccess(response.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.clear().draw();
                        } else {
                            Swal.fire("Server response", response.message, "warning");
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire("Server response " + xhr.statusText, "Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>", "warning");
                    }
                });
            }
        })
    }

</script>