<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-todo__bottom" id="kt_page_portlet">
    <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
    <div class="kt-portlet__body">
        <div class="form-group row">
            <input type="text" hidden class="form-control" name="doc_user_key" value="<?php echo $employee->user_key;?>" placeholder="Enter description">
            <div class="col-lg-5">
                <label>Level:</label>
                <select class="form-control kt-select2" id="kt_select2_3_modal" name="doc_title">
                    <option disabled>Select Education Level</option>
                    <?php if(!empty($education)):
                        foreach($education as $educ):?>
                            <option value="<?php echo $educ['level_name'];?>" selected><?php echo $educ['level_name'];?></option>
                        <?php endforeach; endif;?>
                </select>
            </div>
            <div class="col-lg-7">
                <label>Description:</label>
                <input type="text" class="form-control" name="doc_desc" placeholder="Enter description">
            </div>
        </div>

        <div class="form-group row">
            <div class="col-lg-12">
                <label class="">Upload File:</label>
                <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                    <div class="m-dropzone__msg dz-message needsclick">
                        <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                        <span class="m-dropzone__msg-desc">Upload 1 files</span>
                    </div>
                </div>
            </div>
            <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
        </div>
        <div class="row">
            <div class="col-lg-6">
            </div>
            <div class="col-lg-6 kt-align-right">
                <button type="submit" name="submit" class="btn btn-danger">Save</button>
            </div>
        </div>
    </div>

</form>
    <!--Begin::Section-->
    <div class="row">
        <?php if(!empty($document)):
        foreach($document as $hero):?>
        <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $hero['doc_key'];?>'>

            <!--Begin::Portlet-->
            <div class="kt-portlet">
                <div class="kt-portlet__head kt-portlet__head--noborder">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                        </h3>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                            <i class="flaticon-more-1"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <ul class="kt-nav">
                                <li class="kt-nav__item">
                                    <a href="javascript:(0);" onclick="deleteDocument('<?php echo $hero['doc_key'];?>')" class="kt-nav__link">
                                        <i class="kt-nav__link-icon flaticon2-trash"></i>
                                        <span class="kt-nav__link-text">Delete</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="kt-portlet__body">
                    <!--begin::Widget -->
                    <div class="kt-widget__files">
                        <div class="kt-widget__media">
                            <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($hero['doc_image']);?>.svg" alt="">
                        </div>

                        <a target="_blank" href="<?php echo uploadFilePath('doc_image/').$hero['doc_image'];?>"  data-url="<?php echo uploadFilePath('doc_image/').$hero['doc_image'];?>" class="kt-widget__desc">
                            <?php echo $hero['doc_title'];?>
                        </a>
                    </div>

                    <!--end::Widget -->
                </div>
            </div>

            <!--End::Portlet-->
        </div>
        <?php endforeach; endif;?>

    </div>
    <!--End::Section-->
</div>

<div class="modal fade" id="previewPdf" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content bg-dark">
            <div class="modal-body" id="modalview" style="height:100%; min-height">
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn btn-danger" name="button"><i class="flaticon-cancel"></i></button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $('form#docsForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/employees/index/newDocument/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Uploading Employee document ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('hrm/employees/index/loadInformationDocument/' . $employee->user_key);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('hrm/employees/index/uploadempdocs');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 10,
        maxFilesize: 3, // MB
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var expsenseDocs = new Dropzone("div#crop-image",options);

    function deleteDocument(docKey){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/employee/index/deleteDocument/document')?>/'+docKey,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("div#loadDetails",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting document ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            $('div#' + docKey).hide();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('div#loadDetails');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }
</script>
