<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyDepartmentForm" class="kt-form" action="#" method="get" onsubmit="return false">
    <div class="form-group row">
        <div class="col-12">
            <input type="text" name="department_name" value="<?php echo $department->department_name;?>" class="form-control" placeholder="Department name">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <textarea class="form-control" name="department_details" rows="4" cols="80"
                      placeholder="Department details"><?php echo $department->department_details;?></textarea>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-12">
            <select class="form-control kt-select2" id="kt_select2_3_modal" name="department_hod">
                <option disabled>Select Employee(s)</option>
                <?php if(!empty($employees)):
                    foreach($employees as $emp):?>
                        <option value="<?php echo $emp['user_id'];?>" selected><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                    <?php endforeach; endif;?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-8 col-form-label"></label>
        <div class="col-4">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b></button>
        </div>
    </div>
</form>
<script type="text/javascript">
    $('form#modifyDepartmentForm').submit(function (event) {
        let form = $(this);
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/employees/departments/update/' . $department->department_key);?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Department ..."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $('.kt-datatable').KTDatatable('reload');
                    $('div#departmentDetails').modal('hide');
                    Swal.fire('', obj.message, 'success');
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.ajax.reload();
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock(form);
            },
            error: function () {
                $('div#departmentDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>