<script type="text/javascript">
    var LMDatatableCharges = function() {
        var initTable = function() {
            // begin first table
            var table = $('#lm_table_workday').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                // read more: https://datatables.net/examples/basic_init/dom.html
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select:true,
                "ajax":"<?php echo base_url('hrm/workday/index/datasourceWorkdaySchemes');?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function ( e, dt, node, config ) {
                            deleteSelected( table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    'excelHtml5',
                    'pdfHtml5',
                ],
                columns: [
                    {data: 'hrm_workdays_scheme_title'},
                    {data: 'hrm_workdays_scheme_created_by'},
                    {data: 'action'},
                ],

                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta){
                            return ucfirst(data);
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta){
                            return '<a  href="<?php echo base_url('administration/employees/details/');?>' + full.user_id + '"> ' + full.firstname + ' ' + full.lastname + '</a> ';
                        }
                    },
                    {
                        targets: 2,
                        render: function(data, type, full, meta){
                            return '<a data-backdrop="false" href="javascript:details(' + full.hrm_workdays_scheme_key + ');"><i class="flaticon-eye text-success"></i></a> |' +
                                ' <a data-backdrop="false" href="javascript:modify(' + full.hrm_workdays_scheme_key + ');"><i class="flaticon-edit text-warning"></i></a> |' +
                                ' <a data-backdrop="false" href="javascript:deleteItem(' + full.hrm_workdays_scheme_key + ');"><i class="flaticon-delete text-danger"></i></a>';
                        }
                    }
                ],
            });
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        $('select').css('width','100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight()  - 250;
        $('.lm_max_height').css({ height: height });
        $(window).resize(function(){
            $('.lm_max_height').css({ height: height });
        });
        LMDatatableCharges.init();
        $('form#newWorkdayForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('hrm/workday/index/createWorkday/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function(){
                    KTApp.block("form#newWorkdayForm",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Workday ...."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock('form#newWorkdayForm');
                    $('div#newWorkday').modal('hide');
                },
                error: function(){
                    KTApp.unblock('form#newWorkdayForm');
                }
            });
        })
    });

    jQuery(document).ready(function() {
        $('select').css('width','100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight()  - 250;
        $('.lm_max_height').css({ height: height });
        $(window).resize(function(){
            $('.lm_max_height').css({ height: height });
        });
       // LMDatatableCharges.init();
        $('form#newWorkdaySchemeForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('hrm/workday/index/createWorkdaySchemeDay/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function(){
                    KTApp.block("form#newWorkdaySchemeForm",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new workday Scheme ...."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock('form#newWorkdaySchemeForm');
                    $('div#newWorkdayScheme').modal('hide');
                },
                error: function(){
                    KTApp.unblock('form#newWorkdaySchemeForm');
                }
            });
        })
    });

    function deleteItem(workday){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/workday/index/delete/workday')?>/'+workday,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_workday",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_table_workday');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_workday');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function details(workday){
        let $modal =  $('div#workdayDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/workday/index/detailsWorkday/');?>' + workday,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading workday details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function modify(workday){
        let $modal =  $('div#workdayDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/workday/index/modifyWorkday/');?>' + workday,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading Workday details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function deleteSelected(table){
        if(table.rows('.selected').data().length<1)
            return;
        var data= [];
        $.each(table.rows('.selected').data(), function() {
            data.push(this["charge_key"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " charges",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url($auth_role.'/charges/index/deleteselected/');?>',
                    type: 'get',
                    data: {'data':data},
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Please wait ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblockPage();
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function addDetails(workday){
        let $modal =  $('div#kt_datepicker_modal');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/workday/index/detailsWorkdayAdd/');?>' + workday,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading workday details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function deleteDay(workday){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/workday/index/deleteScheme/workday')?>/'+workday,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_day",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Scheme ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_table_day');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_day');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function editDay(workday){
        let $modal =  $('div#workdayDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/workday/index/modifyWorkdayScheme/');?>' + workday,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading workday scheme details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

</script>