<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });
    var Datatable = function() {
        let initTable = function() {
            let table = $('table#lm_table');

            // begin first table
            table.DataTable({
                responsive: true,
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('/hrm/employees/index/datasource/'.$when);?>',
                columns: [
                    {data: 'name'},
                    {data: 'gender'},
                    {data: 'joined'},
                    {data: 'phonenumber'},
                    {data: 'department_name'},
                    {data: 'user_status'},
                ],
                initComplete: function () {
                    this.api().columns().every(function () {
                        var column = this;

                        switch (column.title()) {
                            case 'Budget':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Spent':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Balance':
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Status':
                                var status = {
                                    "Active": {'user_status': 'Active', 'class': 'kt-badge--success'},
                                    "Pending": {'user_status': 'Approved', 'class': ' kt-badge--warning'},
                                    "Rejected": {'user_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "Pending Reject": {'user_status': 'Rejected', 'class': ' kt-badge--info'},
                                };
                                column.data().unique().sort().each(function (d, j) {
                                    $('.m-input[data-col-index="6"]').append('<option value="' + d + '">' + status[d].status + '</option>');
                                });
                                break;
                        }
                    });
                },

                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?php echo base_url('/hrm/employees/index/details/');?>' + full.user_key + '">'+full.firstname+' '+full.lastname+'</a>';
                        },
                    },
                    {
                        targets: 5,
                        "width": "13%",
                        render: function (data, type, full, meta) {
                            var status = {
                                "Active": {'user_status': 'Active', 'class': 'kt-badge--success'},
                                "Pending": {'user_status': 'Pending', 'class': ' kt-badge--warning'},
                                "Rejected": {'user_status': 'Rejected', 'class': ' kt-badge--danger'},
                                "Inactive": {'user_status': 'Inactive', 'class': ' kt-badge--info'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="<?php echo base_url('/hrm/employees/index/details/');?>' + full.user_key + '" data-backdrop="static" data-key="' + full.user_id + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].user_status + '</span></a> ' +
                                '<div class="dropdown dropdown-inline">\n' +
                                '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                '                                <i class="flaticon-more"></i>\n' +
                                '                            </span>\n' +
                                '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                '                                <a class="dropdown-item" data-backdrop="static" data-toggle="modal" data-key="' + full.user_id + '" href="#kt_chat_noely"><i class="la la-plus kt-font-success"></i> Send Email</a>\n' +
                                '                                <a class="dropdown-item" href="javascript:setInactive(' + full.user_id + ');"><i class="la la-minus kt-font-warning"></i> Set Inactive</a>\n' +
                                '                                <a class="dropdown-item" href="javascript:setActive(' + full.user_id + ');"><i class="la la-minus kt-font-success"></i> Set Active</a>\n' +
                                '                                <div class="dropdown-divider"></div>' +
                                '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:deleteEmployee(' + full.user_id + ');"><i class="la la-trash kt-font-danger kt-font-bolder"></i> Delete</a>\n' +
                                '                                <a class="dropdown-item" data-key="' + full.user_id + '" href="<?php echo base_url('hrm/employees/index/details/');?>' + full.user_id + '"><i class="la la-cog kt-font-dark"></i> Details</a>\n' +
                                '                            </div>\n' +
                                '                        </div>';
                        },
                    }
                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {

            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });


    $( function(){
        $('#kt_chat_noely').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-content').html('Loading user data ...');
            KTApp.block("#kt_chat_noely .modal-content",{
                overlayColor:"#000000",
                type:"loader",
                state:"warning",
                message:"Loading user data ..."
            });
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-content').load('<?php echo base_url('crm/customers/index/CustomerEmail/');?>' + key );
            KTApp.unblock('#kt_chat_noely .modal-content');
        })
    })

    function setInactive(emp){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to change employee status!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, change it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('hrm/employees/index/setInactive/');?>" + emp,
                    type: "post",
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Please wait ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if(result.status == true){
                            Swal.fire('',result.message,'success');
                            let table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                            window.location.reload();
                        }else{
                            Swal.fire('',result.message,'warning');
                        }
                    },
                    error: function (xhr){
                        KTApp.unblockPage();
                        Swal.fire('',xhr.statusText,'warning');
                    }
                })
            }
        })
    }

    function setActive(emp){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to change employee status!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, change it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('hrm/employees/index/setActive/');?>" + emp,
                    type: "post",
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Please wait ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if(result.status == true){
                            Swal.fire('',result.message,'success');
                            let table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                            window.location.reload();
                        }else{
                            Swal.fire('',result.message,'warning');
                        }
                    },
                    error: function (xhr){
                        KTApp.unblockPage();
                        Swal.fire('',xhr.statusText,'warning');
                    }
                })
            }
        })
    }

    function deleteEmployee(employee) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('/hrm/employees/index/delete_employee')?>/' + employee,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting employee ..."
                        });
                    },
                    success: function (response) {
                        KTApp.unblockPage();
                        if (response.status == true) {
                            notifySuccess(response.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            Swal.fire("Server response", response.message, "warning");
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire("Server response " + xhr.statusText, "Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>", "warning");
                    }
                });
            }
        })
    }


</script>