<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-section">
    <?php if (!empty($groups = roles_groups())) {
        foreach ($groups as $key => $group) {
            if ($key > 0) {
                echo '<br/>';
            } ?>
            <div class="kt-section__info"><?php echo ucfirst(strtolower($group['role_group'])); ?>:</div>
            <div class="kt-section__content kt-section__content--solid">
                <div class="row " style="background:transparent;">
                    <?php if (!empty($roles)) {
                        $i = 1;
                        foreach ($roles as $key => $role) {
                            if (strtolower($role['role_group']) == strtolower($group['role_group'])) {
                                ?>
                                <div class="col-4">
                                    <div title="<?php echo $role['role_details']; ?>" class="row form-group "
                                         style="float:left; padding-right:10px; clear:both; border:1px solid; margin:0px 0px 5px 0px;">
                                        <label class="col-9 col-form-label"><?php echo $role['role_name']; ?></label>
                                        <div class="col-3">
                          <span class="kt-switch kt-switch--sm kt-switch--icon kt-switch kt-switch--outline kt-switch--icon kt-switch--<?php echo $role['role_class']; ?>">
                            <label>
                              <input type="checkbox"
                                     data-url="<?php echo base_url('hrm/employees/roles/employee/' . $employee->user_id . '/' . $employee->category_id . '/' . urlencode($role['role_action'])); ?>"
                                     class="user-role-check-box" <?php if (isMyRoleAction($employee->user_id, $employee->category_id, $role['role_action'])) echo 'checked="checked"'; ?>>
                              <span></span>
                            </label>
                          </span>
                                        </div>
                                    </div>
                                </div>
                                <?php $i++;
                            }
                        }
                    } ?>
                </div>
            </div>
        <?php }
    } ?>
</div>
<script type="text/javascript">
    $('.user-role-check-box').change(function (e) {

        let $input = $(this);
        e.preventDefault();

        let $url = $input.data('url');

        $.ajax({
            url: $url,
            type: 'get',
            beforeSend: function(){
                KTApp.blockPage({
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Please wait ..."
                });
            },
            success: function (result) {
                KTApp.unblockPage();
                if ($input.prop('checked')) {
                    if (result.status == true) {
                        notifySuccess(result.message);
                        $input.prop('checked', true);
                    } else {
                        notifyWarning(result.message);
                        $input.prop('checked', false);
                    }
                } else {
                    if (result.status == true) {
                        notifySuccess(result.message);
                        $input.prop('checked', false);
                    } else {
                        notifyWarning(result.message);
                        $input.prop('checked', true);
                    }
                }
            },
            error: function () {
                KTApp.unblockPage();
                result = false;
            }
        });
    });
</script>