<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-portlet kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
    <form id="medicalForm" onsubmit="return false;" class="kt-form kt-form--label-right">
        <div class="kt-portlet__body">
            <div class="form-group row">
                <input type="text" hidden class="form-control" name="medical_user_id" value="<?php echo $employee->user_key;?>" placeholder="Enter description">
                <div class="col-lg-4">
                    <label>Disease:</label>
                    <input type="text" class="form-control" name="medical_disease_name" placeholder="disease name">
                </div>
                <div class="col-lg-4">
                    <label>Doctor Name:</label>
                    <input type="text" class="form-control" name="medical_doctor_name" placeholder="doctor name">
                </div>
                <div class="col-lg-4">
                    <label>Doctor Phone:</label>
                    <input type="text" class="form-control" name="medical_doctor_phone" placeholder="phone number">
                </div>
            </div>

            <div class="form-group row">
                <div class="col-lg-4">
                    <label>Height:</label>
                    <input type="text" class="form-control" name="medical_height" placeholder="height">
                </div>
                <div class="col-lg-4">
                    <label>Weight:</label>
                    <input type="text" class="form-control" name="medical_weight" placeholder="Enter weight">
                </div>
                <div class="col-lg-4">
                    <label>Level:</label>
                    <select class="form-control kt-select2" id="kt_select2_3_modal" name="medical_blood_group">
                        <option>Select Blood Group</option>
                        <option value="A">Group A</option>
                        <option value="B">Group B</option>
                        <option value="O">Group O</option>
                        <option value="AB">Group AB</option>
                        <option value="AB+">Group AB+</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="kt-portlet__foot">
            <div class="kt-form__actions">
                <div class="row">
                    <div class="col-lg-6">
                    </div>
                    <div class="col-lg-6 kt-align-right">
                        <button type="submit" name="submit" class="btn btn-success">Save</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div class="kt-portlet__body">
        <!-- <div class="kt-datatable" id="applicationTable"></div> -->
        <table class="table table-bordered table-hover table-checkable" id="lm_table_medical">
            <thead>
            <tr>
                <th>Disease</th>
                <th>Height</th>
                <th>Weight</th>
                <th>Blood Group</th>
                <th>Doctor Name</th>
                <th>Doctor Phone</th>
                <th>Action</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_medical');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url('hrm/employees/index/datasourceMedical/'.$employee->user_key);?>',
                columns: [
                    {data: 'medical_disease_name'},
                    {data: 'medical_height'},
                    {data: 'medical_weight'},
                    {data: 'medical_blood_group'},
                    {data: 'medical_doctor_name'},
                    {data: 'medical_doctor_phone'},
                    {data: 'action'},
                ],
                initComplete: function() {
                    this.api().columns().every(function() {
                        var column = this;

                        switch (column.title()) {
                            case 'Status':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Region':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'District':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 6,
                        render: function(data, type, full, meta){
                            return ' <a href="javascript:deleteItem(' + full.medical_key + ');"><i class="flaticon-delete text-danger"></i></a>';
                        }
                    }

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    $('form#medicalForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/employees/index/newMedical/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Employee medical information ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('hrm/employees/index/loadInformationMedical/' . $employee->user_key);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    function deleteItem(educ){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/employees/index/deleteMedical/medical')?>/'+educ,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_medical",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Medical data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_medical');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_medical');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }
</script>
