<script src="//geodata.solutions/includes/countrystatecity.js"></script>
<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="employeesForm" onsubmit="return false;" class="kt-form">
    <div class="kt-section kt-section--first">
        <div class="kt-section__body">
            <div class="form-group row">
                <label class="col-3 col-form-label">First Name</label>
                <div class="col-9">
                    <input name="firstname" class="form-control" type="text"
                           value="<?php echo $employee->firstname; ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Middle Name</label>
                <div class="col-9">
                    <input class="form-control" type="text" value="<?php echo $employee->middlename; ?>"
                           name="middlename">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Last Name</label>
                <div class="col-9">
                    <input class="form-control" type="text" value="<?php echo $employee->lastname; ?>" name="lastname">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Gender</label>
                <div class="col-9">
                    <div class="kt-radio-inline">
                        <label class="kt-radio">
                            <input type="radio"
                                   value="Male" <?php if (strtolower($employee->gender) == 'male') echo 'checked="checked"'; ?>
                                   name="gender"> Male
                            <span></span>
                        </label>
                        <label class="kt-radio">
                            <input type="radio" <?php if (strtolower($employee->gender) == 'female') echo 'checked="checked"'; ?>
                                   value="Female" name="gender"> Female
                            <span></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Date of Birth</label>
                <div class="col-9">
                    <input class="form-control" type="date" value="<?php echo $employee->dob; ?>" name="dob">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Contact Phone</label>
                <div class="col-9">
                    <div class="input-group">
                        <div class="input-group-prepend"><span class="input-group-text"><i
                                        class="la la-phone"></i></span></div>
                        <input type="text" class="form-control" placeholder="Phone" aria-describedby="basic-addon1"
                               value="<?php echo $employee->office_phone; ?>" name="office_phone">
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Country</label>
                <div class="col-9">
                    <select name="country" class="countries order-alpha form-control " id="countryId">
                        <option value="">Select Country</option>
                        <?php if (!empty($employee->country)) { ?>
                            <option selected
                                    value="<?php echo $employee->country; ?>"><?php echo $employee->country; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">State</label>
                <div class="col-9">
                    <select name="state" class="states order-alpha form-control " id="stateId">
                        <option value="">Select State</option>
                        <?php if (!empty($employee->state)) { ?>
                            <option selected
                                    value="<?php echo $employee->state; ?>"><?php echo $employee->state; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">City</label>
                <div class="col-9">
                    <select name="city" class="cities order-alpha form-control " id="cityId">
                        <option value="">Select City</option>
                        <?php if (!empty($employee->city)) { ?>
                            <option selected
                                    value="<?php echo $employee->city; ?>"><?php echo $employee->city; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Home Address</label>
                <div class="col-9">
                    <input type="text" name="home_address" class="form-control"
                           value="<?php echo $employee->home_address; ?>" placeholder="Home address">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-3 col-form-label">Residential Address</label>
                <div class="col-9">
                    <input type="text" name="residential_address" class="form-control"
                           value="<?php echo $employee->residential_address; ?>" placeholder="residential address">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-9 col-form-label"></label>
                <div class="col-3">
                    <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript">
    $('select#countryId').select2({placeholder: 'Select country'});
    $('select#stateId').select2({placeholder: 'Select state'});
    $('select#cityId').select2({placeholder: 'Select city'});
    $('form#employeesForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('hrm/employees/index/loadInformationPrimaryAction/' . $employee->user_id);?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Updating Primary information ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('hrm/employees/index/loadInformationPrimary/' . $employee->user_id);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })
</script>