<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarDepartment('departments'); ?>

    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <div class="row">
            <div class="col-lg-12">
                <!--begin::Portlet-->
                <div class="kt-portlet kt-portlet--last kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
                    <div class="kt-portlet__head kt-portlet__head--md" style="">
                        <div class="kt-portlet__head-label">
                            <h3 class="kt-portlet__head-title">Employee(s) in <?php echo $department->department_name;?></h3>
                        </div>
                        <div class="kt-portlet__head-toolbar">
                            <?php if (has_role('departments_register')) { ?>
                                <a data-toggle="modal" data-backdrop="false" class="btn btn-sm btn-info" href="#newDepartment">New Department</a>
                            <?php } ?>
                        </div>
                    </div>

                    <div class="kt-portlet__body">
                        <table class="table table-bordered" id="lm_userdept">
                            <thead>
                            <tr>
                                <th>Firstname</th>
                                <th>Middlename</th>
                                <th>Lastname</th>
                                <th>Gender</th>
                                <th>Mobile Phone</th>
                                <th>City</th>
                                <th>State</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!--end::Portlet-->
            </div>
        </div>


    </div>
    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php';?>

<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>

<div class="modal fade" id="departmentDetails" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Department Details</h5>
                <a id="print" href="javascript:(0);" class=" modal-title text-white"
                   style="right:60px; position:absolute;">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                         height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M16,17 L16,21 C16,21.5522847 15.5522847,22 15,22 L9,22 C8.44771525,22 8,21.5522847 8,21 L8,17 L5,17 C3.8954305,17 3,16.1045695 3,15 L3,8 C3,6.8954305 3.8954305,6 5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,15 C21,16.1045695 20.1045695,17 19,17 L16,17 Z M17.5,11 C18.3284271,11 19,10.3284271 19,9.5 C19,8.67157288 18.3284271,8 17.5,8 C16.6715729,8 16,8.67157288 16,9.5 C16,10.3284271 16.6715729,11 17.5,11 Z M10,14 L10,20 L14,20 L14,14 L10,14 Z"
                                  id="Combined-Shape" fill="#000000"/>
                            <rect id="Combined-Shape-Copy" fill="#000000" opacity="0.3" x="8" y="2" width="8" height="2"
                                  rx="1"/>
                        </g>
                    </svg>
                </a>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal"
                   class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                         height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z"
                                  id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10"
                                  rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y'); ?> Lockminds BMS | Department details</small>
            </div>
        </div>
    </div>
</div>
</div>

<div class="modal fade" id="newDepartment" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">New Department</h5>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal"
                   class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                         height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z"
                                  id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10"
                                  rx="1"/>
                        </g>
                    </svg>
                </a>
            </div>
            <div class="modal-body text-back">
                <form id="newDepartmentForm" class="kt-form" action="#" method="get" onsubmit="return false">
                    <div class="form-group row">
                        <div class="col-12">
                            <input type="text" name="department_name" class="form-control"
                                   placeholder="Department name">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <textarea class="form-control" name="department_details" rows="5" cols="80"
                                      placeholder="Department details"></textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12">
                            <select class="form-control kt-select2" id="kt_select2_3_modal" name="department_hod" multiple="multiple">
                                <option disabled>Select Employee(s)</option>
                                <?php if(!empty($employees)):
                                    foreach($employees as $emp):?>
                                        <option value="<?php echo $emp['user_id'];?>" selected><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                                    <?php endforeach; endif;?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-9 col-form-label"></label>
                        <div class="col-3">
                            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Register</b>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y'); ?> Lockminds BMS | Register new Department</small>
            </div>
        </div>
    </div>
</div>
</div>

<script type="text/javascript">
    var LMDatatableCharges = function() {
        var initTable = function() {
            // begin first table
            var table = $('#lm_userdept').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                // read more: https://datatables.net/examples/basic_init/dom.html
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select:true,
                "ajax":"<?php echo base_url('hrm/employees/departments/datasourceuser/'.$department->department_key);?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function ( e, dt, node, config ) {
                            deleteSelected( table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    'excelHtml5',
                    'pdfHtml5',
                ],
                columns: [
                    {data: 'firstname'},
                    {data: 'middlename'},
                    {data: 'lastname'},
                    {data: 'gender'},
                    {data: 'mobilephone'},
                    {data: 'city'},
                    {data: 'state'},
                ],

                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta){
                            return data;
                        }
                    },
                    {
                        targets: 3,
                        render: function(data, type, full, meta){
                            return data;
                        }
                    }

                ],
            });
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        $('select').css('width','100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight()  - 250;
        $('.lm_max_height').css({ height: height });
        $(window).resize(function(){
            $('.lm_max_height').css({ height: height });
        });
        LMDatatableCharges.init();
        $('form#newDepartmentForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('/hrm/employees/departments/newdepartment/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function(){
                    KTApp.block("form#newDepartmentForm",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Department ...."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock('form#newDepartmentForm');
                    $('div#newDepartment').modal('hide');
                },
                error: function(){
                    KTApp.unblock('form#newDepartmentForm');
                }
            });
        })
    });

    function deleteItem(department){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('hrm/employees/departments/delete/department')?>/'+ department,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_departments",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Data ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblock('#lm_departments');
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_departments');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

    function details(department){
        let $modal =  $('div#departmentDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('hrm/employees/departments/details/');?>' + department,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading department details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function modify(department){
        let $modal =  $('div#departmentDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('/hrm/employees/departments/modify/');?>' + department,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading department details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    document.querySelector("#print").addEventListener("click", function () {
        printJS({
            printable: 'printArea',
            type: 'html',
            header: '<?php echo config_item('application_name');?> - Department Details',
            css: '<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css',
            'style': 'link{text-decoration:none;}'
        });
    });

</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>