<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyFreightTaskForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <label>Client Name</label>
                <input type="text" readonly name="freight_task_client_name" value="<?php echo $taskdetails->freight_task_client_name;?>" placeholder="Project Title " class="form-control"/>
            </div>
            <div class="col-6">
                <label>File No:</label>
                <input type="text" readonly name="freight_task_freight_key" value="<?php echo $taskdetails->freight_task_freight_key;?>" placeholder="Project Client" class="form-control"/>
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Responsible</label>
                <select class="form-control" name="freight_task_employee_key">
                    <option disabled>Select Employee</option>
                    <?php if(!empty($employees)):
                        foreach($employees as $emp):?>
                            <option <?php if ($emp['user_id'] == $taskdetails->freight_task_employee_key) echo 'selected'; ?>
                                value="<?php echo $emp['user_id'];?>"><?php echo $emp['firstname'];?> <?php echo $emp['lastname'];?></option>
                        <?php endforeach; endif;?>
                </select>
            </div>
            <div class="col-6">
                <label>Payment Status</label>
                <select class="form-control" name="freight_task_payment">
                    <option disabled>Select Status</option>
                    <option <?php if($taskdetails->freight_task_payment == 'UNPAID') echo 'selected';?>>UNPAID</option>
                    <option <?php if($taskdetails->freight_task_payment == 'REQUESTED') echo 'selected';?>>REQUESTED</option>
                    <option <?php if($taskdetails->freight_task_payment == 'PAID') echo 'selected';?>>PAID</option>
                </select>
            </div>
        </div>

        <div class="row form-group">
            <div class="col-6">
                <label>Task Start</label>
                <input type="text" name="freight_task_start" value="<?php echo $taskdetails->freight_task_start;?>" placeholder="Task Start Date " class="form-control"/>
            </div>
            <div class="col-6">
                <label>Task End</label>
                <input type="text" name="freight_task_deadline" value="<?php echo $taskdetails->freight_task_deadline;?>" placeholder="Task End Date" class="form-control" />
            </div>
        </div>

        <div class="form-group m-form__group row">
            <label >Task Description</label>
            <div class="col-md-12">
                <textarea data-provide="markdown" value="<?php echo $taskdetails->freight_task_desc;?>" class="form-control" name="freight_task_desc"><?php echo $taskdetails->freight_task_desc;?></textarea>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit</button>
    </div>
</form>

<script type="text/javascript">
    $('form#modifyFreightTaskForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('freight/index/modifyFreightTask/'.$taskdetails->freight_task_key);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating Task ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#freightTaskDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                    table.ajax.reload();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#freightTaskDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>