<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('home');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Freight Forwarding</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Freight Stages</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>


        <!--begin:: Widgets/Quick Stats-->
        <?php //include __DIR__.'/top_summary.php';?>
        <!--end:: Widgets/Quick Stats-->
        <?php
        $freight = $this->freightsModel->find_by(['fr_key'=>$freight_key]);
        ?>

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        FREIGHT HISTORY (FREIGHT REF : <?= $freight['fr_key']; ?>)<?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3>
                    <?php
                    if($freight['fr_file_status'] == 'Active'){

                    $approved = $this->stagesModel->getApprovedFreight($freight_key);
                    if(!empty($approved))
                    {
                        echo "<b style='margin-left: 5px; color: brown'>This freight is already approved, no further operations can be done. </b>";
                    }
                    else{
                        ?>
                        <a href="#freight-history" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Add History</a>
                        <a href="#approve-freight-delivery" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Approve Freight Delivery</a>
                    <?php }}else{
                        echo "<h3 style='color: red; margin-left: 15px'><i class='fa fa-folder'></i> File Closed </h3>";
                     } ?>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#freights-list" role="tab" aria-selected="false">
                                <?php
                                $approved = $this->stagesModel->find_by(['fr_key'=>$freight_key, 'fr_stage_status'=>'Approved']);
                                if(!empty($approved))
                                {
                                    echo "Final Destination :";
                                }
                                else
                                {
                                    echo "Current Location";
                                }
                                ?>
                                <strong style="color: green; margin-left: 4px;">
                                    <?php
                                        $location = $this->stagesModel->getFreightLocation($freight_key);
                                        if(!empty($location))
                                        {
                                            foreach ($location as $loc_name)
                                            {
                                                echo strtoupper($loc_name['fr_stage_location']);
                                            }
                                        }
                                        else
                                        {
                                            echo "No freight to show";
                                        }
                                    ?>
                                </strong>
                            </a>
                        </li>
                        <!--<li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#freights-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>-->
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="freights-list">
                        <table class="table " id="freights-stages-table">
                            <thead>
                            <tr>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Location</th>
                                <th>Description</th>
                                <th>Status</th>
                                <th>Action</th>

                            </tr>
                            </thead>
                        </table>
                    </div>
                    <!--<div class="tab-pane" id="freights-list-bin">
                        <table id="freights-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Importer</th>
                                <th>Country of Destination</th>
                                <th>Date</th>
                                <th>Invoice Number</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>-->
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Content -->
</div>

<!-- Begin: Add freight history Modal -->
<div class="modal fade" id="freight-history" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'freight-history-form');
        echo form_open('', $attr );?>
        <?php
            if(has_role('freight_create_stages')){
        ?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add freight history</h3>
            </div>
            <div class="modal-body">
                <div class="kt-portlet__body">
                    <input type="hidden" name="fr_key" value="<?= $freight_key?>">
                    <div class="form-group">
                        <label>Enter Date</label>
                        <input type="date" name="fr_stage_date" id="datePickerId" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>
                    <div class="form-group">
                        <label>Enter Time</label>
                        <input type="time" name="fr_stage_time" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>
                    <div class="form-group">
                        <label>Enter Location</label>
                        <input type="text" name="fr_stage_location" class="form-control kt-select2" id="kt_select2_3_modal" placeholder="Enter Freight Location" required>
                    </div>
                    <div class="form-group">
                        <label>Enter Description (<i>Optional</i> )</label>
                        <textarea name="fr_stage_desc" class="form-control kt-select2" id="kt_select2_3_modal" placeholder="Freight Description"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php } else{?>
        <div class="modal-content">
            <?= FreightAccessControl(); ?>
        </div>
        <?php }?>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add freight history Modal -->

<!-- Begin: Approve freight delivery Modal -->
<div class="modal fade" id="approve-freight-delivery" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'freight-delivery-form');
        echo form_open('', $attr );?>
        <?php
        if(has_role('freight_create_stages')){
        ?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Approve freight delivery</h3>
            </div>
            <div class="row">
                <div class="col">
                    <div class="alert alert-light alert-elevate fade show" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-danger"></i></div>
                        <div class="alert-text">
                            <code><b>Warning :</b> <br> This is the final stage of this freight history. Once approved this stage, the entire history on this freight will no longer created or updated</code>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-body">
                <div class="kt-portlet__body">
                    <input type="hidden" name="fr_key" value="<?= $freight_key?>">
                        <div class="form-group">
                            <label>Enter Delivery Date</label>
                            <input type="date" name="fr_stage_date" id="datePickerId2" class="form-control kt-select2" id="kt_select2_3_modal" required>
                        </div>
                        <div class="form-group">
                            <label>Enter Delivery Time</label>
                            <input type="time" name="fr_stage_time" class="form-control kt-select2" id="kt_select2_3_modal" required>
                        </div>
                        <div class="form-group">
                            <label>Delivery Place (Final Destination)</label>
                            <input type="text" name="fr_stage_location" class="form-control kt-select2" id="kt_select2_3_modal" placeholder="Enter Freight Destination" required>
                        </div>
                        <div class="form-group">
                            <label>Enter Description (<i>Optional</i> )</label>
                            <textarea name="fr_stage_desc" class="form-control kt-select2" id="kt_select2_3_modal" placeholder="Freight Description"></textarea>
                        </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php } else{?>
            <div class="modal-content">
                <?= FreightAccessControl(); ?>
            </div>
        <?php }?>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add freight history Modal -->

<!-- Begin: Modify freight history Modal -->
<div class="modal fade" id="modify-freight-history" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-freight-history-form');
        echo form_open('', $attr );?>
        <?php
        if(has_role('freight_update_stages')){
        ?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify freight history</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php } else{?>
            <div class="modal-content">
                <?= FreightAccessControl(); ?>
            </div>
        <?php }?>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Modify freight history Modal -->
<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php
include __DIR__.'/scripts.php';
//include __DIR__.'/common.php';
?>

<script type="text/javascript">
    datePickerId.max = new Date().toISOString().split("T")[0];
    datePickerId2.max = new Date().toISOString().split("T")[0];
$(function () {
    $("#freight-history").on('show.bs.modal', function (event) {
        $("form#freight-history-form").resetForm();
    })
    $("#approve-freight-delivery").on('show.bs.modal', function (event) {
        $("form#freight-delivery-form").resetForm();
    })

    $("form#freight-history-form").submit( function(event){
        const  form = $(this);
        event.preventDefault();
        let formData = form.serialize();
        $.ajax({
            url: "<?php echo base_url('freight/index/add_freight_history');?>",
            data: formData,
            type: "post",
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Adding freight history, Please wait ..."
                });
            },
            success: function(result){
                KTApp.unblock(form);
                window.location.reload();
                if( result.status == true){
                    $("form#freight-history-form").resetForm();
                    $("#freight-history").modal("hide");
                    notifySuccess(result.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.ajax.reload();

                }else{
                    swal.fire("","An error occurred! "+ result.message,"warning");
                }
            },
            error: function(xhr){
                KTApp.unblock(form);
                window.location.reload();
                $("#freight-history").modal("hide");
                <?php if(ENVIRONMENT !== 'production'){?>
                Swal.fire('Server Error!', xhr.statusText,'warning');
                <?php }?>
            }

        })
    });

    $("form#freight-delivery-form").submit( function(event){
        const  form = $(this);
        event.preventDefault();
        let formData = form.serialize();
        $.ajax({
            url: "<?php echo base_url('freight/index/approve_freight_delivery');?>",
            data: formData,
            type: "post",
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Approving freight delivery, Please wait ..."
                });
            },
            success: function(result){
                KTApp.unblock(form);
                window.location.reload();
                if( result.status == true){
                    $("form#freight-delivery-form").resetForm();
                    $("#approve-freight-delivery").modal("hide");
                    notifySuccess(result.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.ajax.reload();

                }else{
                    swal.fire("","An error occurred! "+ result.message,"warning");
                }
            },
            error: function(xhr){
                KTApp.unblock(form);
                $("#approve-freight-delivery").modal("hide");
                <?php if(ENVIRONMENT !== 'production'){?>
                Swal.fire('Server Error!', xhr.statusText,'warning');
                <?php }?>
            }

        })
    });

    $("form#modify-freight-history-form").submit( function(event){
        const  form = $(this);
        event.preventDefault();
        let formData = form.serialize();
        $.ajax({
            url: "<?php echo base_url('freight/index/modify_freight_history');?>",
            data: formData,
            type: "post",
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Updating freight history, Please wait ..."
                });
            },
            success: function(result){
                KTApp.unblock(form);
                window.location.reload();
                if( result.status == true){
                    $("#modify-freight-history").modal("hide");
                    notifySuccess(result.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();

                }else{
                    swal.fire("","An error occurred! "+ result.message,"warning");
                }
            },
            error: function(xhr){
                KTApp.unblock(form);
                window.location.reload();
                $("#modify-freight-history").modal("hide");
                <?php if(ENVIRONMENT !== 'production'){?>
                Swal.fire('Server Error!', xhr.statusText,'warning');
                <?php }?>
            }

        })
    });

    $('#modify-freight-history').on('show.bs.modal', function (event) {
        var modal = $(this)
        modal.find('.modal-body').html('Please wait ...');
        var button = $(event.relatedTarget)
        var key = button.data('key')
        modal.find('.modal-body').load('<?php echo base_url('freight/index/freight_history_details/');?>' + key);
    })
})
</script>

<script>
    var freightStages = $('#freights-stages-table');
    if(freightStages != undefined){
        // begin stages table
        freightStages.DataTable({
            "ordering": false,
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('freight/index/datasource_freight_stages/'.$freight_key);?>',
            columns: [
                {data: 'fr_stage_date'},
                {data: 'fr_stage_time'},
                {data: 'fr_stage_location'},
                {data: 'fr_stage_desc'},
                {data: 'fr_stage_status'}
            ],
            columnDefs: [
                {
                    targets: 4,
                    render: function (data, type, full, meta) {
                        var status = {
                            "Approved": {'fr_stage_status': 'Approved', 'class': 'kt-badge--success'},
                            "Pending": {'fr_stage_status': 'Pending', 'class': ' kt-badge--warning'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        return "<a href='#'><span class='kt-badge "+ status[data].class + "kt-badge--wide kt-badge--inline kt-font-bolder'>" + status[data].fr_stage_status + "</span></a>";
                    },

                    targets: 5,
                    render: function(data, type, full, meta){
                        if(full.fr_stage_status == 'Approved'){
                                return 'No action';
                        }
                        else{
                            <?php if($freight['fr_file_status'] == 'Active'){ if(has_role('freight_update_stages')){?>
                                return '<a data-key="' + full.fr_stage_key + '" data-toggle="modal" data-backdrop="false" href="#modify-freight-history"><i class="la la-edit kt-font-success"></i> Modify</a>\n';
                            <?php }}
                            else{?>
                                return 'No Action';
                                <?php } ?>
                        }
                    }
                }
            ],
        });

    }
</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>

