<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="newPettyRequestForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">
    <div class="form-group row">
        <div class="col-lg-4 col-md-9 col-sm-12">
            <input hidden class="form-control" readonly name="freight_task_key" type="text" value="<?php echo $task->freight_task_key;?> " />
        </div>
    </div>
    <div class="modal-body">
        <div class="row form-group">
            <div class="col-6">
                <input type="text" hidden name="petty_request_payee" class="form-control" value="<?php echo profile()->user_key;?>"/>
                <label>Requesting For</label>
                <input type="text" class="form-control" name="petty_request_purpose_expense" placeholder="Eg. Handling Charges, Customs Clearance, ..." required>
            </div>
            <div class="col-6">
                <label>File Number</label>
                <input type="text" readonly name="petty_request_file_number" class="form-control" value="<?php echo $task->freight_task_freight_key;?>" />
            </div>
        </div>
        <div class="row form-group">
            <div class="col-6">
                <label>Mode Of Payment</label>
                <select name="petty_request_mode_payment" required class="form-control">
                    <option disabled>Select mode</option>
                    <option value="CASH">CASH</option>
                    <option value="BANK">BANK</option>
                </select>
            </div>
            <div class="col-6">
                <label>Payment Amount</label>
                <input type="number" name="petty_request_payment_amount" placeholder="" class="form-control number" />
            </div>
        </div>
        <div class="form-group row">
            <div class="col-md-12">
                <label >Task Performed</label>
                <textarea data-provide="markdown" readonly class="form-control" name="petty_request_task" value="<?php echo $task->freight_task_desc;?>"><?php echo $task->freight_task_desc;?></textarea>
            </div>
        </div>
        <div class="form-group row">
            <div class="col-md-12">
                <label >Any Comment(optional)</label>
                <textarea data-provide="markdown" class="form-control" name="petty_request_comment" placeholder="Comments"></textarea>
            </div>
        </div>
        <div class="row form-group" hidden>
            <div class="col-6">
                <label>Consignee Name</label>
                <input type="text" name="petty_request_consignee_name" placeholder="" class="form-control" value="<?php echo $task->freight_task_client_name;?>"/>
            </div>
            <!--<div class="col-6">
                <label>Purpose Of Expenses</label>
                <input type="text" name="project_client" class="form-control" value="<?php //echo $task->freight_task_desc;?>"/>
            </div>-->
            <div class="col-6">
                <label>Details</label>
                <input type="text" name="petty_request_details" placeholder="Project Start Date " class="form-control" value="<?php echo $task->freight_task_desc;?>"/>
            </div>

        </div>

        <div class="form-group row" hidden>
            <div class="col-md-7">
                <label >Amount In Words</label>
                <textarea data-provide="markdown" class="form-control" name="petty_request_payment_amount_word" placeholder="For Office Use Only"></textarea>
            </div>
            <div class="col-5">
                <label>SubTotal</label>
                <input type="text" name="project_end_date" class="form-control" placeholder="For Office Use Only" />
            </div>
        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
        <button type="submit" name="submit" class="btn btn-success">Submit Request</button>
    </div>
</form>

<script type="text/javascript">
    $('form#newPettyRequestForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('freight/request/newPettyRequest/');?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Sending Request of payment ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#newPettyRequest').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#newPettyRequest').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>