<?php
$freight_ref = $this->freightsModel->find_by(['fr_key' => $freight_key]);
$inv_ref = $freight_ref['fr_agent_reference_number'];
?>
<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?> 
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('home');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url('freight')?>">Freight Forwarding</a></li>
                            <li class="breadcrumb-item"><a href="<?= base_url('freight/invoices/'.$freight_key)?>">Invoices</a></li>
                            <li class="breadcrumb-item active"><a href="<?= base_url('freight/invoices/'.$freight_key)?>">List of Invoices</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

            
           <!--begin:: Widgets/Quick Stats-->
                    <?php //include __DIR__.'/top_summary.php';?>
            <!--end:: Widgets/Quick Stats-->

            <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
                <div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                            List of Invoices <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                        </h3>
                        <?php
                        $check_inv = $this->invoicesModel->find_by(['freight_ref'=>$freight_key]);
                        $file = $this->freightsModel->find($freight_key);
                        $file_status = $file['fr_file_status'];
                        if(empty($check_inv)){
                            if($file_status == 'Active'){
                                if(has_role('invoice_create')){
                                ?>
                                <a href="<?= base_url('freight/invoice/create/'.$freight_key)?>" class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Create Invoice</a>
                            <?php }}} ?>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#invoices-list" role="tab" aria-selected="false">
                                    Invoices
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#invoices-list-bin" role="tab" aria-selected="true">
                                    Recycle Bin
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="kt-portlet__body kt-portlet__body--fullheight">
                    <div class="tab-content">
                        <div class="tab-pane  active" id="invoices-list">
                            <table id="bms_table_invoices" class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Payer</th>
                                    <th>Issue Date</th>
                                    <th>Expiring Date</th>
                                    <th>Amount</th>
                                    <th>Balance</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="tab-pane" id="invoices-list-bin">
                            <table id="bms_table_invoices_bin" class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Payer</th>
                                        <th>Issue Date</th>
                                        <th>Expiring Date</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <!-- end:: Content -->
</div>

<?php
    include VIEWPATH.'includes/footer.php';?>
    <script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
   <?php include 'scripts.php';
?>

<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>

<script type="text/javascript">

    var LMDatatableInvoices = function() {

        var initInvoices = function() {
            // begin first table
            let table = $('#bms_table_invoices');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_invoice/'.$freight_key);?>',
                    columns: [
                        {data: 'inv_id'},
                        {data: 'firstname'},
                        {data: 'inv_issued_date'},
                        {data: 'inv_expiring_date'},
                        {data: 'inv_total_after_tax'},
                        {data: 'inv_total_balance'},
                        {data: 'inv_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            render: function(data,type, full, meta){
                                if(full.company_name != null){
                                    return '<a href="javascript:(0)">'+ full.company_name + '</a>';
                                }
                                else {
                                    return '<a href="javascript:(0)">'+ full.firstname +' '+ full.lastname + '</a>';
                                }

                            }
                        },
                        {
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.inv_total_after_tax)) +'</a> ';
                            },
                        },{
                            targets: 5,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.inv_total_balance)) +'</a> ';
                            },
                        },
                        {
                            targets: 6,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "SENT": {'inv_status': 'SENT', 'class': 'kt-font-success'},
                                    "DRAFT": {'inv_status': 'DRAFT', 'class': ' kt-font-brand'},
                                    "PAID": {'inv_status': 'PAID', 'class': ' kt-font-success'},
                                    "UNPAID": {'inv_status': 'UNPAID', 'class': ' kt-font-danger'},
                                    "PARTIAL": {'inv_status': 'PARTIAL', 'class': ' kt-font-warning'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="<?php echo base_url('invoices/details/');?>' + full.inv_key + '"><span class="' + status[data].class + ' kt-font-bolder">' + status[data].inv_status + '</span></a>';
                            },
                        },
                        {
                            targets: 7,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                <?php
                                if($file_status == 'Active'){
                                ?>
                                return '<a href="<?php echo base_url('invoices/details/');?>'+ full.inv_key + '" > View Details</a> &nbsp' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '<i class="flaticon-more-v2"></i>\n' +
                                    '</span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '<a class="dropdown-item"  href="<?php echo base_url('invoices/modify/');?>' + full.inv_key + '"><i class="la la-edit kt-font-warning"></i> Modify</a>\n' +
                                    '<a class="dropdown-item"  href="<?php echo base_url('invoices/payments/');?>' + full.inv_key + '"><i class="la la-money kt-font-info"></i> Payments</a>\n' +
                                    '<a class="dropdown-item"  href="javascript:deleteInvoice(' + full.inv_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                                    <?php
                                }
                                else{
                                    ?>
                                     return '<a href="<?php echo base_url('invoices/details/');?>'+ full.inv_key + '" > View Details</a> &nbsp';
                                <?php
                                }
                                ?>
                            },
                        },
                    ]
                });
            }
        };

        var initRecycle = function() {
            // begin first table
            let table = $('#bms_table_invoices_bin');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: false,
                    ajax: '<?php echo base_url('freight/index/datasource_invoice_bin/'.$freight_key);?>',
                    columns: [
                        {data: 'inv_id'},
                        {data: 'firstname'},
                        {data: 'inv_issued_date'},
                        {data: 'inv_expiring_date'},
                        {data: 'inv_total_after_tax'},
                        {data: 'inv_total_balance'},
                        {data: 'inv_status'},
                    ],
                    // Pagination settings
                    dom: `<'row'<'col-sm-12'tr>>
    			    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        {
                            text: 'Delete Selected',
                            action: function (e, dt, node, config) {
                                deleteSelected(table);
                            }
                        },
                        'selectAll',
                        'selectNone',
                        'excelHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                if(full.company_name != null){
                                    return '<a href="javascript:(0)">'+ full.company_name + '</a>';
                                }
                                else {
                                    return '<a href="javascript:(0)">'+ full.firstname +' '+ full.lastname + '</a>';
                                }
                            },
                        },
                        {
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.inv_total_after_tax)) +'</a> ';
                            },
                        },{
                            targets: 5,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a  href="javascript:(0);">' + KTUtil.numberString(to_money(full.inv_total_balance)) +'</a> ';
                            },
                        },
                        {
                            targets: 6,
                            render: function (data, type, full, meta) {
                                var status = {
                                    "SENT": {'inv_status': 'SENT', 'class': 'kt-font-success'},
                                    "DRAFT": {'inv_status': 'DRAFT', 'class': ' kt-font-brand'},
                                    "PAID": {'inv_status': 'PAID', 'class': ' kt-font-success'},
                                    "UNPAID": {'inv_status': 'UNPAID', 'class': ' kt-font-danger'},
                                    "PARTIAL": {'inv_status': 'PARTIAL', 'class': ' kt-font-warning'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="<?php echo base_url('invoices/details/');?>' + full.inv_key + '"><span class="' + status[data].class + ' kt-font-bolder">' + status[data].inv_status + '</span></a>';
                            },
                        },
                        {
                            targets: 7,
                            "width": "18%",
                            render: function (data, type, full, meta) {
                                return '<a href="<?php echo base_url('invoices/details/');?>'+ full.inv_key + '" > View Details</a> &nbsp' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '<i class="flaticon-more-v2"></i>\n' +
                                    '</span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '<a class="dropdown-item"  href="javascript:restoreInvoice(' + full.inv_key + ');"><i class="la la-reply kt-font-success"></i> Restore</a>\n' +
                                    // '<a class="dropdown-item"  href="javascript:deleteForever(' + full.inv_key + ');"><i class="la la-trash kt-font-danger"></i> Delete Permanently</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                            },
                        },
                    ]
                });
            }
        };

        return {
            //main function to initiate the module
            init: function() {
                initInvoices();
                initRecycle();
            },

        };

    }();

    jQuery(document).ready(function() {

        LMDatatableInvoices.init();

    });


    function deleteInvoice(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/deleteinv')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Invoice ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreInvoice(inv){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/restoreinv')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Invoice ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteForever(inv){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('invoices/deleteinvforever')?>/' + inv,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Invoice ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
