<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('importers');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Freight Forwarding</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Consignee Freights</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>


        <!--begin:: Widgets/Quick Stats-->
        <?php //include __DIR__.'/top_summary.php';?>
        <!--end:: Widgets/Quick Stats-->

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        FREIGHT DETAILS ON CONSIGNEE (
                        <?php
                             if (!empty($users->company_name)):
                              echo "<font style='color: green'>".$users->company_name."</font>";
                            else:
                              echo "<font style='color: green'>".$users->firstname.' '.$users->lastname."</font>";
                            endif;
                        ?>)
                        <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#importer-freights-list" role="tab" aria-selected="false">
                                Freights
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#importer-freights-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="importer-freights-list">
                        <table class="table " id="importer-freights-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>File Number</th>
                                <th>Cargo Details</th>
                                <th>Vessel</th>
                                <th>ETA/ETD</th>
                                <th>Invoice Number</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="importer-freights-list-bin">
                        <table id="importer-freights-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>File Number</th>
                                <th>Cargo Details</th>
                                <th>Vessel</th>
                                <th>ETA/ETD</th>
                                <th>Invoice Number</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Content -->
</div>
<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php
include __DIR__.'/scripts.php';
//include __DIR__.'/common.php';
?>
<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>
<script type="text/javascript">
    function copyFreight(fr) {
        // Create temp element off-screen to hold text.
        var tempElem = $('<textarea style="position: absolute; top: -8888px; left: -8888px">');
        $("body").append(tempElem);

        tempElem.val(fr).select();
        document.execCommand("copy");
        tempElem.remove();
    }
    function closeFile(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            text: 'You are about closing file, all processes regarding to file no. '+ fr +' will be ended now and won\'t be re-opened, make sure no part is pending before closing file!',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, close it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/close_freight')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Closing file, please wait ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'warning');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteFreight(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_freight')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Freight ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreFreight(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_freight')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Freight ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    var importerFreights = $('#importer-freights-list-table');
    if(importerFreights != undefined){
        // begin freights table
        importerFreights.DataTable({
            "ordering": false,
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('freight/index/datasource_importer_freights/'.$users->user_key.$when);?>',
            columns: [
                {data: 'fr_id'},
                {data: 'fr_key'},
                {data: 'fr_cargo_details'},
                {data: 'fr_vessel'},
                {data: 'fr_eta_etd'},
                {data: 'inv_key'},
                {data: 'fr_file_status'},
            ],
            columnDefs: [
                {
                    targets: 1,
                    render: function(data,type, full, meta){
                        return '<a href="<?php echo base_url('freight/details/');?>' + full.fr_key + '">'+ full.fr_key + '</a>'
                    }
                },
                {
                    targets: 5,
                    render: function (data,type, full, meta) {
                        if(full.inv_key != null) {
                            return '<a href="<?php echo base_url('invoices/details/')?>' + full.inv_key + '">' + full.inv_key + '</a>';
                        }
                        else{
                            return '<a href="#" style="color:brown">Pending</a>';
                        }
                    }

                },
                {
                    targets: 6,
                    "width": "15%",
                    render: function (data, type, full, meta) {
                        var status = {
                            "Approved": {'fr_file_status': 'Approved', 'class': 'kt-badge--success'},
                            "Active": {'fr_file_status': 'Active', 'class': 'kt-badge--success'},
                            "Pending": {'fr_file_status': 'Pending', 'class': ' kt-badge--warning'},
                            "Rejected": {'fr_file_status': 'Rejected', 'class': ' kt-badge--danger'},
                            "Closed": {'fr_file_status': 'Closed', 'class': ' kt-badge--danger'},
                            "Pending Reject": {'fr_file_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        if(full.fr_file_status == 'Active'){
                            if (full.fr_doc != null){
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.fr_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fr_file_status + '</span></a> ' +
                                    '<a href="javascript:deleteFreight(' + full.fr_key + ');" title="Delete"><i class="la la-trash kt-font-danger"></i></a> | '+
                                    '<a href="<?php echo base_url('freight/edit/');?>' + full.fr_key + '" title="Edit Freight"><i class="la la-edit kt-font-info"></i></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    //'                                <a class="dropdown-item"  href="</?php echo base_url('freight/edit/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i> Edit Freight</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/quotations/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Quotation</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/invoices/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Invoice</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo uploadFilePath('freight_docs/');?>' + full.fr_doc + '"><i class="la la-download kt-font-info"></i> Download Document</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/details/');?>' + full.fr_key + '"><i class="la la-eye kt-font-success"></i> View Report</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/stages/');?>' + full.fr_key + '"><i class="la la-list kt-font-success"></i> Freight Stages</a>\n' +
                                    //'                                <a class="dropdown-item"  href="javascript:deleteFreight(' + full.fr_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                                <a class="dropdown-item"  href="javascript:copyFreight(' + full.fr_key + ');"><i class="la la-copy kt-font-info"></i> Copy File Number</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/documents/');?>' + full.fr_key + '"><i class="la la-cog kt-font-success"></i> Freight Details</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item"  href="javascript:closeFile(' + full.fr_key + ');"><i class="fa fa-folder kt-font-danger"></i> Close File</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            }
                            else {
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.fr_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fr_file_status + '</span></a> ' +
                                    '<a href="javascript:deleteFreight(' + full.fr_key + ');" title="Delete"><i class="la la-trash kt-font-danger"></i></a> | '+
                                    '<a href="<?php echo base_url('freight/edit/');?>' + full.fr_key + '" title="Edit Freight"><i class="la la-edit kt-font-info"></i></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    //'                                <a class="dropdown-item"  href="</?php echo base_url('freight/edit/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i> Edit Freight</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/quotations/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Quotation</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/invoices/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Invoice</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/details/');?>' + full.fr_key + '"><i class="la la-eye kt-font-success"></i> View Report</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/stages/');?>' + full.fr_key + '"><i class="la la-list kt-font-success"></i> Freight Stages</a>\n' +
                                    //'                                <a class="dropdown-item"  href="javascript:deleteFreight(' + full.fr_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                                <a class="dropdown-item"  href="javascript:copyFreight(' + full.fr_key + ');"><i class="la la-copy kt-font-info"></i> Copy File Number</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/documents/');?>' + full.fr_key + '"><i class="la la-cog kt-font-success"></i> Freight Details</a>\n' +
                                    '                               <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item"  href="javascript:closeFile(' + full.fr_key + ');"><i class="fa fa-folder kt-font-danger"></i> Close File</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            }
                        }
                        else {
                            if (full.fr_doc != null){
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.fr_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fr_file_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/quotations/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Quotation</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/invoices/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Invoice</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo uploadFilePath('freight_docs/');?>' + full.fr_doc + '"><i class="la la-download kt-font-info"></i> Download Document</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/details/');?>' + full.fr_key + '"><i class="la la-eye kt-font-success"></i> View Report</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/stages/');?>' + full.fr_key + '"><i class="la la-list kt-font-success"></i> Freight Stages</a>\n' +
                                    //'                                <a class="dropdown-item"  href="javascript:deleteFreight(' + full.fr_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                                <a class="dropdown-item"  href="javascript:copyFreight(' + full.fr_key + ');"><i class="la la-copy kt-font-info"></i> Copy File Number</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/documents/');?>' + full.fr_key + '"><i class="la la-cog kt-font-success"></i> Freight Details</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            }
                            else {
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="' + full.fr_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fr_file_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/quotations/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Quotation</a>\n' +
                                    '                                <a class="dropdown-item"  href="<?php echo base_url('freight/invoices/');?>' + full.fr_key + '"><i class="la la-edit kt-font-info"></i>Created Invoice</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/details/');?>' + full.fr_key + '"><i class="la la-eye kt-font-success"></i> View Report</a>\n' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/stages/');?>' + full.fr_key + '"><i class="la la-list kt-font-success"></i> Freight Stages</a>\n' +
                                    // '                                <a class="dropdown-item"  href="javascript:deleteFreight(' + full.fr_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                                <a class="dropdown-item"  href="javascript:copyFreight(' + full.fr_key + ');"><i class="la la-copy kt-font-info"></i> Copy File Number</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" href="<?php echo base_url('freight/documents/');?>' + full.fr_key + '"><i class="la la-cog kt-font-success"></i> Freight Details</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            }
                        }
                    },
                }
            ],
        });

    }

    var importerFreightsBin = $('#importer-freights-list-bin-table');
    if(importerFreightsBin != undefined){
        // begin freights table
        importerFreightsBin.DataTable({
            "ordering": false,
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url('freight/index/datasource_importer_freights_bin/'.$users->user_key.$when);?>',
            columns: [
                {data: 'fr_id'},
                {data: 'fr_key'},
                {data: 'fr_cargo_details'},
                {data: 'fr_vessel'},
                {data: 'fr_eta_etd'},
                {data: 'inv_key'},
                {data: 'fr_file_status'},
            ],
            columnDefs: [
                {
                    targets: 5,
                    render: function (data,type, full, meta) {
                        if(full.inv_key != null) {
                            return '<a href="<?php echo base_url('invoices/details/')?>' + full.inv_key + '">' + full.inv_key + '</a>';
                        }
                        else{
                            return '<a href="#" style="color:brown">Pending</a>';
                        }
                    }

                },
                {
                    targets: 6,
                    "width": "15%",
                    render: function (data, type, full, meta) {
                        return  '<a  href="javascript:restoreFreight('+ full.fr_key  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';
                    },
                }
            ],
        });

    }
</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>

