<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('home');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Freight Forwarding</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Freight Details</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>


        <!--begin:: Widgets/Quick Stats-->
        <?php //include __DIR__.'/top_summary.php';?>
        <!--end:: Widgets/Quick Stats-->

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        FREIGHTS LIST <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#freights-list" role="tab" aria-selected="false">
                                Freights
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#freights-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="freights-list">
                        <table class="table " id="freights-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>File Number</th>
                                <th>Client</th>
                                <th>Cargo Details</th>
                                <th>Vessel</th>
                                <th>ETA/ETD</th>
                                <th>Invoice Number</th>
                                <th>File Status / Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="freights-list-bin">
                        <table id="freights-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>File Number</th>
                                <th>Client</th>
                                <th>Cargo Details</th>
                                <th>Vessel</th>
                                <th>ETA/ETD</th>
                                <th>Invoice Number</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Content -->
</div>
<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-datetimepicker.js" type="text/javascript"></script>

<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>

<?php
include __DIR__.'/scripts.php';
//include __DIR__.'/common.php';
?>

<script type="text/javascript">
    function copyFreight(text) {
            // Create temp element off-screen to hold text.
            var tempElem = $('<textarea style="position: absolute; top: -8888px; left: -8888px">');
            $("body").append(tempElem);

            tempElem.val(text).select();
            document.execCommand("copy");
            tempElem.remove();
        }
    function closeFile(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'question',
            text: 'You are about closing file, all processes regarding to file no. '+ fr +' will be ended now and won\'t be re-opened, make sure no part is pending before closing file!',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, close it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/close_freight')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Closing file, please wait ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'warning');
                        <?php }?>
                    }
                });
            }
        })
    }
    function deleteFreight(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_freight')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Freight ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'warning');
                        <?php }?>
                    }
                });
            }
        })
    }
    function restoreFreight(fr){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_freight')?>/' + fr,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Freight ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'warning');
                        <?php }?>
                    }
                });
            }
        })
    }

</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>
