<?php
$freight_key = $this->freightsModel->find_by(['fr_key'=>$freight['fr_key']]);
$consignee = $freight_key['fr_client'];
$shipper = $freight_key['fr_importer'];
if(!empty($shipper)) {
    $sender = profile($shipper)->company_name;
}
if(!empty($consignee)) {
    $company = profile($consignee)->company_name;
    $client = profile($consignee)->firstname . ' ' . profile($consignee)->middlename . ' ' . profile($consignee)->lastname;
}
?>
<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?= base_url('resources/')?>assets/css/pages/invoices/invoice-2.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.5.0/css/bootstrap-datepicker.css" rel="stylesheet">
<style>
    @media print {
        body * {
            visibility: hidden;
        }

        .print-note, .print-note * {
            visibility: visible;
        }
    }
</style>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuFreightForward('home');?>
    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
            <div class="kt-portlet">
                <div class="kt-portlet__body  kt-portlet__body--fit">
                    <div class="row row-no-padding row-col-separator-xl">
                        <?php include('side_menu.php'); ?>
                        <div class="col-md-9">

                            <!--begin::Portlet-->
                            <div id="kt_page_portlet">
                                <div class="kt-widget24 kt-padding-b-0">
                                    <div class="kt-widget24__details">
                                        <div class="kt-widget24__info">
                                            <h4 class="kt-widget24__title">
                                                <h3 class="kt-portlet__head-title"><?php //echo ucwords($employee->firstname . ' ' . $employee->middlename . ' ' . $employee->lastname); ?>
                                                    <small id="information">Freight Information (File No - <?= $freight['fr_key']; ?>)</small>
                                                    <?php
                                                    if($freight['fr_file_status'] == 'Closed'){
                                                        echo "<a style='color: red; margin-left: 5px'><i class='fa fa-folder'></i> File Closed </a>";
                                                    }
                                                    ?>
                                                </h3>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                                <hr/>
                                <div class="kt-portlet__body" id="details">
                                    <div class="row">
                                        <div class="col">
                                            <div class="alert alert-light alert-elevate fade show" role="alert">
                                                <div class="alert-text">
                                                    <h3>Delivery Note |
                                                        <?php
                                                        $delivery = $this->deliveryNoteModel->find_many_by(['delivery_note_fr_key'=>$freight['fr_key'], 'delivery_note_deleted'=>0]);
                                                        if(empty($delivery)){
                                                        if($freight_key['fr_file_status'] == 'Active'){
                                                        ?>
                                                        <a href="#delivery-note" data-backdrop="false" data-toggle="modal"
                                                           class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Create Delivery Note</a></h3>
                                                    <?php
                                                    }}else{
                                                        if($freight_key['fr_file_status'] == 'Active'){
                                                            ?>
                                                            <a href="#modify-delivery-note" data-backdrop="false" data-toggle="modal"
                                                               class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Modify Delivery Note</a></h3>
                                                        <?php }}?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!--old form here // form is found in delivery_note1 file. -->
                                    <!--old form here-->

                                    <?php
                                    if(!empty($delivery)){
                                        //var_dump($delivery);
                                        foreach ($delivery as $note){
                                            ?>
                                            <div class="kt-portlet print-note" id="printableArea">
                                                <div class="kt-portlet__body kt-portlet__body--fit">
                                                    <div class="kt-invoice-2">
                                                        <div class="kt-invoice__head">
                                                            <div class="kt-invoice__container">
                                                                <h3 style="color: #0a6aa1">DELIVERY NOTE</h3>
                                                                <div class="kt-invoice__brand" style="float: right;">
                                                                    <div href="#" class="kt-invoice__logo">
                                                                        <a href="#"><img style="width: 100px; height: 90px" src="<?php echo base_url('resources/')?>assets/images/rurutz-logo.PNG"></a>
                                                                        <!--<span class="kt-invoice__desc">
                                                                            <span>Cecilia Chapman, 711-2880 Nulla St, Mankato</span>
                                                                            <span>Mississippi 96522</span>
                                                                        </span>-->
                                                                    </div>
                                                                </div>
                                                                <div class="kt-invoice__items">
                                                                    <div class="kt-invoice__item">
                                                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">DATE</span>
                                                                        <span class="kt-invoice__text"><?= $note['delivery_note_created']; ?></span>
                                                                    </div>
                                                                    <div class="kt-invoice__item">
                                                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">WAY BILL NUMBER</span>
                                                                        <span class="kt-invoice__text"><?= $note['delivery_note_bill_no']; ?></span>
                                                                    </div>
                                                                </div>
                                                                <div class="kt-invoice__items">
                                                                    <div class="kt-invoice__item">
                                                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">SENDER</span>
                                                                        <span class="kt-invoice__text">
                                                                            Name : <?php
                                                                                if (!empty($sender)) {
                                                                                    echo $sender;
                                                                                }
                                                                                else{
                                                                                    echo "N/A";
                                                                                }
                                                                                ?><br>
                                                                            Location : <?= $note['delivery_note_sender_location']; ?>
                                                                        </span>
                                                                    </div>
                                                                    <div class="kt-invoice__item">
                                                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">CONSIGNEE</span>
                                                                        <span class="kt-invoice__text">
                                                                            Name : <?php
                                                                                if (!empty($company)) {
                                                                                    echo $company;
                                                                                }
                                                                                else{
                                                                                    echo $client;
                                                                                }
                                                                                ?><br>
                                                                            Location : <?= $note['delivery_note_consignee_location']; ?>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                                <div class="kt-invoice__items">
                                                                    <div class="kt-invoice__item">
                                                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">DRIVER DETAILS</span>
                                                                        <span class="kt-invoice__text">
                                                                            Driver Name : <?= $note['delivery_note_driver_name']; ?> <br>
                                                                            Phone Number : <?= $note['delivery_note_driver_phone']; ?> <br>
                                                                            License Number : <?= $note['delivery_note_driver_license']; ?> <br>
                                                                        </span>
                                                                    </div>
                                                                    <div class="kt-invoice__item">
                                                                        <span class="kt-invoice__subtitle" style="color: rebeccapurple;font-weight: bold">TRANSPORTER DETAILS</span>
                                                                        <span class="kt-invoice__text">
                                                                            Truck Number : <?= $note['delivery_note_truck_no']; ?> <br>
                                                                            Truck Owner : <?= $note['delivery_note_truck_owner']; ?> <br>
                                                                            Trailer Number : <?= $note['delivery_note_trailer_no']; ?> <br>
                                                                            Trailer Owner : <?= $note['delivery_note_trailer_owner']; ?> <br>
                                                                            Transport Mode : <?= $freight_key['fr_plan_name']; ?> <br>
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="kt-invoice__body">
                                                            <div class="kt-invoice__container">
                                                                <div class="table-responsive">
                                                                    <table class="table">
                                                                        <thead>
                                                                        <tr>
                                                                            <th>NO</th>
                                                                            <th>ITEM</th>
                                                                            <th>PACKAGING</th>
                                                                            <th>WEIGHT</th>
                                                                        </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                        <tr>
                                                                            <td><?= 1; ?></td>
                                                                            <td><?= $freight_key['fr_cargo_details']; ?></td>
                                                                            <td><?= $freight_key['fr_category_name']; ?></td>
                                                                            <td><?= $freight_key['fr_gross_weight']; ?></td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="kt-invoice__footer">
                                                            <div class="kt-invoice__container">
                                                                <div class="table-responsive">
                                                                    <table class="table">
                                                                        <thead>
                                                                        <tr>
                                                                            <th>Comments / observations (Condition of goods on reception: missing /damaged, etc)
                                                                            </th>
                                                                        </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                        <tr>
                                                                            <td><?= $note['delivery_note_comment']; ?></td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="kt-invoice__actions">
                                                <div class="kt-invoice__container">
                                                    <!--<button type="button" class="btn btn-label-brand btn-bold" onclick="window.print();">Download Invoice</button>-->
                                                    <button type="button" class="btn btn-brand btn-bold" onclick="window.print();">Print Delivery Note</button>
                                                </div>
                                            </div>
                                        <?php }} ?>

                                    <!--Begin::Section-->
                                    <div class="row">
                                        <?php
                                        $freight_doc = $this->documentsModel->find_many_by(['doc_fr_key'=>$freight['fr_key'],'doc_type'=>'Delivery Note']);
                                        if(!empty($freight_doc)):
                                            foreach($freight_doc as $doc):
                                                ?>
                                                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $doc['doc_key'];?>'>

                                                    <!--Begin::Portlet-->
                                                    <div class="kt-portlet">
                                                        <div class="kt-portlet__head kt-portlet__head--noborder">
                                                            <div class="kt-portlet__head-label">
                                                                <h3 class="kt-portlet__head-title">
                                                                </h3>
                                                            </div>
                                                            <div class="kt-portlet__head-toolbar">
                                                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                                                    <i class="flaticon-more-1"></i>
                                                                </a>
                                                                <div class="dropdown-menu dropdown-menu-right">
                                                                    <ul class="kt-nav">
                                                                        <li class="kt-nav__item">
                                                                            <a href="<?= uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-nav__link">
                                                                                <i class="kt-nav__link-icon flaticon2-download"></i>
                                                                                <span class="kt-nav__link-text">Download</span>
                                                                            </a>
                                                                        </li>
                                                                        <li class="kt-nav__item">
                                                                            <a href="javascript:(0);" onclick="deleteDocument('<?php echo $doc['doc_key'];?>')" class="kt-nav__link">
                                                                                <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                                                <span class="kt-nav__link-text">Delete</span>
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="kt-portlet__body">
                                                            <!--begin::Widget -->
                                                            <div class="kt-widget__files">
                                                                <div class="kt-widget__media">
                                                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($doc['doc_file']);?>.svg" alt="FILE">
                                                                </div>

                                                                <a target="_blank" href="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>"  data-url="<?php echo uploadFilePath('freight_docs/').$doc['doc_file'];?>" class="kt-widget__desc">
                                                                    <?php echo $doc['doc_name'];?>
                                                                </a>
                                                            </div>

                                                            <!--end::Widget -->
                                                        </div>
                                                    </div>

                                                    <!--End::Portlet-->
                                                </div>
                                            <?php endforeach; endif; ?>
                                    </div>
                                    <!--End::Section-->
                                </div>
                                <!--end::Portlet-->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end:: Content -->
            </div>

        </div>

    </div>
    <!-- end:: Content -->
</div>

<!-- Begin: create delivery note Modal -->
<div class="modal fade" id="delivery-note" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'delivery-note-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Create Delivery Note</h3>
                <div style="float: right"><button type="button" data-dismiss="modal" class="btn btn-secondary">Close</button></div>
            </div>
            <!--<div class="row">
                <div class="col">
                    <div class="alert alert-light alert-elevate fade show" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-danger"></i></div>
                        <div class="alert-text">
                            <code><b>Warning :</b> <br> This is the final stage of this freight history. Once approved this stage, the entire history on this freight will no longer created or updated</code>
                        </div>
                    </div>
                </div>
            </div>-->
            <div class="modal-body">
                <div class="kt-portlet__body">
                    <input type="hidden" name="delivery_note_fr_key" value="<?= $freight['fr_key']?>">
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label class="col-form-label">Delivery Note / Way Bill No</label>
                            <input class="form-control" type="text" name="delivery_note_bill_no" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Truck Number</label>
                            <input class="form-control" type="text" name="delivery_note_truck_no" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Trailer Details</label>
                            <input type="text" name="delivery_note_trailer_no" class="form-control" required>
                        </div>
                        <!--<div class="col-md-6">
                            <label class="col-form-label">Transport Mode</label>
                            <input type="text" name="fr_stage_date" class="form-control" required>
                        </div>-->
                    </div>
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label class="col-form-label">Driver Name</label>
                            <input class="form-control" type="text" name="delivery_note_driver_name" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Driver Contacts (phone)</label>
                            <input type="text" name="delivery_note_driver_phone" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="col-form-label">Driver License Number</label>
                            <input type="text" name="delivery_note_driver_license" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label class="col-form-label">Truck Owner</label>
                            <input type="text" name="delivery_note_truck_owner" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="col-form-label">Trailer Owner</label>
                            <input type="text" name="delivery_note_trailer_owner" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-6">
                            <label class="col-form-label">Sender Location</label>
                            <input type="text" name="delivery_note_sender_location" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label class="col-form-label">Consignee Location</label>
                            <input type="text" name="delivery_note_consignee_location" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            <label class="col-form-label">Comments / observations (Condition of goods on reception: missing /damaged, etc)</label>
                            <textarea class="form-control summernote" name="delivery_note_comment" required></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: create delivery note Modal -->

<!-- Begin: modify delivery note Modal -->
<div class="modal fade" id="modify-delivery-note" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-delivery-note-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify Delivery Note</h3>
                <div style="float: right"><button type="button" data-dismiss="modal" class="btn btn-secondary">Close</button></div>
            </div>
            <!--<div class="row">
                <div class="col">
                    <div class="alert alert-light alert-elevate fade show" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-danger"></i></div>
                        <div class="alert-text">
                            <code><b>Warning :</b> <br> This is the final stage of this freight history. Once approved this stage, the entire history on this freight will no longer created or updated</code>
                        </div>
                    </div>
                </div>
            </div>-->
            <?php
            if(!empty($delivery)){
                //var_dump($delivery);
                foreach ($delivery as $note){
                    ?>
                    <div class="modal-body">
                        <div class="kt-portlet__body">
                            <input type="hidden" name="delivery_note_fr_key" value="<?= $freight['fr_key']?>">
                            <input type="hidden" name="delivery_note_key" value="<?= $note['delivery_note_key']?>">
                            <div class="form-group row">
                                <div class="col-md-4">
                                    <label class="col-form-label">Delivery Note / Way Bill No</label>
                                    <input class="form-control" type="text" name="delivery_note_bill_no" value="<?= $note['delivery_note_bill_no'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Truck Number</label>
                                    <input class="form-control" type="text" name="delivery_note_truck_no" value="<?= $note['delivery_note_truck_no'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Trailer Number</label>
                                    <input type="text" name="delivery_note_trailer_no" class="form-control" value="<?= $note['delivery_note_trailer_no'];?>" required>
                                </div>
                                <!--<div class="col-md-6">
                                    <label class="col-form-label">Transport Mode</label>
                                    <input type="text" name="fr_stage_date" class="form-control" required>
                                </div>-->
                            </div>
                            <div class="form-group row">
                                <div class="col-md-4">
                                    <label class="col-form-label">Driver Name</label>
                                    <input class="form-control" type="text" name="delivery_note_driver_name" value="<?= $note['delivery_note_driver_name'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Driver Contacts (phone)</label>
                                    <input type="text" name="delivery_note_driver_phone" class="form-control" value="<?= $note['delivery_note_driver_phone'];?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="col-form-label">Driver License Number</label>
                                    <input type="text" name="delivery_note_driver_license" class="form-control" value="<?= $note['delivery_note_driver_license'];?>" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="col-form-label">Truck Owner</label>
                                    <input type="text" name="delivery_note_truck_owner" class="form-control" value="<?= $note['delivery_note_truck_owner'];?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="col-form-label">Trailer Owner</label>
                                    <input type="text" name="delivery_note_trailer_owner" class="form-control" value="<?= $note['delivery_note_trailer_owner'];?>" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label class="col-form-label">Sender Location</label>
                                    <input type="text" name="delivery_note_sender_location" class="form-control" value="<?= $note['delivery_note_sender_location'];?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="col-form-label">Consignee Location</label>
                                    <input type="text" name="delivery_note_consignee_location" class="form-control" value="<?= $note['delivery_note_consignee_location'];?>" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="col-form-label">Comments / observations (Condition of goods on reception: missing /damaged, etc)</label>
                                    <textarea class="form-control summernote" name="delivery_note_comment" required><?= $note['delivery_note_comment'];?></textarea>
                                </div>
                            </div>
                            <!--<div class="form-group row">
                                <div class="col-md-6">
                                    <label class="col-form-label">Sender</label>
                                    <input class="form-control" type="text" value="
                                    " name="fr_invoice_date" readonly>
                                    <label class="col-form-label">Sender Location</label>
                                    <input class="form-control" type="text" name="fr_invoice_date" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="col-form-label">Consignee</label>
                                    <input type="text" name="fr_stage_date" class="form-control" value="

                                    " readonly>
                                    <label class="col-form-label">Consignee Location</label>
                                    <input type="text" name="fr_stage_date" class="form-control" required>
                                </div>
                            </div>-->
                            <!--<div class="form-group row">
                                <div class="col-lg-12" style="margin-top: 5px">
                                    <label class="">Attach File:</label>
                                    <div class="m-dropzone dropzone m-dropzone--primary dz-clickable" id="kt_dropzone_note1">
                                        <div class="dropzone-msg dz-message needsclick" >
                                            <h3 class="dropzone-msg-title">Click here to upload file..</h3>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
                            </div>-->
                        </div>
                    </div>
                <?php }}?>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: modify delivery note Modal -->

<?php include VIEWPATH.'includes/footer.php';
//include __DIR__.'/scripts.php';
?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources');?>/assets/js/pages/crud/forms/widgets/bootstrap-datetimepicker.js" type="text/javascript"></script>

<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>

<!--begin::Page Scripts(used by this page) -->
<script src="<?php echo base_url('resources')?>/assets/js/pages/crud/forms/editors/summernote.js" type="text/javascript"></script>
<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>-->
<script type="text/javascript">
    function printDiv(divName) {
        var printContents = document.getElementById(divName).innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;

        window.print();

        document.body.innerHTML = originalContents;
    }

    $(function () {
        $('form#delivery-note-form').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);
            $.ajax({
                url: '<?php echo base_url( 'freight/index/create_delivery_note');?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.blockPage({
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Creating Delivery Note...."
                    });
                },
                success: function () {
                    KTApp.unblockPage();
                    Swal.fire('Success', 'Delivery Note Successfully Created!', 'success');
                    $("#delivery-note").modal("hide");
                    window.location.reload();
                },
                error: function (xhr) {
                    Swal.fire('', xhr.statusText, 'warning');
                    KTApp.unblockPage();
                    $("#delivery-note").modal("hide");
                }
            });
        });
    })

    $(function () {

        $('form#modify-delivery-note-form').submit(function (event) {
            let form = $(this);
            let $div = $('div#details');
            event.preventDefault();
            let formdata = form.serialize();
            //alert(formdata);
            $.ajax({
                url: '<?php echo base_url( 'freight/index/modify_delivery_note');?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.blockPage({
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Modifying Delivery Note...."
                    });
                },
                success: function () {
                    KTApp.unblockPage();
                    Swal.fire('', 'Delivery Note Successfully Modified!', 'success');
                    $("#modify-delivery-note").modal("hide");
                    window.location.reload();
                },
                error: function (xhr) {
                    Swal.fire('Error', xhr.statusText, 'warning');
                    KTApp.unblockPage();
                    $("#modify-delivery-note").modal("hide");
                }
            });
        });
    })
</script>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>