<div class="modal fade" id="type-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Type Details</h3>
            </div>
            <div class="modal-body type-details-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X
                </button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="transactions-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Type Transactions</h3>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X
                </button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="expenditure-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Type Expenditure</h3>
            </div>
            <div class="modal-body expenditure-details-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X
                </button>
            </div>
        </div>
    </div>
</div>


<script>

    $(function () {
        $('select').select2();

        $('#type-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.type-details-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url('expenses/types/index/details/');?>' + key);
        })

        $('#expenditure-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.expenditure-details-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url('expenses/types/index/expenditure/');?>' + key);
        })

    })


    function createtype() {
        let form = $("form#formTypeCreate");
        let formdata = form.serialize();
        $.ajax({
            url: "<?php echo base_url('expenses/types/index/create');?>",
            data: formdata,
            type: "post",
            beforeSend: function () {
                KTApp.blockPage({
                    overlayColor: "#000000",
                    type: "loader",
                    state: "danger",
                    message: "Deleting category ..."
                });
            },
            success: function (response) {
                KTApp.unblockPage();
                if (response.status == true) {
                    form[0].reset();
                    notifySuccess(response.message);
                    var table = $.fn.dataTable.tables({api: true});
                    table.ajax.reload();
                } else {
                    Swal.fire("Server response", response.message, "warning");
                }
            },
            error: function (xhr) {
                KTApp.unblockPage();
                Swal.fire("Server response ", "Server issue occurred please try again later or contact support: <?php echo config_item("server_level_support");?>", "warning");
            }
        })
    }

    function deleteType(type) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('expenses/types/index/delete')?>/' + type,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting type ..."
                        });
                    },
                    success: function (response) {
                        KTApp.unblockPage();
                        if (response.status == true) {
                            notifySuccess(response.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            Swal.fire("Server response", response.message, "warning");
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire("Server response " + xhr.statusText, "Server issue occurred please try again later or contact support: <?php echo config_item("server_level_support");?>", "warning");
                    }
                });
            }
        })
    }
</script>
