<?php if(!empty($when = $this->input->get("when"))){
        $when = '?when='.$when;
    }else{
        $when = '';
}?>
<script type="text/javascript">

  //== Class definition
  $.fn.dataTable.Api.register('column().title()', function() {
      return $(this.header()).text().trim();
  });

var Datatable = function() {

	var initTable = function() {

		var tableList = $('#expense-lis-table');

        var tableListBin = $('#expense-lis-bin-table');

		if(tableList != undefined){
            // begin first table
            tableList.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('expenses/index/datasource'.$when);?>',
                columns: [
                    {data: 'expense_date'},
                    {data: 'firstname'},
                    {data: 'category_title'},
                    {data: 'type_title'},
                    {data: 'expense_amount'},
                    {data: 'expense_payee'},
                    {data: 'expense_status'},
                ],
                columnDefs: [

                    {
                        targets: 0,
                        "width": "7%",
                    },
                    {
                        targets: 1,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('hrm/employees/index/details/');?>' + full.expense_created_by +'">' + full.firstname + " " + full.lastname + '</a>';
                        },
                    },
                    {
                        targets: 2,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('expenses/categories');?>">' + full.category_title + '</a>';
                        },
                    },
                    {
                        targets: 3,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('expenses/types');?>">' + full.type_title + '</a>';
                        },
                    },{
                        targets: 4,
                        "width": "5%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.expense_amount)).format('0,0') ;
                        },
                    },
                    {
                        // hide columns by index number
                        targets: 5,
                        "width": "15%",

                    },
                    {
                        targets: 6,
                        "width": "15%",
                        render: function(data, type, full, meta) {
                            var status = {
                                "Approved": {'expense_status': 'Approved', 'class': 'kt-badge--success'},
                                "Pending": {'expense_status': 'Pending', 'class': ' kt-badge--warning'},
                                "Rejected": {'expense_status': 'Rejected', 'class': ' kt-badge--danger'},
                                "Pending Reject": {'expense_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                            };


                            if (typeof status[data] === 'undefined') {
                                return data;
                            }

                            if(full.expense_status == "Approved"){
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="false" data-key="'+ full.expense_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].expense_status + '</span></a> &nbsp <a  data-backdrop="false" data-toggle="modal" data-key="'+ full.expense_key +'" href="#expense-details">View Details</a>';
                            }else{
                                return '<a href="#expense-details" data-toggle="modal" data-backdrop="false" data-key="'+ full.expense_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].expense_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '                                <a class="dropdown-item"  href="javascript:setExpenseStatusApproved('+ full.expense_key + ');"><i class="la la-toggle-off kt-font-success"></i> Set Approved</a>\n' +
                                    '                                <a class="dropdown-item"  href="javascript:setExpenseStatusPending('+ full.expense_key +');"><i class="la la-toggle-off kt-font-warning"></i> Set Pending</a>\n' +
                                    '                                <a class="dropdown-item" href="javascript:setExpenseStatusRejected('+ full.expense_key +');"><i class="la la-toggle-off kt-font-danger"></i> Set Rejected</a>\n' +
                                    '                                <a class="dropdown-item" href="javascript:deleteExpense('+ full.expense_key +');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" data-backdrop="false" data-toggle="modal" data-key="'+ full.expense_key +'" href="#expense-details"><i class="la la-cog"></i> Details</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            }


                        },
                    },
                ],
            });

        }

        if(tableListBin != undefined){
            // begin first table
            tableListBin.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('expenses/index/datasourcebin'.$when);?>',
                columns: [
                    {data: 'expense_date'},
                    {data: 'firstname'},
                    {data: 'category_title'},
                    {data: 'type_title'},
                    {data: 'expense_amount'},
                    {data: 'expense_payee'},
                    {data: 'expense_status'},
                ],
                columnDefs: [

                    {
                        targets: 0,
                        "width": "7%",
                    },
                    {
                        targets: 1,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('hrm/employees/index/details/');?>' + full.expense_created_by +'">' + full.firstname + " " + full.lastname + '</a>';
                        },
                    },
                    {
                        targets: 2,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('expenses/categories');?>">' + full.category_title + '</a>';
                        },
                    },
                    {
                        targets: 3,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('expenses/types');?>">' + full.type_title + '</a>';
                        },
                    },{
                        targets: 4,
                        "width": "5%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.expense_amount)).format('0,0') ;
                        },
                    },
                    {
                        // hide columns by index number
                        targets: 5,
                        "width": "15%",

                    },
                    {
                        targets: 6,
                        "width": "15%",
                        render: function(data, type, full, meta) {
                            var status = {
                                "Approved": {'expense_status': 'Approved', 'class': 'kt-badge--success'},
                                "Pending": {'expense_status': 'Pending', 'class': ' kt-badge--warning'},
                                "Rejected": {'expense_status': 'Rejected', 'class': ' kt-badge--danger'},
                                "Pending Reject": {'expense_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                            };


                            if (typeof status[data] === 'undefined') {
                                return data;
                            }

                        return  '<a href="javascript:restoreExpense('+ full.expense_key +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>';


                        },
                    }
                ],
            });

        }

	};

	return {

		//main noe function to initiate the module
		init: function() {
			initTable();
		},

	};

}();

    jQuery(document).ready(function() {
        Datatable.init();
    });


  function deleteExpense(expense){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to delete Expense",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('expenses/index/delete_expense/');?>" + expense,
                  type: "get",
                  beforeSend: function(){
                      KTApp.blockPage({
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Deleting Expenses ..."
                      });
                  },
                  success: function(result){
                      KTApp.unblockPage();
                      if( result.status == true){
                          notifySuccess(result.message);
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.ajax.reload();
                      }else{
                          swal.fire("","An error occurred! "+ result.message,"warning");
                      }
                  },
                  error: function(xhr){
                      KTApp.unblockPage();
                      <?php if(ENVIRONMENT !== 'production'){?>
                      Swal.fire('Server Error!', xhr.statusText,'danger');
                      <?php }?>
                  }

              })
          }
      })
  }

  function restoreExpense(expense){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to delete Expense",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Restore it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('expenses/index/restore_expense/');?>" + expense,
                  type: "get",
                  beforeSend: function(){
                      KTApp.blockPage({
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Deleting Expenses ..."
                      });
                  },
                  success: function(result){
                      KTApp.unblockPage();
                      if( result.status == true){
                          notifySuccess(result.message);
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.ajax.reload();
                      }else{
                          swal.fire("","An error occurred! "+ result.message,"warning");
                      }
                  },
                  error: function(xhr){
                      KTApp.unblockPage();
                      <?php if(ENVIRONMENT !== 'production'){?>
                      Swal.fire('Server Error!', xhr.statusText,'danger');
                      <?php }?>
                  }

              })
          }
      })
  }


  function setExpenseStatusApproved(expense){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to change EXPENSE STATUS!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Approve it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('expenses/index/expenseApprove/');?>" + expense,
                  type: "get",
                  beforeSend: function(){
                      KTApp.blockPage({
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Approving Expenses ..."
                      });
                  },
                  success: function(result){
                      KTApp.unblockPage();
                      if( result.status == true){
                          notifySuccess(result.message);
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.ajax.reload();
                      }else{
                          swal.fire("","An error occurred! "+ result.message,"warning");
                      }
                  },
                  error: function(xhr){
                      KTApp.unblockPage();
                      <?php if(ENVIRONMENT !== 'production'){?>
                      Swal.fire('Server Error!', xhr.statusText,'danger');
                      <?php }?>
                  }

              })
          }
      })
  }

  function setExpenseStatusPending(expense){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to change EXPENSE STATUS!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, Keep Pending it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('expenses/index/expensePending/');?>" + expense,
                  type: "get",
                  beforeSend: function(){
                      KTApp.blockPage({
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Dis-approving Expenses ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblockPage();
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.ajax.reload();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblockPage();
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function setExpenseStatusRejected(expense){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to change EXPENSE STATUS!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('expenses/index/expenseRejected/');?>" + expense,
                  type: "get",
                  beforeSend: function(){
                      KTApp.blockPage({
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Rejecting Expenses ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblockPage();
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.ajax.reload();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblockPage();
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }

  function setExpenseStatusPendingReject(expense){
      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to change EXPENSE STATUS!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, reject it!'
      }).then((result) => {
          if (result.value) {
              $.ajax({
                  url: "<?php echo base_url('expenses/index/expensePendingReject/');?>" + expense,
                  type: "get",
                  beforeSend: function(){

                      KTApp.blockPage({
                          overlayColor:"#000000",
                          type:"loader",
                          state:"danger",
                          message:"Pending reject Expenses ..."
                      });
                  },
                  success: function(result){
                      let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                          notifySuccess(obj.message);
                          KTApp.unblockPage();
                          var table = $.fn.dataTable.tables( { api: true } );
                          table.ajax.reload();
                      }else{
                          Swal.fire('',obj.message,'warning');
                      }
                  },
                  error: function(xhr){
                      KTApp.unblockPage();
                      Swal.fire('',xhr.statusText,'warning');
                  }

              })
          }
      })
  }
</script>