
<table class="table table-bordered" id="lm_expendicture">
    <thead>
    <tr>
        <th>Date</th>
        <th>Type</th>
        <th>Account</th>
        <th>Amount</th>
        <th>Payee</th>
        <th>Description</th>
        <th>Status</th>
    </tr>
    </thead>
</table>
<script  type="text/javascript">

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        let active = '"Approved"';
        var expendictures = function() {
            var expendicture = $('#lm_expendicture');

            // begin first table
            expendicture.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
        <'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url('expenses/categories/index/datasourceexpendicture/'.$category['category_key']);?>',
                columns: [
                    {data: 'expense_date'},
                    {data: 'type_title'},
                    {data: 'account_name'},
                    {data: 'expense_amount'},
                    {data: 'expense_payee'},
                    {data: 'expense_details'},
                    {data: 'expense_status'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        "width": "10%",
                    },
                    {
                        targets: 1,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="#type-details" data-toggle="modal" data-key="'+ full.type_key +'">' + full.type_title + '</a>';
                        },
                    },{
                        targets: 2,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="<?php echo base_url('accounting/index/details/');?>' + full.account_key + '">' + full.account_name + '</a>';
                        },
                    },{
                        targets: 3,
                        "width": "5%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.expense_amount)).format('0,0') ;
                        },
                    },
                    {
                        targets: 6,
                        "width": "15%",
                        render: function(data, type, full, meta) {
                            var status = {
                                "Approved": {'expense_status': 'Approved', 'class': 'kt-badge--success'},
                                "Pending": {'expense_status': 'Pending', 'class': ' kt-badge--warning'},
                                "Rejected": {'expense_status': 'Rejected', 'class': ' kt-badge--danger'},
                                "Pending Reject": {'expense_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="'+ full.expense_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].expense_status + '</span></a> ' +
                                '<div class="dropdown dropdown-inline">\n' +
                                '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                '                                <i class="flaticon-more"></i>\n' +
                                '                            </span>\n' +
                                '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                '                                <a class="dropdown-item"  href="javascript:setExpenseStatusApproved('+ full.expense_key + ');"><i class="la la-toggle-off kt-font-success"></i> Set Approved</a>\n' +
                                '                                <a class="dropdown-item"  href="javascript:setExpenseStatusPending('+ full.expense_key +');"><i class="la la-toggle-off kt-font-warning"></i> Set Pending</a>\n' +
                                '                                <a class="dropdown-item" href="javascript:setExpenseStatusRejected('+ full.expense_key +');"><i class="la la-toggle-off kt-font-danger"></i> Set Rejected</a>\n' +
                                '                                <a class="dropdown-item" href="javascript:setExpenseStatusPendingReject('+ full.expense_key +');"><i class="la la-toggle-off kt-font-dark"></i> Set Pending Rejected</a>\n' +
                                '                                <div class="dropdown-divider"></div>' +
                                '                                <a class="dropdown-item" data-backdrop="static" data-toggle="modal" data-key="'+ full.expense_key +'" href="#expense-details"><i class="la la-cog"></i> Details</a>\n' +
                                '                            </div>\n' +
                                '                        </div>';
                        },
                    }
                ],
            });
        };

        return {

            //main function to initiate the module
            init: function() {
                expendictures();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

</script>