<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author test
 */
class Index extends MY_Controller{

    public  $appdata;

    public function __construct() {
        parent::__construct();

        ( $this->require_min_level(1));
        $this->load->helper('expenses/helper');
        $this->appdata['title']= 'Expense Manager';
        $this->load->model(array(
            'expenses/ExpensesCategoriesModel'=>'expensesCategoriesModel'
        ));
    }

    public function index() {
        $this->load->model(array(
            'accounting/accounting'=>'accountingModel'
        ));

        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/categories/overview');
    }

    public function details($category ='') {
        $this->load->model(array(
            'accounting/accounting'=>'accountingModel'
        ));
        $this->appdata['category'] = $this->expensesCategoriesModel->find($category);
        $this->load->helper('form');
        $this->load->vars($this->appdata);
        $this->load->view('expenses/categories/details');
    }

    function save()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['category_branch'] = runningBranch()->branch_key;
        $data['category_title'] = $this->input->post('category_title',TRUE);
        $data['category_details'] = $this->input->post('category_details',TRUE);
        $data['category_status'] = $this->input->post('category_status',TRUE);
        $data['category_debit_account'] = $this->input->post('category_debit_account',TRUE);
        $data['category_credit_account'] = $this->input->post('category_credit_account',TRUE);
        $this->db->where('category_key',$this->input->post('key',TRUE));
        $this->db->update('expense_categories',$data);

        if($this->db->affected_rows()>0){
            $results['message'] = 'Changes applied successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to save changes';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function create()
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $data['category_title'] = $this->input->post('category_title',TRUE);
        $data['category_details'] = $this->input->post('category_details',TRUE);
        $data['category_status'] = $this->input->post('category_status',TRUE);
        $data['category_debit_account'] = $this->input->post('category_debit_account',TRUE);
        $data['category_credit_account'] = $this->input->post('category_credit_account',TRUE);
        $status = $this->expensesCategoriesModel->insert($data);

        if($status){
            $results['message'] = 'Category created successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to create category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    function delete($category)
    {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: GET, POST');
        header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

        $status = $this->expensesCategoriesModel->delete($category);
        if($status){
            $results['message'] = 'Category deleted successfully';
            $results['status'] = true;
        }else{
            $results['message'] = 'Failed to delete category';
            $results['status'] = false;
        }

        echo json_encode($results, JSON_PRETTY_PRINT);
    }

    public function expenditure($category ='') {
        $this->appdata['category'] = $this->expensesCategoriesModel->details($category);
        $this->load->vars($this->appdata);
        $this->load->view('expenses/categories/expenditure');
    }

    function datasource(){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $data = $this->expensesCategoriesModel->find_all();
        $columns = array();
        foreach ($this->expensesCategoriesModel->selectable_fields as $field){
            $columns[$field] = TRUE;
        }
        print $this->datasourceLibrary->server($data,$columns);

    }

    function datasourceexpendicture($category='',$when=''){
        $this->load->library(array('DatasourceLibrary'=>'datasourceLibrary'));
        $categories = $this->expensesCategoriesModel->expendicture($category,$when);
        $columns = [
            'user' => true,
            'expense_date' => true,
            'account_name' => true,
            'account_key' => true,
            'type_title' => true,
            'expense_details' => true,
            'expense_payee' => true,
            'expense_paid' => true,
            'expense_status' => true,
            'expense_amount' => true,
            'account_id' => true,
            'expense_key' => true,
        ];
        print $this->datasourceLibrary->server($categories,$columns);
    }


}