<?php echo form_open('#',['id'=>'formBudget','onsubmit'=>'savebudget(); return false;']);?>
<input required type="hidden" value="<?php echo $budget['budget_key'];?>" name="key">
<div class="form-group row">
    <div class="col-12">
        <textarea class="form-control" name="budget_details" placeholder="Budget Description"><?php echo $budget['budget_details'];?></textarea>
    </div>
</div>

<div class="form-group row">
    <div class="col-5">
        <input required type="text" value="<?php echo $budget['budget_title'];?>" name="budget_title" placeholder="Enter budget name" class="form-control">
    </div>
    <div class="col-4">
        <select required name="budget_status" class="form-control">
            <option value="">Select Status</option>
            <option <?php if(strtolower($budget['budget_status']) == "active") echo 'selected';?> value="Active">Active</option>
            <option <?php if(strtolower($budget['budget_status']) == "pending") echo 'selected';?> value="Pending">Pending</option>
            <option <?php if(strtolower($budget['budget_status']) == "rejected") echo 'selected';?> value="Rejected">Rejected</option>
            <option <?php if(strtolower($budget['budget_status']) == "pending reject") echo 'active';?> value="Pending Reject">Pending Reject</option>
        </select>
    </div>
    <div class="col-3">
        <button type="submit" class="btn btn-pill btn-elevate-air btn-outline-brand text-uppercase pull-right kt-font-bolder">Save Changes</button>
    </div>
</div>
<?php echo form_close();?>

<script  type="text/javascript">
    $( function(){
        $("select").select2();
    })

    function savebudget(){
        let form  = $("form#formBudget");
        let formdata = form.serialize();
        $.ajax({
            url: "<?php echo base_url('expenses/budgets/index/save/'.$budget['budget_key']);?>",
            data: formdata,
            type: "post",
            beforeSend: function () {
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"brand",
                    message:"Sending data ..."
                });
            },
            success: function (response) {
                KTApp.unblock(form);
                if(response.status == true){
                    $("div#budget-details").modal("hide");
                    notifySuccess(response.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",response.message,"warning");
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire("Server response","Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>","warning");
            }
        })
    }
</script>