<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifyCurrencyForm" action="#" onsubmit="return false;">
    <div class="kt-portlet__body">
      <div class="form-group validated">
        <label class="form-control-label" for="inputSuccess1">Currency payee</label>
         <input name="currency" value="<?php echo $currency->currency;?>" class="form-control" placeholder="Enter currency" maxlength="30">
      </div>
      <div class="form-group validated">
        <label class="form-control-label" for="inputSuccess1">Currency symbol</label>
         <input name="currency_symbol" value="<?php echo $currency->currency_symbol;?>" class="form-control" placeholder="Enter currency symbol" maxlength="30">
      </div>
      <div class="form-group validated">
        <label class="form-control-label" for="inputSuccess1">Currency code</label>
         <input name="currency_code" value="<?php echo $currency->currency_code;?>" class="form-control" placeholder="Enter currency code" maxlength="30">
      </div>
      <div class="form-group validated">
        <label class="form-control-label" for="inputSuccess1">Currency Convention</label>
         <input name="currency_convention" value="<?php echo number_format($currency->currency_convention);?>" class="form-control number" placeholder="Enter currency convention" maxlength="30">
      </div>
    <div class="kt-portlet__foot pull-right">
      <div class="kt-form__actions">
        <button type="submit" class="btn btn-success">Save Changes</button>
        <button type="button" data-dismiss="modal" class="btn btn-warning">Cancel</button>
      </div>
    </div>
</div>
  </form>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);
$('select').select2({placeholder:'Select Option'});

$('form#modifyCurrencyForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/settings/currencies/modifyaction/'.$currency->currency_key);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Currency ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('.kt-datatable').KTDatatable('reload');
            $('div#currencyDetails').modal('hide');
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#currencyDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})
</script>
