<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyCollateralForm" class="kt-form" action="#" method="get" onsubmit="return false">
  <div class="form-groupn row">
    <div class="col-12">
      <label class="col-form-label">Product Name</label>
      <input name="product_name" value="<?php echo $product->product_name;?>" class="form-control" type="text" >
    </div>
  </div>
  <div class="form-groupn row">
    <div class="col-12">
      <label class="col-form-label">Interest Rate (Annum) %</label>
      <input name="product_interest_rate" value="<?php echo $product->product_interest_rate;?>" class="form-control" type="text" >
    </div>
  </div>
  <div class="form-groupn row">
    <div class="col-12">
      <label class="col-form-label">Interest Posting Frequency on Savings Accounts</label>
      <select name="product_interest_frequency" class="form-control" name="">
        <option <?php if($product->product_interest_frequency == 1) echo 'selected';?> value="1">Every 1 Month</option>
        <option <?php if($product->product_interest_frequency == 2) echo 'selected';?> value="2">Every 2 Months</option>
        <option <?php if($product->product_interest_frequency == 3) echo 'selected';?> value="3">Every 3 Months</option>
        <option <?php if($product->product_interest_frequency == 4) echo 'selected';?> value="4">Every 4 Months</option>
        <option <?php if($product->product_interest_frequency == 6) echo 'selected';?> value="6">Every 6 Months</option>
        <option <?php if($product->product_interest_frequency == 12) echo 'selected';?> value="12">Every 12 Months</option>
      </select>
    </div>
  </div>
  <div class="form-groupn row">
    <div class="col-12">
      <label class="col-form-label">When should Interest be added to Saving Account?</label>
      <select name="product_interest_add_day" class="form-control" name="">
        <?php for ($i=1; $i < 32; $i++) {
          if($i == 1){ $th = 'st'; }
          if($i == 2){ $th = 'nd'; }
          if($i == 3){ $th = 'rd'; }
          if($i > 3){ $th = 'th'; }?>
          <option <?php if($product->product_interest_add_day == $i) echo 'selected';?>  value="<?php echo $i;?>"><?php echo $i.'<sup>'.$th.' of the month</sup>';?></option>
        <?php } ?>
      </select>
    </div>
  </div>
  <div class="form-groupn row">
    <div class="col-12">
      <label class="col-form-label">Minimum Balance for Interest Rate</label>
      <input value="<?php echo number_format(to_money($product->product_minimun_balance_for_interest));?>" name="product_minimun_balance_for_interest" class="form-control number" type="text" >
    </div>
  </div>
  <div class="form-groupn row">
    <div class="col-12">
      <label class="col-form-label">Minimum Balance for Withdrawal</label>
      <input value="<?php echo number_format(to_money($product->product_minimum_balance_for_withdraw));?>" name="product_minimum_balance_for_withdraw" class="form-control number" type="text" >
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <label class="col-form-label">Product Description</label>
      <textarea name="product_details" class="form-control" rows="4" cols="80"><?php echo $product->product_details;?></textarea>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-8 col-form-label"></label>
    <div class="col-4">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>SAVE CHANGES</b></button>
    </div>
  </div>
</form>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$('form#modifyCollateralForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/savings/products/update/'.$product->product_key);?>',
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Saving product ..."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('.kt-datatable').KTDatatable('reload');
            $('div#details').modal('hide');
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#productDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})

</script>
