<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="employees_workstatus_update" onsubmit="return false;" class="kt-form">
  <div class="kt-section kt-section--first">
    <div class="kt-section__body">
      <div class="form-group row">
        <label class="col-3 col-form-label">Basic Sallary (monthly)</label>
        <div class="col-3">
          <input name="ew_date_joined" required class="form-control number" type="text" value="">
        </div>
        <div class="col-3">
          <button type="submit" class="btn btn-block btn-info" name="button"><b>Save Changes</b></button>
        </div>
      </div>
    </div>
  </div>
</form>
<hr/>
<?php $taxes = $this->payrollsModel->employeeTaxes($employee->user_id);?>
<table class="table table-info table-bordered">
  <thead>
    <tr>
      <th>Statutory</th>
      <th>Percentage</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!empty($taxes)){
      foreach ($taxes as $key => $tax) {?>
        <tr>
          <td><?php echo $tax['payroll_tax_name'];?></td>
          <td><?php echo $tax['payroll_tax_percent'];?></td>
        </tr>
      <?php }
    } ?>
    <tr>
      <th></th>
    </tr>
  </tbody>
</table>
<form class="kt-form" action="index.html" method="post">
  <?php $ptaxes = $this->payrollsModel->taxes();?>
  <div class="form-group row">
        <label class="col-3 col-form-label">Add Statutory</label>
    <div class="col-3">
      <select class="form-control" name="app_officer">
        <?php
          if(!empty($ptaxes)){
              foreach ($ptaxes as $key => $ptax) {?>
                <option  value="<?php echo $ptax['payroll_tax_key'];?>"><?php echo $ptax['payroll_tax_name'];?></option>
              <?php }
          } ?>
      </select>
    </div>
    <div class="col-3">
      <button type="button" class="btn btn-info btn-block" name="button"><b>Submit</b></button>
    </div>
  </div>
</form>
<hr/>

<?php $evariables = $this->payrollsModel->employeeVariables($employee->user_id);?>
<table class="table table-info table-bordered">
  <thead>
    <tr>
      <th colspan="2">Deductions</th>
    </tr>
    <tr>
      <th>Variable</th>
      <th>Amount</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!empty($evariables)){
        foreach ($evariables as $key => $evariable) {
          if($evariable['variable_type'] == 'deduct'){?>
        <tr>
          <td><?php echo ucfirst(strtolower($evariable['variable_name']));?></td>
          <td><?php echo to_money($evariable['variable_amount']);?></td>
        </tr>
      <?php }
      }
    } ?>
    <tr>
      <th></th>
    </tr>
  </tbody>
</table>
<form class="kt-form" action="index.html" method="post">
  <div class="form-group row">
        <label class="col-3 col-form-label">Add Earning</label>
    <div class="col-3">
      <?php $variables = $this->payrollsModel->variables();?>
      <select class="form-control" name="app_officer">
        <?php
          if(!empty($variables)){
              foreach ($variables as $key => $variable) {
                if($variable['variable_type'] == 'pay'){?>
                <option  value="<?php echo $variable['variable_key'];?>"><?php echo $variable['variable_name'];?></option>
              <?php }
            }
          } ?>
      </select>
    </div>
    <div class="col-3">
      <button type="button" class="btn btn-info btn-block" name="button"><b>Submit</b></button>
    </div>
  </div>
</form>

<hr/>

<?php $evariables = $this->payrollsModel->employeeVariables($employee->user_id);?>
<table class="table table-info table-bordered">
  <thead>
    <tr>
      <th colspan="2">Earnings</th>
    </tr>
    <tr>
      <th>Variable</th>
      <th>Amount</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!empty($evariables)){
        foreach ($evariables as $key => $evariable) {
          if($evariable['variable_type'] == 'pay'){?>
        <tr>
          <td><?php echo ucfirst(strtolower($evariable['variable_name']));?></td>
          <td><?php echo to_money($evariable['variable_amount']);?></td>
        </tr>
      <?php }
      }
    } ?>
    <tr>
      <th></th>
    </tr>
  </tbody>
</table>
<form class="kt-form" action="index.html" method="post">
  <div class="form-group row">
        <label class="col-3 col-form-label">Add Earning</label>
    <div class="col-3">
      <?php $variables = $this->payrollsModel->variables();?>
      <select class="form-control" name="app_officer">
        <?php
          if(!empty($variables)){
              foreach ($variables as $key => $variable) {
                if($variable['variable_type'] == 'pay'){?>
                <option  value="<?php echo $variable['variable_key'];?>"><?php echo $variable['variable_name'];?></option>
              <?php }
            }
          } ?>
      </select>
    </div>
    <div class="col-3">
      <button type="button" class="btn btn-info btn-block" name="button"><b>Submit</b></button>
    </div>
  </div>
</form>
<script type="text/javascript">
$('select.ew_worktype').select2({placeholder: 'Select option'});
$('select#stateId').select2({placeholder: 'Select state'});
$('select#cityId').select2({placeholder: 'Select city'});
$('form#employees_workstatus').submit( function(event){
  let form = $( this );
  let $div =  $('div#kt_page_portlet');
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('employee/administration/employees/index/loadInformationWorkStatus/'.$employee->user_id);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block($div,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Work information ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $div.load("<?php echo base_url('employee/administration/employees/index/loadInformationWorkStatus/'.$employee->user_id);?>");
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock($div);
         },
      error: function(xhr){
        Swal.fire('',xhr.statusText,'error');
          KTApp.unblock($div);
          }
  });
})
$('form#employees_workstatus_update').submit( function(event){
  let form = $( this );
  let $div =  $('div#kt_page_portlet');
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('employee/administration/employees/index/loadInformationWorkStatus/'.$employee->user_id);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block($div,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Work information ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $div.load("<?php echo base_url('employee/administration/employees/index/loadInformationWorkStatus/'.$employee->user_id);?>");
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock($div);
         },
      error: function(xhr){
        Swal.fire('',xhr.statusText,'error');
          KTApp.unblock($div);
          }
  });
})
</script>
