<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifyvariableForm" action="#" onsubmit="return false;">
  <div class="form-group row">
    <div class="col-12">
      <input required type="text" value="<?php echo $variable->variable_name;?>" maxlength="30" name="variable_name" class="form-control" placeholder="Variable name">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <select required class="form-control" name="variable_type">
        <option <?php if(strtolower($variable->variable_type) == 'pay') echo 'selected';?> value="pay">Pay</option>
        <option <?php if(strtolower($variable->variable_type) == 'deduct') echo 'selected';?> value="deduct">Deduct</option>
      </select>
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <input required type="text" value="<?php echo number_format(to_money($variable->variable_amount));?>" maxlength="30" name="variable_amount" class="form-control number" placeholder="Variable amount">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <textarea class="form-control" name="variable_details" rows="3" cols="80" placeholder="Variable details"><?php echo $variable->variable_details;?></textarea>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-8 col-form-label"></label>
    <div class="col-4">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>UPDATE VARIABLE</b></button>
    </div>
  </div>
  </form>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$('form#modifyvariableForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('admin/payrolls/variables/updatevariable/'.$variable->variable_key);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Variable ..."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('.kt-datatable').KTDatatable('reload');
            $('div#variableDetails').modal('hide');
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#variableDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})
</script>
