<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-scroll" data-scroll="true" data-height="400" style="height: 400px; overflow-y: scroll;">
<div class="kt-portlet__head kt-portlet__head--md">
  <div class="kt-portlet__head-label"  style="width:100%;">
    <h3 class="kt-portlet__head-title"><?php echo ucwords($employee->firstname.' '.$employee->middlename.' '.$employee->lastname);?></h3>
  </div>
</div>
<hr/>
<div class="kt-portlet__body">
  <form id="employeesForm" onsubmit="return false;" class="kt-form">
        <div class="form-group row">
          <label class="col-3 col-form-label">Net Salary</label>
          <div class="col-3">
            <input name="net_salary" class="form-control number" type="text" value="<?php echo number_format(to_money($employee->net_salary));?>">
          </div>
        </div>
        <hr/>
        <div class="row">
          <div class="col-md-6">
            <label class="col-md-12 col-form-label"><h5>Select Payroll Taxes</h5></label>
            <div class="row">
              <?php if(!empty($taxes)){
                foreach ($taxes as $key => $tax) {?>
                <div class="col-md-6">
                    <label class="kt-option kt-option--plain">
                      <span class="kt-option__control">
                        <label class="kt-checkbox kt-checkbox--solid kt-checkbox--brand">
                            <input type="checkbox" <?php if(isEmployeeTax($employee->user_id,$tax['payroll_tax_key'])) echo 'checked="checked"';?> name="payroll_tax[]" value="<?php echo $tax['payroll_tax_key'];?>">
                            <span></span>
                        </label>
                      </span>
                      <span class="kt-option__label">
                        <span class="kt-option__head">
                          <span class="kt-option__title">
                            <?php echo $tax['payroll_tax_name'].' '.$tax['payroll_tax_percent'].'%';?>
                          </span>
                        </span>
                        <span class="kt-option__body">
                          <?php echo $tax['payroll_tax_details'];?>
                        </span>
                      </span>
                    </label>
                </div>
                <div class="col-md-4">
                    <div class="">
                      <input type="text" <?php if($now = isEmployeeTax($employee->user_id,$tax['payroll_tax_key'])) {
                        if(!empty($now->et_overide_value)){?>
                          value="<?php echo number_format(to_money($now->et_overide_value));?>"
                      <?php  }
                    }?> name="payroll_tax_overide[]" class="form-control number" placeholder="Enter value to overide">
                    </div>
                </div>
              <?php }  } ?>
            </div>
          </div>
          <div class="col-md-6">
            <label class="col-md-12 col-form-label"><h5>Variables (<b>Pay, Deduction & Bonus</b>)</h5></label>
            <div class="row">
                  <?php if(!empty($variables)){
                    foreach ($variables as $k => $variable) {?>
                    <div class="col-md-7">
                        <div class="">
                              <label class="kt-option kt-option--plain">
                                <span class="kt-option__control">
                                  <label class="kt-checkbox kt-checkbox--solid kt-checkbox--brand">
                                      <input type="checkbox" <?php if(isEmployeeVariable($employee->user_id,$variable['variable_key'])) { echo 'checked="checked"';}?> name="payroll_variable[]" value="<?php echo $variable['variable_key'];?>">
                                      <span></span>
                                  </label>
                                </span>
                                <span class="kt-option__label">
                                  <span class="kt-option__head">
                                    <span class="kt-option__title">
                                      <?php echo $variable['variable_name'].' '.$variable['variable_type'];?>
                                    </span>
                                  </span>
                                  <span class="kt-option__body">
                                    <?php echo number_format(to_money($variable['variable_amount']));?>
                                  </span>
                                </span>
                              </label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="">
                          <input type="text" <?php if($noy = isEmployeeVariable($employee->user_id,$variable['variable_key'])) {
                            if(!empty($noy->ev_overide_value)){?>
                              value="<?php echo number_format(to_money($now->ev_overide_value));?>"
                          <?php  }
                          }?> name="payroll_variable_overide[]" class="form-control number" placeholder="Enter value to overide">
                        </div>
                    </div>
                      <?php }
                    } ?>
              </div>
          </div>
        </div>
<hr/>
          <div class="row">
            <label class="col-md-7 col-form-label"></label>
            <div class="col-md-4">
              <button type="button" data-dismiss="modal" class="btn btn-sm btn-block btn-danger" name="button"><b>Cancel</b></button>
              <button type="submit" class="btn btn-sm btn-block btn-success" name="button"><b>Process Payroll</b></button>
            </div>
          </div>
        </div>
      </div>
</form>
</div>
</div>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$('form#employeesForm').submit( function(event){
  let form = $( this );
  let $div =  $('div.kt-portlet__body');
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('admin/payrolls/index/processoraction/'.$employee->user_id);?>',
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block($div,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Processing payroll ..."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            Swal.fire('',obj.message,'success');
            window.location.reload();
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock($div);
         },
      error: function(){
        Swal.fire('',obj.message,'success');
          KTApp.unblock($div);
          }
  });
})

</script>
