<form id="companyLiabilities" onsubmit="return false;" class="kt-form">
      <div class="kt-section kt-section--first">
        <div class="kt-section__body">
          <div class="form-group row">
            <div class="col-12">
              <div class="alert alert-outline-brand" role="alert">
                <div class="alert-text">
                  <h4 class="alert-heading">NOTE</h4>
                  <p>All seetings made here will apply to all <b>Employees</b></p>
                </div>
              </div>
            </div>
          </div>
              <div class="form-group row">
                <div class="col-6">
                  <label for="">Liability</label>
                  <input name="ctc_name" value="<?php echo $liability->ctc_name;?>" class="form-control" placeholder="Enter liability name e.g (WCF)">
                </div>

                <div class="col-6">
                  <label for="">Rate</label>
                  <input name="ctc_amount" value="<?php echo number_format(to_money($liability->ctc_amount));?>" class="form-control number" placeholder="Enter liability amount">
                </div>
              </div>
              <div class="form-group row">
                <div class="col-6">
                  <label for="">Rate type</label>
                  <select class="form-control" required name="ctc_rate">
                    <option value="">Rate type</option>
                    <option <?php if(strtolower($liability->ctc_rate) =='fixed') echo 'selected';?> value="fixed">Fixed</option>
                    <option <?php if(strtolower($liability->ctc_rate) =='percentage') echo 'selected';?> value="percentage">Percentage</option>
                  </select>
                </div>
                <div class="col-6">
                  <label for="">&nbsp</label>
                  <button type="submit" class="btn btn-block btn-brand text-uppercase"><b>Update Liability</b></button>
                </div>
            </div>
          </div>
        </div>
</form>

  <script type="text/javascript">
  $('select').select2({placeholder:'Select option'});
  (function($, undefined) {
      "use strict";
      // When ready.
      $(function() {
        var $input = $( "input.number" );
        $input.on( "keyup", function( event ) {
            // When user select text in the document, also abort.
            var selection = window.getSelection().toString();
            if ( selection !== '' ) {
                return;
            }
            // When the arrow keys are pressed, abort.
            if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                return;
            }
            var $this = $( this );
            // Get the value.
            var input = $this.val();
            var input = input.replace(/[\D\s\._\-]+/g, "");
            input = input ? parseInt( input, 10 ) : 0;
            $this.val( function() {
                return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
            } );
        });
      });
  })(jQuery);

  $('form#companyLiabilities').submit( function(event){
    let form = $( this );
    let $div =  $('div.kt-datatable');
    event.preventDefault();
    let formdata = form.serialize();
    $.ajax({
     url: '<?php echo base_url('admin/payrolls/company/updateCompanyLiability/'.$liability->ctc_key);?>' ,
      type: 'get',
      data: formdata,
      beforeSend: function(){
          KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Updating Liability details ...."
              });
        },
       success: function(r){
            var obj = JSON.parse(r);
            if(obj.status == 'ok'){
              $('form#companyLiabilities')[0].reset();
              $('.kt-datatable').KTDatatable('reload');
              notifySuccess(obj.message);
              }else{
                  Swal.fire('',obj.message,'warning');
              }
              KTApp.unblock($div);
              $('div#itemDetails').modal('hide');
           },
        error: function(xhr){
            Swal.fire('',xhr.statusText,'warning');
            KTApp.unblock($div);
            $('div#itemDetails').modal('hide');
            }
    });
  })
  </script>
