<script type="text/javascript">

  var LMDatatableProducts = function() {
    	var initTable = function() {
    		// begin first table
    		var table = $('#lm_table_products').DataTable({

    			responsive: true,
    			// Pagination settings
    			dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			// read more: https://datatables.net/examples/basic_init/dom.html

    			lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],

    			pageLength: 10,

    			language: {
    				'lengthMenu': 'Display _MENU_',
            buttons: {
                selectAll: "Select all",
                selectNone: "Select none"
            },
            "emptyTable": "No record found",
    			},
    			searchDelay: 500,
    			processing: true,
    			serverSide: true,
    			select:true,
          "ajax":"<?php echo base_url($auth_role.'/loans/products/datasource');?>",
    			dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			buttons: [
            {
              text: 'Delete Seleted',
              action: function ( e, dt, node, config ) {
                  deleteSelected( table);
                }
            },
            'selectAll',
            'selectNone',
    				'excelHtml5',
    				'pdfHtml5',
    			],
          columns: [
            {data: 'product_name'},
            {data: 'product_details'},
            {data: 'product_date_created'},
            {data: 'product_date_modified'},
          ],
          columnDefs: [
            {
              targets: 4,
              render: function(data, type, full, meta){
                return '<a href="javascript:details(' + full.product_key + ');"><i class="flaticon-eye text-success"></i></a> | <a href="javascript:modify(' + full.product_key + ');"><i class="flaticon-edit text-warning"></i></a> | <a href="javascript:deleteItem(' + full.product_key + ');"><i class="flaticon-delete text-danger"></i></a>';
              }
            },
          ],
    		});

    		var filter = function() {
    			var val = $.fn.dataTable.util.escapeRegex($(this).val());
    			table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
    		};

    		var asdasd = function(value, index) {
    			var val = $.fn.dataTable.util.escapeRegex(value);
    			table.column(index).search(val ? val : '', false, true);
    		};
    	};

    	return {
    		//main function to initiate the module
    		init: function() {
    			initTable();
    		},

    	};

    }();

  jQuery(document).ready(function() {
  	LMDatatableProducts.init();
    $('form#newProductForm').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
       url: '<?php echo base_url($auth_role.'/loans/products/register/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newProductForm",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Creating new Product ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                var table = $.fn.dataTable.tables( { api: true } );
                table.clear().draw();
                notifySuccess(obj.message);
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newProductForm');
                $('div#newProduct').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newProductForm');
              }
      });
    });
  });


      function details(product){
        let $modal =  $('div#details');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
          url: '<?php echo base_url($auth_role.'/loans/products/details/');?>' + product,
          type: 'get',
          beforeSend: function(){
          KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Loading product details ...."
              });
          },
          success: function (result){
            $div.html(result);
            KTApp.unblock($div);
          },
          error: function (xhr){
            $modal.modal('hide');
            KTApp.unblock($div);
            Swal.fire('',xhr.statusText,'warning');
          }
        })
      }

      function modify(product){
        let $modal =  $('div#details');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
          url: '<?php echo base_url($auth_role.'/loans/products/modify/');?>' + product,
          type: 'get',
          beforeSend: function(){
          KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Loading product details ...."
              });
          },
          success: function (result){
            $div.html(result);
            KTApp.unblock($div);
          },
          error: function (xhr){
            $modal.modal('hide');
            KTApp.unblock($div);
            Swal.fire('',xhr.statusText,'warning');
          }
        })
      }

    function deleteItem(product){
        Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
          if (result.value) {
            $.ajax({
                url: '<?php echo base_url($auth_role.'/loans/products/delete/product')?>/'+product,
                type: 'get',
                beforeSend: function(){
                    KTApp.block(".kt-datatable",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting Product ..."
                        });
                  },
                 success: function(result){
                     let obj = JSON.parse(result);
                         if( obj.status == 'ok'){
                           notifySuccess(obj.message);
                           var table = $.fn.dataTable.tables( { api: true } );
                           table.clear().draw();
                          }else{
                            Swal.fire('',obj.message,'warning');
                          }
                     KTApp.unblock('.kt-datatable');  KTApp.unblock('.kt-datatable');
                     },
                  error: function(xhr){
                      KTApp.unblock('.kt-datatable');
                      Swal.fire('',xhr.statusText,'warning');
                      }
            });
          }
        })
      }

  function deleteSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["product_key"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to DELETE " + table.rows('.selected').data().length + " products",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Delete them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/products/deleteselected/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        notifyWarning(obj.message)
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

  document.querySelector("#print").addEventListener("click", function() {
    printJS({ printable: 'printArea', type: 'html', header: '<?php echo config_item('application_name');?> - Product Details',css:'<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css','style':'link{text-decoration:none;}'});
  });
</script>
