<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyCollateralForm" class="kt-form" action="#" method="get" onsubmit="return false">
  <div class="form-group row">
    <label class="col-4 col-form-label">Collateral Name</label>
    <div class="col-8">
      <input name="product_name" value="<?php echo $product->product_name;?>"class="form-control" type="text" >
    </div>
  </div>
  <div class="form-group row">
    <label class="col-4 col-form-label">Collateral Description</label>
    <div class="col-8">
      <textarea name="product_details" class="form-control" rows="4" cols="80"><?php echo $product->product_details;?></textarea>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-8 col-form-label"></label>
    <div class="col-4">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>SAVE CHANGES</b></button>
    </div>
  </div>
</form>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$('form#modifyCollateralForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('admin/loans/products/update/'.$product->product_key);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Collateral ..."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('.kt-datatable').KTDatatable('reload');
            $('div#details').modal('hide');
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#productDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})

</script>
